/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.common.entity.InspectorEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.UrlUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(path={"/inspector"})
@Api(tags={"\u5168\u94fe\u8def\u4fa6\u6d4b\u63a5\u53e3"})
public class InspectorEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(InspectorEndpoint.class);
    @Autowired
    private RestTemplate pluginRestTemplate;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired(required=false)
    private PluginContextHolder pluginContextHolder;

    @RequestMapping(path={"/inspect"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4fa6\u6d4b\u5168\u94fe\u8def\u8def\u7531", notes="", response=InspectorEntity.class, httpMethod="POST")
    @ResponseBody
    public InspectorEntity inspect(@RequestBody @ApiParam(value="\u4fa6\u6d4b\u5bf9\u8c61", required=true) InspectorEntity inspectorEntity) {
        List serviceIdList = inspectorEntity.getServiceIdList();
        String result = inspectorEntity.getResult();
        if (StringUtils.isEmpty((CharSequence)result) && this.pluginContextHolder != null) {
            result = this.pluginContextHolder.getContext("endpoint-inspector-inspect");
        }
        String pluginInfo = this.pluginAdapter.getPluginInfo(result);
        inspectorEntity.setResult(pluginInfo);
        if (CollectionUtils.isNotEmpty((Collection)serviceIdList)) {
            String nextServiceId = (String)serviceIdList.get(0);
            serviceIdList.remove(0);
            String url = null;
            try {
                String contextPath = this.getContextPath(nextServiceId);
                url = "http://" + nextServiceId + contextPath + "inspector/inspect";
                return (InspectorEntity)this.pluginRestTemplate.postForEntity(url, (Object)inspectorEntity, InspectorEntity.class, new Object[0]).getBody();
            }
            catch (Exception e) {
                String exceptionMessage = "Failed to inspect, current serviceId=" + this.pluginAdapter.getServiceId() + ", next serviceId=" + nextServiceId + ", url=" + url;
                LOG.error(exceptionMessage, (Throwable)e);
                throw new DiscoveryException(exceptionMessage, (Throwable)e);
            }
        }
        return inspectorEntity;
    }

    private String getContextPath(String serviceId) {
        ServiceInstance instance = this.getInstance(serviceId);
        String contextPath = this.pluginAdapter.getInstanceContextPath(instance);
        return UrlUtil.formatContextPath((String)contextPath);
    }

    private ServiceInstance getInstance(String serviceId) {
        List instances = null;
        try {
            instances = this.discoveryClient.getInstances(serviceId);
        }
        catch (Exception e) {
            throw new DiscoveryException("Failed to get instance list, serviceId=" + serviceId, (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)instances)) {
            throw new DiscoveryException("Instance list is empty, serviceId=" + serviceId);
        }
        return (ServiceInstance)instances.get(0);
    }
}

