/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/sentinel-param"})
@Api(tags={"\u54e8\u5175\u53c2\u6570\u63a5\u53e3"})
public class SentinelParamEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SentinelParamEndpoint.class);
    private static Converter<String, List<ParamFlowRule>> sentinelParamFlowRuleParser = new Converter<String, List<ParamFlowRule>>(){

        public List<ParamFlowRule> convert(String source) {
            return (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ParamFlowRule>>(){}, (Feature[])new Feature[0]);
        }
    };
    @Autowired
    private PluginContextAware pluginContextAware;

    @RequestMapping(path={"/update-param-flow-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u70ed\u70b9\u53c2\u6570\u6d41\u63a7\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> updateParamFlowRules(@RequestBody @ApiParam(value="\u70ed\u70b9\u53c2\u6570\u6d41\u63a7\u89c4\u5219\u5185\u5bb9\uff0cJSON\u683c\u5f0f", required=true) String rule) {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        ParamFlowRuleManager.loadRules((List)((List)sentinelParamFlowRuleParser.convert((Object)rule)));
        LOG.info("{} param flow rules loaded...", (Object)ParamFlowRuleManager.getRules().size());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/clear-param-flow-rules"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6e05\u9664\u70ed\u70b9\u53c2\u6570\u6d41\u63a7\u89c4\u5219\u5217\u8868", notes="", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    public ResponseEntity<?> clearParamFlowRules() {
        Boolean isConfigRestControlEnabled = this.pluginContextAware.isConfigRestControlEnabled();
        if (!isConfigRestControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Config rest control is disabled");
        }
        LOG.info("{} param flow rules cleared...", (Object)ParamFlowRuleManager.getRules().size());
        ParamFlowRuleManager.loadRules(new ArrayList());
        return ResponseEntity.ok().body((Object)"OK");
    }

    @RequestMapping(path={"/view-param-flow-rules"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u70ed\u70b9\u53c2\u6570\u6d41\u63a7\u89c4\u5219\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public ResponseEntity<List<ParamFlowRule>> viewParamFlowRules() {
        return ResponseEntity.ok().body((Object)ParamFlowRuleManager.getRules());
    }
}

