/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class UuidUtil {
    public static final String DATE_FORMAT = "yyyyMMdd-HHmmss-SSS";
    public static final String SEPARATOR = "-";
    public static final String RANDOMS_EPARATOR = "-";
    public static final int[] RANDOM_ARRAY = new int[]{9999, 999, 999};

    public static String getTimeUUID() {
        return UuidUtil.getTimeUUID(null);
    }

    public static String getTimeUUID(String prefix) {
        return UuidUtil.getTimeUUID(prefix, RANDOM_ARRAY);
    }

    public static String getTimeUUID(String prefix, int[] randomArray) {
        return UuidUtil.getTimeUUID(prefix, DATE_FORMAT, randomArray, "-", "-");
    }

    public static String getTimeUUID(String prefix, String dataFormat) {
        return UuidUtil.getTimeUUID(prefix, dataFormat, RANDOM_ARRAY, "-", "-");
    }

    public static String getTimeUUID(String prefix, String dataFormat, int[] randomArray, String separator, String randomSeparator) {
        if (dataFormat == null) {
            throw new IllegalArgumentException("dataFormat can't be null");
        }
        if (randomArray == null) {
            throw new IllegalArgumentException("randomArray can't be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            stringBuilder.append(prefix).append(separator);
        }
        stringBuilder.append(new SimpleDateFormat(dataFormat).format(new Date())).append(separator);
        for (int random : randomArray) {
            String result = UuidUtil.random(random, String.valueOf(random).length());
            stringBuilder.append(result).append(randomSeparator);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String random(int random, int padSize) {
        return StringUtils.leftPad((String)String.valueOf(RandomUtils.nextInt((int)0, (int)random)), (int)padSize, (String)"0");
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }
}

