/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.entity;

import com.nepxion.discovery.common.entity.InstanceEntity;
import com.nepxion.discovery.common.util.UrlUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InstanceEntityWrapper {
    public static String getProtocol(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.getProtocol(metadata);
    }

    public static String getContextPath(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.getContextPath(metadata);
    }

    public static String getFormatContextPath(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.getFormatContextPath(metadata);
    }

    public static String getGroup(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.getGroup(metadata);
    }

    public static String getPlugin(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.getPlugin(metadata);
    }

    public static boolean isRegisterControlEnabled(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.isRegisterControlEnabled(metadata);
    }

    public static boolean isDiscoveryControlEnabled(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.isDiscoveryControlEnabled(metadata);
    }

    public static boolean isConfigRestControlEnabled(InstanceEntity instanceEntity) {
        Map<String, String> metadata = instanceEntity.getMetadata();
        return InstanceEntityWrapper.isConfigRestControlEnabled(metadata);
    }

    public static String getProtocol(Map<String, String> metadata) {
        String protocol = metadata.get("spring_application_protocol");
        if (StringUtils.isEmpty((CharSequence)protocol)) {
            return "http";
        }
        return protocol;
    }

    public static String getContextPath(Map<String, String> metadata) {
        String contextPath = metadata.get("spring_application_context-path");
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            return "/";
        }
        return contextPath;
    }

    public static String getFormatContextPath(Map<String, String> metadata) {
        String contextPath = InstanceEntityWrapper.getContextPath(metadata);
        return UrlUtil.formatContextPath(contextPath);
    }

    public static String getGroup(Map<String, String> metadata) {
        String groupKey = metadata.get("spring_application_group_key");
        if (StringUtils.isEmpty((CharSequence)groupKey)) {
            return "";
        }
        String group = metadata.get(groupKey);
        if (group == null) {
            return "";
        }
        return group;
    }

    public static String getPlugin(Map<String, String> metadata) {
        String plugin = metadata.get("spring_application_discovery_plugin");
        if (plugin == null) {
            return "";
        }
        return plugin;
    }

    public static boolean isRegisterControlEnabled(Map<String, String> metadata) {
        String flag = metadata.get("spring_application_register_control_enabled");
        if (flag == null) {
            return true;
        }
        return Boolean.valueOf(flag);
    }

    public static boolean isDiscoveryControlEnabled(Map<String, String> metadata) {
        String flag = metadata.get("spring_application_discovery_control_enabled");
        if (flag == null) {
            return true;
        }
        return Boolean.valueOf(flag);
    }

    public static boolean isConfigRestControlEnabled(Map<String, String> metadata) {
        String flag = metadata.get("spring_application_config_rest_control_enabled");
        if (flag == null) {
            return true;
        }
        return Boolean.valueOf(flag);
    }
}

