/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.entity;

public enum EscapeType {
    AND("&", "&amp;"),
    LESS_THAN("<", "&lt;"),
    DOUBLE_QUOTATION("\"", "&quot;");

    private String source;
    private String target;

    private EscapeType(String source, String target) {
        this.source = source;
        this.target = target;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String toString() {
        return this.source;
    }

    public static String escape(String value, boolean escaped) {
        if (value == null) {
            return null;
        }
        EscapeType[] escapeTypes = EscapeType.values();
        for (int i = 0; i < escapeTypes.length; ++i) {
            EscapeType escapeType = escapeTypes[i];
            value = value.replace(escaped ? escapeType.getSource() : escapeType.getTarget(), escaped ? escapeType.getTarget() : escapeType.getSource());
        }
        return value;
    }
}

