/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.dom4j;

import com.nepxion.discovery.common.dom4j.Dom4JReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public abstract class Dom4JParser {
    public void parse(String text) throws DocumentException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text is empty");
        }
        Document document = Dom4JReader.getDocument(text);
        this.parse(document);
    }

    public void parseFormat(String text) throws DocumentException, UnsupportedEncodingException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("The text is empty");
        }
        Document document = Dom4JReader.getFormatDocument(text);
        this.parse(document);
    }

    public void parse(File file) throws DocumentException, IOException, UnsupportedEncodingException {
        if (file == null) {
            throw new IllegalArgumentException("The file is null");
        }
        Document document = Dom4JReader.getDocument(file);
        this.parse(document);
    }

    public void parseFormat(File file) throws DocumentException, IOException, UnsupportedEncodingException {
        if (file == null) {
            throw new IllegalArgumentException("The file is null");
        }
        Document document = Dom4JReader.getFormatDocument(file);
        this.parse(document);
    }

    public void parse(InputStream inputStream) throws DocumentException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The input stream is null");
        }
        Document document = Dom4JReader.getDocument(inputStream);
        this.parse(document);
    }

    public void parseFormat(InputStream inputStream) throws DocumentException, IOException, UnsupportedEncodingException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The input stream is null");
        }
        Document document = Dom4JReader.getFormatDocument(inputStream);
        this.parse(document);
    }

    public void parse(Document document) {
        Element rootElement = document.getRootElement();
        this.parseRoot(rootElement);
    }

    protected abstract void parseRoot(Element var1);
}

