/*
 * Decompiled with CFR 0.152.
 */
package com.neno0o.tflitehelper.imageclassification;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import com.neno0o.tflitehelper.imageclassification.ClassifierModel;
import com.neno0o.tflitehelper.imageclassification.FloatClassifier;
import com.neno0o.tflitehelper.imageclassification.ImageClassification;
import com.neno0o.tflitehelper.imageclassification.ImageClassification$Companion$WhenMappings;
import com.neno0o.tflitehelper.imageclassification.QuantizedClassifier;
import com.neno0o.tflitehelper.imageclassification.Recognizable;
import com.neno0o.tflitehelper.imageclassification.UtilKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.tensorflow.lite.Interpreter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 *2\u00020\u0001:\u0001*B5\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH$J\b\u0010\u001f\u001a\u00020\bH$J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00052\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\u001dJ\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020!0\u0005H\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\bH$J\b\u0010)\u001a\u00020\u001dH$R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/neno0o/tflitehelper/imageclassification/ImageClassification;", "", "interpreter", "Lorg/tensorflow/lite/Interpreter;", "labelList", "", "", "inputSize", "", "numberOfResults", "confidenceThreshold", "", "(Lorg/tensorflow/lite/Interpreter;Ljava/util/List;IIF)V", "getConfidenceThreshold", "()F", "imageByteBuffer", "Ljava/nio/ByteBuffer;", "getImageByteBuffer", "()Ljava/nio/ByteBuffer;", "imageByteBuffer$delegate", "Lkotlin/Lazy;", "getInputSize", "()I", "getInterpreter", "()Lorg/tensorflow/lite/Interpreter;", "getLabelList", "()Ljava/util/List;", "getNumberOfResults", "addPixelValueToBuffer", "", "pixelValue", "byteNumbersPerChannel", "classifyImage", "Lcom/neno0o/tflitehelper/imageclassification/Recognizable;", "bitmap", "Landroid/graphics/Bitmap;", "close", "convertBitmapToByteBuffer", "getResult", "normalizedProbability", "labelIndex", "runInterpreter", "Companion", "imageclassification_release"})
public abstract class ImageClassification {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy imageByteBuffer$delegate;
    @NotNull
    private final Interpreter interpreter;
    @NotNull
    private final List<String> labelList;
    private final int inputSize;
    private final int numberOfResults;
    private final float confidenceThreshold;
    private static final int DEFAULT_MAX_RESULTS = 3;
    private static final float DEFAULT_CONFIDENCE_THRESHOLD = 0.1f;
    private static final int DEFAULT_INPUT_SIZE = 224;
    private static final int BATCH_SIZE = 1;
    private static final int PIXEL_SIZE = 3;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ImageClassification.class), "imageByteBuffer", "getImageByteBuffer()Ljava/nio/ByteBuffer;"))};
        Companion = new Companion(null);
    }

    @NotNull
    protected final ByteBuffer getImageByteBuffer() {
        Lazy lazy = this.imageByteBuffer$delegate;
        ImageClassification imageClassification = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (ByteBuffer)lazy.getValue();
    }

    @NotNull
    public final List<Recognizable> classifyImage(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.convertBitmapToByteBuffer(bitmap);
        this.runInterpreter();
        return this.getResult();
    }

    public final void close() {
        this.interpreter.close();
    }

    protected abstract int byteNumbersPerChannel();

    protected abstract void addPixelValueToBuffer(int var1);

    protected abstract float normalizedProbability(int var1);

    protected abstract void runInterpreter();

    /*
     * WARNING - void declaration
     */
    private final void convertBitmapToByteBuffer(Bitmap bitmap) {
        this.getImageByteBuffer().rewind();
        int[] emptyIntArray = new int[this.inputSize * this.inputSize];
        bitmap.getPixels(emptyIntArray, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        int pixel = 0;
        int n = 0;
        int n2 = this.inputSize;
        while (n < n2) {
            void x;
            int n3 = 0;
            int n4 = this.inputSize;
            while (n3 < n4) {
                void y;
                int pixelValue = emptyIntArray[pixel++];
                this.addPixelValueToBuffer(pixelValue);
                ++y;
            }
            ++x;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Recognizable> getResult() {
        PriorityQueue priorityQueue2 = UtilKt.priorityQueue(this.numberOfResults, getResult.priorityQueue.1.INSTANCE);
        Iterable $this$forEachIndexed$iv = this.labelList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void label;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string = (String)item$iv;
            int index = n2;
            boolean bl2 = false;
            float confidence = this.normalizedProbability(index);
            if (!(confidence > this.confidenceThreshold)) continue;
            priorityQueue2.add(new Recognizable(String.valueOf(index), (String)(this.labelList.size() > index ? label : "unknown"), confidence));
        }
        return CollectionsKt.take((Iterable)priorityQueue2, (int)this.numberOfResults);
    }

    @NotNull
    public final Interpreter getInterpreter() {
        return this.interpreter;
    }

    @NotNull
    public final List<String> getLabelList() {
        return this.labelList;
    }

    public final int getInputSize() {
        return this.inputSize;
    }

    public final int getNumberOfResults() {
        return this.numberOfResults;
    }

    public final float getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    protected ImageClassification(@NotNull Interpreter interpreter, @NotNull List<String> labelList, int inputSize, int numberOfResults, float confidenceThreshold) {
        Intrinsics.checkParameterIsNotNull((Object)interpreter, (String)"interpreter");
        Intrinsics.checkParameterIsNotNull(labelList, (String)"labelList");
        this.interpreter = interpreter;
        this.labelList = labelList;
        this.inputSize = inputSize;
        this.numberOfResults = numberOfResults;
        this.confidenceThreshold = confidenceThreshold;
        this.imageByteBuffer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ByteBuffer>(this){
            final /* synthetic */ ImageClassification this$0;

            public final ByteBuffer invoke() {
                return ByteBuffer.allocateDirect(this.this$0.byteNumbersPerChannel() * 1 * this.this$0.getInputSize() * this.this$0.getInputSize() * 3).order(ByteOrder.nativeOrder());
            }
            {
                this.this$0 = imageClassification;
                super(0);
            }
        }));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/neno0o/tflitehelper/imageclassification/ImageClassification$Companion;", "", "()V", "BATCH_SIZE", "", "DEFAULT_CONFIDENCE_THRESHOLD", "", "DEFAULT_INPUT_SIZE", "DEFAULT_MAX_RESULTS", "PIXEL_SIZE", "create", "Lcom/neno0o/tflitehelper/imageclassification/ImageClassification;", "classifierModel", "Lcom/neno0o/tflitehelper/imageclassification/ClassifierModel;", "assetManager", "Landroid/content/res/AssetManager;", "modelPath", "", "labelPath", "inputSize", "interpreterOptions", "Lorg/tensorflow/lite/Interpreter$Options;", "numberOfResults", "confidenceThreshold", "imageclassification_release"})
    public static final class Companion {
        @NotNull
        public final ImageClassification create(@NotNull ClassifierModel classifierModel, @NotNull AssetManager assetManager, @NotNull String modelPath, @NotNull String labelPath, int inputSize, @NotNull Interpreter.Options interpreterOptions, int numberOfResults, float confidenceThreshold) {
            ImageClassification imageClassification;
            Intrinsics.checkParameterIsNotNull((Object)((Object)classifierModel), (String)"classifierModel");
            Intrinsics.checkParameterIsNotNull((Object)assetManager, (String)"assetManager");
            Intrinsics.checkParameterIsNotNull((Object)modelPath, (String)"modelPath");
            Intrinsics.checkParameterIsNotNull((Object)labelPath, (String)"labelPath");
            Intrinsics.checkParameterIsNotNull((Object)interpreterOptions, (String)"interpreterOptions");
            Interpreter interpreter = new Interpreter((ByteBuffer)UtilKt.loadModelFile(assetManager, modelPath), interpreterOptions);
            switch (ImageClassification$Companion$WhenMappings.$EnumSwitchMapping$0[classifierModel.ordinal()]) {
                case 1: {
                    imageClassification = new QuantizedClassifier(interpreter, UtilKt.loadLabelList(assetManager, labelPath), inputSize, numberOfResults, confidenceThreshold);
                    break;
                }
                case 2: {
                    imageClassification = new FloatClassifier(interpreter, UtilKt.loadLabelList(assetManager, labelPath), inputSize, numberOfResults, confidenceThreshold);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return imageClassification;
        }

        @NotNull
        public static /* synthetic */ ImageClassification create$default(Companion companion, ClassifierModel classifierModel, AssetManager assetManager, String string, String string2, int n, Interpreter.Options options, int n2, float f, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                n = 224;
            }
            if ((n3 & 0x20) != 0) {
                options = new Interpreter.Options();
            }
            if ((n3 & 0x40) != 0) {
                n2 = 3;
            }
            if ((n3 & 0x80) != 0) {
                f = 0.1f;
            }
            return companion.create(classifierModel, assetManager, string, string2, n, options, n2, f);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

