/*
 * Decompiled with CFR 0.152.
 */
package com.nefrit.inputprogressview.gui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.nefrit.inputprogressview.R;

public class InputProgressView
extends LinearLayout {
    private static final int DEFAULT_MAX_PROGRESS = 4;
    private int progress;
    private int maxProgress;
    private int itemSize;
    private int itemMargin;
    private boolean fillPrevious;
    private Drawable emptyDrawable;
    private Drawable filledDrawable;
    private View[] circles;
    private ProgressChangeListener progressChangeListener;

    public InputProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.InputProgressView);
            this.maxProgress = attributes.getInteger(R.styleable.InputProgressView_max_progress, 4);
            this.emptyDrawable = attributes.getDrawable(R.styleable.InputProgressView_background_empty);
            this.filledDrawable = attributes.getDrawable(R.styleable.InputProgressView_background_filled);
            this.fillPrevious = attributes.getBoolean(R.styleable.InputProgressView_fill_previous, false);
            this.progress = attributes.getInteger(R.styleable.InputProgressView_progress, 0);
            this.itemSize = attributes.getDimensionPixelSize(R.styleable.InputProgressView_item_size, -1);
            this.itemMargin = attributes.getDimensionPixelSize(R.styleable.InputProgressView_item_margin, -1);
            attributes.recycle();
        }
        if (this.emptyDrawable == null) {
            this.emptyDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.background_ipv_empty);
        }
        if (this.filledDrawable == null) {
            this.filledDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.background_ipv_filled);
        }
        this.init(context);
    }

    private void init(Context context) {
        if (this.maxProgress < 1) {
            this.maxProgress = 4;
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        if (this.itemSize == -1) {
            this.itemSize = (int)TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)dm);
        }
        if (this.itemMargin == -1) {
            this.itemMargin = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)dm);
        }
        this.circles = new View[this.maxProgress];
        for (int i = 0; i < this.maxProgress; ++i) {
            View circle = new View(context);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.itemSize, this.itemSize);
            params.setMargins(this.itemMargin, 0, this.itemMargin, 0);
            circle.setLayoutParams((ViewGroup.LayoutParams)params);
            this.addView(circle);
            this.circles[i] = circle;
        }
        this.setProgress(this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setProgressChangeListener(ProgressChangeListener progressChangeListener) {
        this.progressChangeListener = progressChangeListener;
    }

    public void setProgress(int currentProgress) {
        if (currentProgress < 0) {
            throw new ArrayIndexOutOfBoundsException("current progress must be >= 0");
        }
        this.progress = currentProgress;
        if (this.progressChangeListener != null) {
            this.progressChangeListener.progressChanged(this.progress);
        }
        for (View v : this.circles) {
            v.setBackground(this.emptyDrawable);
        }
        if (currentProgress == 0) {
            return;
        }
        if (currentProgress > this.maxProgress) {
            currentProgress = this.maxProgress;
        }
        if (this.fillPrevious) {
            for (int i = 0; i < currentProgress; ++i) {
                this.circles[i].setBackground(this.filledDrawable);
            }
        } else {
            this.circles[currentProgress - 1].setBackground(this.filledDrawable);
        }
    }

    public void setMaxProgress(int progress) {
        this.maxProgress = progress;
        this.removeAllViews();
        this.init(this.getContext());
    }

    public static interface ProgressChangeListener {
        public void progressChanged(int var1);
    }
}

