/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.utils.message;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openehr.utils.message.GlobalMessageLoggingLevel;
import org.openehr.utils.message.MessageCode;
import org.openehr.utils.message.MessageDescriptor;
import org.openehr.utils.message.MessageSeverity;
import org.openehr.utils.message.UnknownMessageCode;

public class MessageLogger {
    private List<MessageDescriptor> messageList = new ArrayList<MessageDescriptor>();
    private boolean hasErrors;
    private boolean hasWarnings;
    private boolean hasInfo;

    public MessageDescriptor lastAdded() {
        if (this.messageList != null && this.messageList.size() > 0) {
            return this.messageList.get(this.messageList.size() - 1);
        }
        return null;
    }

    public List<MessageCode> getErrorCodes() {
        return this.getCodesForSeverity(MessageSeverity.ERROR);
    }

    private List<MessageCode> getCodesForSeverity(MessageSeverity severity) {
        return this.messageList.stream().filter(message -> message.getSeverity() == severity).map(message -> message.getCode()).collect(Collectors.toList());
    }

    public List<MessageCode> getWarningCodes() {
        return this.getCodesForSeverity(MessageSeverity.WARNING);
    }

    public List<MessageCode> getInfoCodes() {
        return this.getCodesForSeverity(MessageSeverity.INFO);
    }

    public boolean isEmpty() {
        return this.messageList.isEmpty();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public boolean hasInfo() {
        return this.hasInfo;
    }

    public boolean hasErrorsOrWarnings() {
        return this.hasErrors || this.hasWarnings;
    }

    public boolean hasError(MessageCode aCode) {
        return this.getErrorCodes().contains(aCode);
    }

    public boolean hasWarning(MessageCode aCode) {
        return this.getWarningCodes().contains(aCode);
    }

    public boolean hasInfo(MessageCode aCode) {
        return this.getInfoCodes().contains(aCode);
    }

    public boolean hasMatchingError(MessageCode aCode) {
        return this.hasMatchingMessage(aCode, MessageSeverity.ERROR);
    }

    public boolean hasMatchingWarning(MessageCode aCode) {
        return this.hasMatchingMessage(aCode, MessageSeverity.WARNING);
    }

    private boolean hasMatchingMessage(MessageCode aCode, MessageSeverity severity) {
        for (MessageDescriptor error : this.messageList) {
            if (!error.getSeverity().equals((Object)severity) || !error.getCode().getCode().startsWith(aCode.getCode())) continue;
            return true;
        }
        return false;
    }

    public void addError(MessageCode code, Object ... args) {
        this.addErrorWithLocation(code, null, args);
    }

    public void addWarning(MessageCode code, Object ... args) {
        this.addWarningWithLocation(code, null, args);
    }

    public void addInfo(MessageCode code, Object ... args) {
        this.addInfoWithLocation(code, null, args);
    }

    public void addDebug(String message) {
        this.addDebugWithLocation(null, message);
    }

    public void addErrorWithLocation(MessageCode aCode, String aLocation, Object ... args) {
        this.add(new MessageDescriptor(aCode, MessageSeverity.ERROR, aCode.getMessage(args), aLocation));
    }

    public void addWarningWithLocation(MessageCode aCode, String aLocation, Object ... args) {
        this.add(new MessageDescriptor(aCode, MessageSeverity.WARNING, aCode.getMessage(args), aLocation));
    }

    public void addInfoWithLocation(MessageCode aCode, String aLocation, Object ... args) {
        this.add(new MessageDescriptor(aCode, MessageSeverity.INFO, aCode.getMessage(args), aLocation));
    }

    public void addDebugWithLocation(String aLocation, String aMessage) {
        this.add(new MessageDescriptor(new UnknownMessageCode(), MessageSeverity.DEBUG, aMessage, aLocation));
    }

    public void add(MessageDescriptor errorDescriptor) {
        this.messageList.add(errorDescriptor);
        this.hasErrors = this.hasErrors || errorDescriptor.getSeverity().equals((Object)MessageSeverity.ERROR);
        this.hasWarnings = this.hasWarnings || errorDescriptor.getSeverity().equals((Object)MessageSeverity.WARNING);
        this.hasInfo = this.hasInfo || errorDescriptor.getSeverity().equals((Object)MessageSeverity.INFO);
    }

    public void append(MessageLogger other) {
        this.messageList.addAll(other.getMessageList());
        this.hasErrors = this.hasErrors || other.hasErrors;
        this.hasWarnings = this.hasWarnings || other.hasWarnings;
        this.hasInfo = this.hasInfo || other.hasInfo;
    }

    public void clear() {
        this.messageList.clear();
        this.hasErrors = false;
        this.hasWarnings = false;
        this.hasInfo = false;
    }

    public List<MessageDescriptor> getMessageList() {
        return this.messageList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.messageList.forEach(error -> {
            if (GlobalMessageLoggingLevel.shouldLog(error.getSeverity())) {
                builder.append(error.toString()).append("\n");
            }
        });
        return builder.toString();
    }

    public String toStringFiltered(boolean includeErrors, boolean includeWarnings, boolean includeInfo) {
        StringBuilder builder = new StringBuilder();
        this.messageList.forEach(message -> {
            if (includeErrors && message.getSeverity().equals((Object)MessageSeverity.ERROR)) {
                builder.append(message.toString()).append("\n");
            } else if (includeWarnings && message.getSeverity().equals((Object)MessageSeverity.WARNING)) {
                builder.append(message.toString()).append("\n");
            } else if (includeInfo && message.getSeverity().equals((Object)MessageSeverity.INFO)) {
                builder.append(message.toString()).append("\n");
            }
        });
        return builder.toString();
    }

    public int size() {
        return this.messageList.size();
    }
}

