/*
 * Decompiled with CFR 0.152.
 */
package com.nearform.patrun;

import com.nearform.patrun.Customiser;
import com.nearform.patrun.Modifier;
import com.nearform.patrun.Node;
import com.nearform.patrun.Pattern;
import com.nearform.patrun.Printer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patrun {
    private Node tree = new Node("root");
    private Customiser custom;

    public Patrun() {
        this(null);
    }

    public Patrun(Customiser custom) {
        this.custom = custom;
    }

    public Patrun add(Map<String, String> pat, Object data) {
        Modifier custom = null;
        if (this.custom != null) {
            custom = this.custom.add(this, pat, data);
        }
        Vector<String> keys = this.sortKeys(pat);
        Node currentNode = this.tree;
        int position = 0;
        for (String key : keys) {
            Boolean justCreated;
            String val = pat.get(key);
            Node lastNode = currentNode;
            if ((currentNode = currentNode.getValues().get(key)) == null) {
                lastNode.getValues().put(key, new Node(key));
                currentNode = lastNode.getValues().get(key);
            }
            lastNode = currentNode;
            if ((currentNode = currentNode.getValues().get(val)) == null) {
                justCreated = true;
                if (position == keys.size() - 1) {
                    lastNode.getValues().put(val, new Node(val, data, custom));
                } else {
                    lastNode.getValues().put(val, new Node(val, custom));
                }
                currentNode = lastNode.getValues().get(val);
            } else {
                justCreated = false;
            }
            if (position == keys.size() - 1 && !justCreated.booleanValue()) {
                Node item = lastNode.getValues().get(val);
                item.setData(data);
                item.setModifier(custom);
            }
            ++position;
        }
        if (keys.size() == 0) {
            this.tree.setData(data);
            this.tree.setModifier(custom);
        }
        return this;
    }

    public Patrun add(String pat, Object data) {
        return this.add(this.convertPatternString(pat), data);
    }

    public Object find(Map<String, String> pat, Boolean exact) {
        Node currentNode;
        Vector<String> keys = this.sortKeys(pat, false);
        Node lastGoodNode = currentNode = this.tree;
        Vector<String> foundKeys = new Vector<String>();
        Object lastData = this.tree.getData();
        Modifier lastModifier = this.tree.getModifier();
        Vector<Node> stars = new Vector<Node>();
        int keyPointer = 0;
        while (keyPointer < keys.size()) {
            String key = keys.get(keyPointer);
            String value = pat.get(key);
            String val = value.toString();
            if ((currentNode = currentNode.getValues().get(key)) != null) {
                currentNode = currentNode.getValues().get(val);
            }
            if (currentNode != null) {
                if (lastGoodNode.getValues().size() > 0) {
                    stars.add(lastGoodNode);
                }
                lastGoodNode = currentNode;
                foundKeys.add(key);
                if (lastGoodNode.getData() != null) {
                    lastData = lastGoodNode.getData();
                }
                lastModifier = lastGoodNode.getModifier();
                ++keyPointer;
                continue;
            }
            if (lastData == null && stars.size() > 0) {
                currentNode = (Node)stars.get(stars.size() - 1);
                stars.removeElementAt(stars.size() - 1);
                lastGoodNode = currentNode;
                continue;
            }
            currentNode = lastGoodNode;
            ++keyPointer;
        }
        if (exact.booleanValue() && foundKeys.size() != keys.size()) {
            lastData = null;
        }
        if (lastModifier != null) {
            lastData = lastModifier.find(this, pat, lastData);
        }
        return lastData;
    }

    public Object find(Map<String, String> pat) {
        return this.find(pat, (Boolean)false);
    }

    public Object find(String pat) {
        return this.find(this.convertPatternString(pat), (Boolean)false);
    }

    public Object find(String pat, Boolean exact) {
        return this.find(this.convertPatternString(pat), exact);
    }

    public void remove(Map<String, String> pat) {
        Node currentNode;
        Vector<String> keys = this.sortKeys(pat);
        Node lastGoodNode = currentNode = this.tree;
        Vector<String> foundKeys = new Vector<String>();
        String val = "";
        Node lastParent = currentNode;
        for (String key : keys) {
            val = pat.get(key);
            if ((currentNode = currentNode.getValues().get(key)) != null) {
                lastParent = currentNode;
                lastGoodNode = currentNode;
            }
            if (currentNode != null) {
                currentNode = currentNode.getValues().get(val);
            }
            if (currentNode == null) continue;
            lastGoodNode = currentNode;
            foundKeys.add(key);
        }
        if (foundKeys.size() == keys.size()) {
            Node item = pat.size() == 0 ? this.tree : lastParent.getValues().get(val);
            Boolean okToDel = true;
            if (lastGoodNode.getModifier() != null) {
                okToDel = lastGoodNode.getModifier().remove(this, pat, item.getData());
            }
            if (okToDel.booleanValue()) {
                item.setData(null);
                item.setModifier(null);
            }
        }
    }

    public void remove(String pat) {
        this.remove(this.convertPatternString(pat));
    }

    public Vector<Pattern> list(Map<String, String> pat, Boolean exact) {
        Vector<Pattern> items = new Vector<Pattern>();
        Vector<String> keyMap = new Vector<String>();
        if (pat == null) {
            pat = new HashMap<String, String>();
        }
        if (this.tree.getData() != null) {
            items.add(this.createMatchList(keyMap, this.tree.getData(), this.tree.getModifier()));
        }
        if (this.tree != null) {
            this.descendTree(items, pat, exact, true, this.tree.getValues(), keyMap);
        }
        return items;
    }

    public Vector<Pattern> list() {
        return this.list(new HashMap<String, String>(), (Boolean)false);
    }

    public Vector<Pattern> list(Map<String, String> pat) {
        return this.list(pat, (Boolean)false);
    }

    public Vector<Pattern> list(String pat) {
        return this.list(this.convertPatternString(pat), (Boolean)false);
    }

    public Vector<Pattern> list(String pat, Boolean exact) {
        return this.list(this.convertPatternString(pat), exact);
    }

    public String toString() {
        Vector<Pattern> items = this.list();
        Vector<String> data = new Vector<String>();
        for (Pattern p : items) {
            data.add(this.formatMatch(p.getMatch()) + " -> <" + p.getData() + ">");
        }
        return StringUtils.join(data, (String)"\n");
    }

    public String toString(Printer printer) {
        Vector<Pattern> items = this.list();
        Vector<String> data = new Vector<String>();
        for (Pattern p : items) {
            data.add(this.formatMatch(p.getMatch()) + " -> <" + printer.toString(p.getData()) + ">");
        }
        return StringUtils.join(data, (String)"\n");
    }

    private void descendTree(Vector<Pattern> items, Map<String, String> pat, Boolean exact, Boolean rootLevel, Map<String, Node> values, Vector<String> keyMap) {
        Vector<String> localKeyMap = new Vector<String>();
        localKeyMap.addAll(0, keyMap);
        Vector<String> keys = new Vector<String>();
        for (String key : values.keySet()) {
            keys.add(key);
        }
        Collections.sort(keys);
        for (String key : keys) {
            Vector<String> newMap;
            Node val = values.get(key);
            if (rootLevel.booleanValue()) {
                keyMap = new Vector();
            }
            if (val.getData() == null && val.getValues().size() > 0) {
                newMap = new Vector<String>(keyMap);
                newMap.add(key);
                this.descendTree(items, pat, exact, false, val.getValues(), newMap);
                continue;
            }
            if (val.getData() == null) continue;
            localKeyMap.clear();
            localKeyMap.addAll(0, keyMap);
            localKeyMap.add(val.getKey());
            if (this.validatePatternMatch(pat, exact, localKeyMap).booleanValue()) {
                items.add(this.createMatchList(localKeyMap, val.getData(), val.getModifier()));
            }
            if (val.getValues().size() <= 0) continue;
            newMap = new Vector<String>(keyMap);
            newMap.add(key);
            this.descendTree(items, pat, exact, false, val.getValues(), newMap);
        }
    }

    private String formatMatch(Map<String, String> items) {
        Vector<String> points = new Vector<String>();
        Vector<String> keys = this.sortKeys(items);
        for (String key : keys) {
            String val = items.get(key);
            points.add(key + ":" + val);
        }
        return StringUtils.join(points, (String)", ");
    }

    private Pattern createMatchList(Vector<String> keyMap, Object dataItem, Modifier modifier) {
        HashMap<String, String> keys = new HashMap<String, String>();
        for (int i = 0; i < keyMap.size(); i += 2) {
            if (i + 1 >= keyMap.size()) continue;
            keys.put(keyMap.get(i), keyMap.get(i + 1));
        }
        return new Pattern(keys, dataItem, modifier);
    }

    private Boolean validatePatternMatch(Map<String, String> pat, Boolean exact, Vector<String> matchedKeys) {
        Vector<String> keys = this.sortKeys(pat);
        if (keys.size() == 0) {
            return true;
        }
        Map<String, String> pathMap = this.convertListToMap(matchedKeys);
        Boolean matched = true;
        for (String key : pat.keySet()) {
            String val = pat.get(key);
            if (pathMap.get(key) != null && this.gexval(val, pathMap.get(key)).booleanValue()) continue;
            matched = false;
            break;
        }
        if (exact.booleanValue() && pat.size() != pathMap.size()) {
            matched = false;
        }
        return matched;
    }

    private Map<String, String> convertListToMap(Vector<String> listItems) {
        HashMap<String, String> mapData = new HashMap<String, String>();
        for (int k = 0; k < listItems.size(); k += 2) {
            mapData.put(listItems.get(k), listItems.get(k + 1));
        }
        return mapData;
    }

    private Vector<String> sortKeys(Map<String, String> pat, Boolean sortKeys) {
        Vector<String> keys = new Vector<String>();
        for (String key : pat.keySet()) {
            keys.add(key);
        }
        if (sortKeys.booleanValue()) {
            Collections.sort(keys);
        }
        return keys;
    }

    private Vector<String> sortKeys(Map<String, String> pat) {
        return this.sortKeys(pat, true);
    }

    private Map<String, String> convertPatternString(String pat) {
        String[] items;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String k : items = StringUtils.split((String)pat, (String)",")) {
            String[] parts;
            String item = StringUtils.trim((String)k);
            if (item.length() <= 0 || (parts = StringUtils.split((String)item, (String)":")).length != 2) continue;
            map.put(StringUtils.trim((String)parts[0]), StringUtils.trim((String)parts[1]));
        }
        return map;
    }

    private Boolean gexval(String pattern, String value) {
        pattern = pattern.replaceAll("([-\\[\\]{}()*+?.,\\\\^$|#\\s])", "\\\\$1");
        pattern = pattern.replaceAll("\\\\\\*", "[\\\\s\\\\S]*");
        pattern = pattern.replaceAll("\\\\\\?", "[\\\\s\\\\S]");
        pattern = pattern.replaceAll("\\[\\\\s\\\\S\\]\\*\\[\\\\s\\\\S\\]\\*", "\\\\\\*");
        pattern = pattern.replaceAll("\\[\\\\s\\\\S\\]\\*\\[\\\\s\\\\S\\]", "\\\\\\?");
        pattern = "^" + pattern + "$";
        java.util.regex.Pattern p = java.util.regex.Pattern.compile(pattern);
        Matcher m = p.matcher(value);
        return m.matches();
    }
}

