package com.nearform.patrun;

import java.util.HashMap;
import java.util.Map;

/**
 *  A package class used to represent a node within the decision tree
 */
class Node {
    private String key;
    private Map<String, Node> values;
    private Object data;
    private Modifier modifier;

    /**
     * Construct a node object
     * <p>
     *
     * @param key  the key for this node
     */
    public Node(String key) {
        this(key, null, null);
    }

    /**
     * Construct a node object
     * <p>
     *
     * @param key  the key for this node
     * @param data the data to store or this node
     */
    public Node(String key, Object data) {
        this(key, data, null);
    }

    /**
     * Construct a node object
     * <p>
     *
     * @param key  the key for this node
     * @param modifier the modifier to store for this node
     */
    public Node(String key, Modifier modifier) {
        this(key, null, modifier);
    }

    /**
     * Construct a node object
     * <p>
     *
     * @param key  the key for this node
     * @param data the data to store or this node
     * @param modifier the modifier to store for this node
     */
    public Node(String key, Object data, Modifier modifier) {
        this.key = key;
        this.values = new HashMap<String, Node>();
        this.data = data;
        this.modifier = modifier;
    }

    /**
     * Get the collection of nodes stored against this key
     * <p>
     *
     * @return   the data object
     */
    public Map<String, Node> getValues() {
        return this.values;
    }

    /**
     * Get the data object for this node
     * <p>
     *
     * @return   the data object
     */
    public Object getData() {
        return this.data;
    }

    /**
     * Set the data object for this node
     * <p>
     *
     * @param  data the data object
     */
    public void setData(Object data) {
        this.data = data;
    }

    /**
     * Set the custom modifier object for this node
     * <p>
     *
     * @param modifier  the modifier object
     */
    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    /**
     * Get the modifier object for this node
     * <p>
     *
     * @return   the modifier object
     */
    public Modifier getModifier() {
        return this.modifier;
    }

    /**
     * Get the key identifier for this node
     * <p>
     *
     * @return   the key
     */
    public String getKey() {
        return this.key;
    }
}
