package com.nearform.patrun;

import java.util.Map;

/**
 *  An interface for a custom modifier used to customise the find and remove methods
 */
public interface Modifier {

    /**
     * Called when a node is matched against a pattern on the find method of Patrun
     * <p>
     *
     * @param  pm the instance of the Patrun object
     * @param  pat the match pattern that was provided in the call to find on Patrun
     * @param data the data object found that matches the pattern
     * @return  the data object to be returned from the find call on Patrun
     */
    Object find(Patrun pm, Map<String, String> pat, Object data);

    /**
     * Called when a node is about to be removed from the decision tree
     * <p>
     *
     * @param  pm the instance of the Patrun object
     * @param  pat the match pattern that was provided in the call to remove on Patrun
     * @param data the data object found that matches the pattern
     * @return  true if the object is to be deleted
     */
    Boolean remove(Patrun pm, Map<String, String> pat, Object data);
}
