package com.nearform.patrun;

import java.util.Map;

/**
 * Interface to be implemented if you need to customise the add / find or remove behaviour of a Patrun object
 */
public interface Customiser {

    /**
     * Called when a node is added to the decision tree
     * <p>
     *
     * @param  p the instance of the Patrun object
     * @param  pat the match pattern that was provided in the call to add on Patrun
     * @param data the data object to be stored
     * @return  the custom modifier to be called for find / remove methods or null if no custom modifier required
     */
    Modifier add(Patrun p, Map<String, String> pat, Object data);
}
