/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.activities;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.AccountPicker;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.SignInButton;
import com.ndipatri.iot.googleproximity.GoogleProximity;
import com.ndipatri.iot.googleproximity.R;
import com.ndipatri.iot.googleproximity.activities.AuthenticationActivity$$Lambda$1;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;

public class AuthenticationActivity
extends AppCompatActivity {
    private static final String TAG = AuthenticationActivity.class.getSimpleName();
    private static final int REQUEST_PICK_ACCOUNT = 42;
    private static final int REQUEST_ERROR_RECOVER = 43;
    SignInButton chooseGoogleAccountButton;
    protected String selectedGoogleAccount;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_authentiation);
        this.chooseGoogleAccountButton = (SignInButton)this.findViewById(R.id.chooseGoogleAccountButton);
        this.chooseGoogleAccountButton.setOnClickListener(AuthenticationActivity$$Lambda$1.lambdaFactory$(this));
    }

    private void pickUserAccount() {
        String[] accountTypes = new String[]{"com.google"};
        Intent intent = AccountPicker.newChooseAccountIntent(null, null, (String[])accountTypes, (boolean)true, null, null, null, null);
        this.startActivityForResult(intent, 42);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (requestCode == 42) {
            if (resultCode == -1) {
                this.selectedGoogleAccount = intent.getStringExtra("authAccount");
                this.getFirstTokenForAccount();
            } else if (resultCode == 0) {
                Toast.makeText((Context)this, (CharSequence)"You have to select an account.", (int)0).show();
            }
        }
        if (requestCode == 43 && resultCode == -1) {
            Log.d((String)TAG, (String)("All permissions have been granted with this application for selected Google account('" + this.selectedGoogleAccount + "')."));
            this.getFirstTokenForAccount();
        }
    }

    protected void getFirstTokenForAccount() {
        GoogleProximity.getInstance().getOAuthToken(this.selectedGoogleAccount).subscribe((SingleObserver)new SingleObserver<String>(){

            public void onSubscribe(Disposable d) {
            }

            public void onSuccess(String token) {
                Log.e((String)TAG, (String)"OAuth token successfully retrieved.");
                GoogleProximity.getInstance().setGoogleAccountForOAuth(AuthenticationActivity.this.selectedGoogleAccount);
                AuthenticationActivity.this.finish();
            }

            public void onError(Throwable e) {
                if (e instanceof UserRecoverableAuthException) {
                    AuthenticationActivity.this.promptUserToResolveException((Exception)e);
                } else {
                    Log.e((String)TAG, (String)"Fatal Exception", (Throwable)e);
                }
            }
        });
    }

    public void promptUserToResolveException(Exception exception) {
        if (exception instanceof GooglePlayServicesAvailabilityException) {
            int statusCode = ((GooglePlayServicesAvailabilityException)exception).getConnectionStatusCode();
            Dialog dialog = GooglePlayServicesUtil.getErrorDialog((int)statusCode, (Activity)this, (int)43);
            dialog.show();
        } else if (exception instanceof UserRecoverableAuthException) {
            Intent intent = ((UserRecoverableAuthException)exception).getIntent();
            this.startActivityForResult(intent, 43);
        }
    }

    /* synthetic */ void lambda$onCreate$0(View v) {
        this.pickUserAccount();
    }
}

