/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.f2prateek.rx.preferences2.Preference;
import com.f2prateek.rx.preferences2.RxSharedPreferences;
import com.google.common.base.Strings;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper;
import com.ndipatri.iot.googleproximity.container.ObjectGraph;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import javax.inject.Inject;

public class GoogleProximity {
    private ObjectGraph graph;
    private RxSharedPreferences sharedPreferences;
    @Inject
    BeaconProximityHelper beaconProximityHelper;
    private static GoogleProximity instance = null;

    public static void initialize(Context context, boolean trustAllConnections) {
        instance = new GoogleProximity(context, trustAllConnections);
    }

    public GoogleProximity(Context context, boolean trustAllConnections) {
        this.sharedPreferences = RxSharedPreferences.create((SharedPreferences)PreferenceManager.getDefaultSharedPreferences((Context)context));
        this.graph = ObjectGraph.Initializer.init(context, trustAllConnections);
        this.graph.inject(this);
    }

    public ObjectGraph getGraph() {
        return this.graph;
    }

    public static GoogleProximity getInstance() {
        return instance;
    }

    public void setGoogleAccountForOAuth(String googleAccount) {
        this.getGoogleAccountForOAuth().set((Object)googleAccount);
    }

    public void clearGoogleAccountForOAuth() {
        this.setGoogleAccountForOAuth(null);
    }

    public Preference<String> getGoogleAccountForOAuth() {
        return this.sharedPreferences.getString("GOOGLE_ACCOUNT_FOR_OAUTH", null);
    }

    public boolean hasGoogleAccountForOAuth() {
        return !Strings.isNullOrEmpty((String)((String)this.getGoogleAccountForOAuth().get()));
    }

    public Maybe<String[]> retrieveAttachment(byte[] advertiseId) {
        return this.beaconProximityHelper.retrieveAttachment(advertiseId);
    }

    public Completable updateBeacon(byte[] advertiseId, String[] attachment) {
        return this.beaconProximityHelper.createAttachment(advertiseId, attachment);
    }

    public void redirectToAuthenticationActivityIfNecessary(Context activity) {
        this.beaconProximityHelper.redirectToAuthenticationActivityIfNecessary(activity);
    }

    public Single<String> getOAuthToken(String selectedGoogleAccount) {
        return this.beaconProximityHelper.getOAuthToken(selectedGoogleAccount);
    }
}

