/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.models.api;

import android.util.Base64;
import com.ndipatri.iot.googleproximity.models.api.AdvertisedId;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/ndipatri/iot/googleproximity/models/api/Beacon;", "", "advertiseId", "", "([B)V", "type", "", "rawId", "status", "(Ljava/lang/String;[BLjava/lang/String;)V", "advertisedId", "Lcom/ndipatri/iot/googleproximity/models/api/AdvertisedId;", "getAdvertisedId", "()Lcom/ndipatri/iot/googleproximity/models/api/AdvertisedId;", "setAdvertisedId", "(Lcom/ndipatri/iot/googleproximity/models/api/AdvertisedId;)V", "beaconName", "getBeaconName", "()Ljava/lang/String;", "placeId", "getPlaceId", "setPlaceId", "(Ljava/lang/String;)V", "getStatus", "setStatus", "Companion", "lib-google-proximity_release"})
public final class Beacon {
    @NotNull
    private AdvertisedId advertisedId;
    @Nullable
    private String placeId;
    @NotNull
    private String status;
    @NotNull
    private static final String STATUS_NOT_FOUND = "NOT_FOUND";
    @NotNull
    private static final String STATUS_UNREGISTERED = "UNREGISTERED";
    @NotNull
    private static final String STATUS_ACTIVE = "ACTIVE";
    @NotNull
    private static final String STATUS_DECOMMISSIONED = "DECOMMISSIONED";
    @NotNull
    private static final String STATUS_INACTIVE = "INACTIVE";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AdvertisedId getAdvertisedId() {
        return this.advertisedId;
    }

    public final void setAdvertisedId(@NotNull AdvertisedId advertisedId) {
        Intrinsics.checkParameterIsNotNull((Object)advertisedId, (String)"<set-?>");
        this.advertisedId = advertisedId;
    }

    @Nullable
    public final String getPlaceId() {
        return this.placeId;
    }

    public final void setPlaceId(@Nullable String string2) {
        this.placeId = string2;
    }

    @NotNull
    public final String getBeaconName() {
        byte[] rawId = Base64.decode((String)this.advertisedId.getId(), (int)0);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%02X";
        Object[] objectArray = new Object[]{rawId};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        String hexEncodedId = string3;
        return "3!" + hexEncodedId;
    }

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.status = string2;
    }

    public Beacon(@NotNull String type, @NotNull byte[] rawId, @NotNull String status) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)rawId, (String)"rawId");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        this.status = status;
        this.advertisedId = new AdvertisedId(type, rawId);
        this.placeId = null;
    }

    public Beacon(@NotNull byte[] advertiseId) {
        Intrinsics.checkParameterIsNotNull((Object)advertiseId, (String)"advertiseId");
        this("EDDYSTONE", advertiseId, STATUS_ACTIVE);
    }

    static {
        STATUS_NOT_FOUND = STATUS_NOT_FOUND;
        STATUS_UNREGISTERED = STATUS_UNREGISTERED;
        STATUS_ACTIVE = STATUS_ACTIVE;
        STATUS_DECOMMISSIONED = STATUS_DECOMMISSIONED;
        STATUS_INACTIVE = STATUS_INACTIVE;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/ndipatri/iot/googleproximity/models/api/Beacon$Companion;", "", "()V", "STATUS_ACTIVE", "", "getSTATUS_ACTIVE", "()Ljava/lang/String;", "STATUS_DECOMMISSIONED", "getSTATUS_DECOMMISSIONED", "STATUS_INACTIVE", "getSTATUS_INACTIVE", "STATUS_NOT_FOUND", "getSTATUS_NOT_FOUND", "STATUS_UNREGISTERED", "getSTATUS_UNREGISTERED", "lib-google-proximity_release"})
    public static final class Companion {
        @NotNull
        public final String getSTATUS_NOT_FOUND() {
            return STATUS_NOT_FOUND;
        }

        @NotNull
        public final String getSTATUS_UNREGISTERED() {
            return STATUS_UNREGISTERED;
        }

        @NotNull
        public final String getSTATUS_ACTIVE() {
            return STATUS_ACTIVE;
        }

        @NotNull
        public final String getSTATUS_DECOMMISSIONED() {
            return STATUS_DECOMMISSIONED;
        }

        @NotNull
        public final String getSTATUS_INACTIVE() {
            return STATUS_INACTIVE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

