/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.activities;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.common.AccountPicker;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.SignInButton;
import com.ndipatri.iot.googleproximity.GoogleProximity;
import com.ndipatri.iot.googleproximity.R;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0004J\"\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0006H\u0002J\u0012\u0010\u0011\u001a\u00020\u00062\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ndipatri/iot/googleproximity/activities/AuthenticationActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "selectedGoogleAccount", "", "getFirstTokenForAccount", "", "onActivityResult", "requestCode", "", "resultCode", "intent", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "pickUserAccount", "promptUserToResolveException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "lib-google-proximity_release"})
public final class AuthenticationActivity
extends AppCompatActivity {
    private String selectedGoogleAccount;
    private static final String TAG;
    private static final int REQUEST_PICK_ACCOUNT = 42;
    private static final int REQUEST_ERROR_RECOVER = 43;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_authentiation);
        ((SignInButton)this._$_findCachedViewById(R.id.chooseGoogleAccountButton)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ AuthenticationActivity this$0;

            public final void onClick(View v) {
                AuthenticationActivity.access$pickUserAccount(this.this$0);
            }
            {
                this.this$0 = authenticationActivity;
            }
        });
    }

    private final void pickUserAccount() {
        String[] accountTypes = new String[]{"com.google"};
        Intent intent = AccountPicker.newChooseAccountIntent(null, null, (String[])accountTypes, (boolean)true, null, null, null, null);
        this.startActivityForResult(intent, REQUEST_PICK_ACCOUNT);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if (requestCode == REQUEST_PICK_ACCOUNT) {
            if (resultCode == -1) {
                Intent intent2 = intent;
                if (intent2 == null) {
                    Intrinsics.throwNpe();
                }
                this.selectedGoogleAccount = intent2.getStringExtra("authAccount");
                this.getFirstTokenForAccount();
            } else if (resultCode == 0) {
                Toast.makeText((Context)((Context)this), (CharSequence)"You have to select an account.", (int)0).show();
            }
        }
        if (requestCode == REQUEST_ERROR_RECOVER && resultCode == -1) {
            Log.d((String)TAG, (String)("All permissions have been granted with this application for selected Google account('" + this.selectedGoogleAccount + "')."));
            this.getFirstTokenForAccount();
        }
    }

    protected final void getFirstTokenForAccount() {
        GoogleProximity googleProximity = GoogleProximity.Companion.getInstance();
        if (googleProximity == null) {
            Intrinsics.throwNpe();
        }
        String string = this.selectedGoogleAccount;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        googleProximity.getOAuthToken(string).subscribe((SingleObserver)new SingleObserver<String>(this){
            final /* synthetic */ AuthenticationActivity this$0;

            public void onSubscribe(@NotNull Disposable d) {
                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
            }

            public void onSuccess(@NotNull String token) {
                Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
                Log.e((String)AuthenticationActivity.access$getTAG$cp(), (String)"OAuth token successfully retrieved.");
                GoogleProximity googleProximity = GoogleProximity.Companion.getInstance();
                if (googleProximity == null) {
                    Intrinsics.throwNpe();
                }
                googleProximity.setGoogleAccountForOAuth(AuthenticationActivity.access$getSelectedGoogleAccount$p(this.this$0));
                this.this$0.finish();
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (e instanceof UserRecoverableAuthException) {
                    this.this$0.promptUserToResolveException((Exception)e);
                } else {
                    Log.e((String)AuthenticationActivity.access$getTAG$cp(), (String)"Fatal Exception", (Throwable)e);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void promptUserToResolveException(@NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (exception instanceof GooglePlayServicesAvailabilityException) {
            int statusCode = ((GooglePlayServicesAvailabilityException)exception).getConnectionStatusCode();
            Dialog dialog = GooglePlayServicesUtil.getErrorDialog((int)statusCode, (Activity)((Activity)this), (int)REQUEST_ERROR_RECOVER);
            dialog.show();
        } else if (exception instanceof UserRecoverableAuthException) {
            Intent intent = ((UserRecoverableAuthException)exception).getIntent();
            this.startActivityForResult(intent, REQUEST_ERROR_RECOVER);
        }
    }

    static {
        Companion = new Companion(null);
        TAG = AuthenticationActivity.class.getSimpleName();
        REQUEST_PICK_ACCOUNT = 42;
        REQUEST_ERROR_RECOVER = 43;
    }

    public static final /* synthetic */ void access$pickUserAccount(AuthenticationActivity $this) {
        $this.pickUserAccount();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ String access$getSelectedGoogleAccount$p(AuthenticationActivity $this) {
        return $this.selectedGoogleAccount;
    }

    public static final /* synthetic */ void access$setSelectedGoogleAccount$p(AuthenticationActivity $this, String string) {
        $this.selectedGoogleAccount = string;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ndipatri/iot/googleproximity/activities/AuthenticationActivity$Companion;", "", "()V", "REQUEST_ERROR_RECOVER", "", "REQUEST_PICK_ACCOUNT", "TAG", "", "kotlin.jvm.PlatformType", "lib-google-proximity_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

