/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.utils;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.util.Log;
import com.google.common.base.Optional;
import com.google.common.primitives.Bytes;
import com.ndipatri.iot.googleproximity.utils.BeaconScanHelper;
import com.ndipatri.iot.googleproximity.utils.BeaconScanHelper$sam$org_altbeacon_beacon_RangeNotifier$0;
import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005*\u0002\u0006\u000f\u0018\u0000 (2\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\"2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010#\u001a\u00020$H\u0007J\b\u0010%\u001a\u00020\u0016H\u0002J\u0006\u0010&\u001a\u00020\u0016R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R&\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "beaconConsumer", "com/ndipatri/iot/googleproximity/utils/BeaconScanHelper$beaconConsumer$1", "Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper$beaconConsumer$1;", "beaconManager", "Lorg/altbeacon/beacon/BeaconManager;", "isConnectedToBeaconService", "", "isInitialized", "isScanning", "monitorNotifier", "com/ndipatri/iot/googleproximity/utils/BeaconScanHelper$monitorNotifier$1", "Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper$monitorNotifier$1;", "rangeNotifier", "Lkotlin/Function2;", "", "Lorg/altbeacon/beacon/Beacon;", "Lorg/altbeacon/beacon/Region;", "", "scanForRegionSubject", "Lio/reactivex/subjects/Subject;", "Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper$BeaconUpdate;", "scanRegion", "getAdvertiseId", "", "beacon", "initialize", "beaconNamespaceId", "", "scanForNearbyBeacon", "Lio/reactivex/Observable;", "timeoutSeconds", "", "startBeaconScanning", "stopBeaconScanning", "BeaconUpdate", "Companion", "lib-google-proximity_release"})
public final class BeaconScanHelper {
    private boolean isConnectedToBeaconService;
    private boolean isScanning;
    private boolean isInitialized;
    private BeaconManager beaconManager;
    private Region scanRegion;
    private Subject<BeaconUpdate> scanForRegionSubject;
    private final beaconConsumer.1 beaconConsumer;
    private final monitorNotifier.1 monitorNotifier;
    private final Function2<Collection<? extends Beacon>, Region, Unit> rangeNotifier;
    private final Context context;
    private static final String TAG;
    public static final Companion Companion;

    @JvmOverloads
    @NotNull
    public final Observable<BeaconUpdate> scanForNearbyBeacon(@NotNull String beaconNamespaceId, int timeoutSeconds) {
        Intrinsics.checkParameterIsNotNull((Object)beaconNamespaceId, (String)"beaconNamespaceId");
        Log.d((String)TAG, (String)"Starting AltBeacon discovery...");
        this.scanForRegionSubject = (Subject)PublishSubject.create();
        if (!this.isScanning) {
            if (!this.isInitialized) {
                this.initialize(beaconNamespaceId);
                this.isInitialized = true;
            }
            if (this.isConnectedToBeaconService) {
                this.startBeaconScanning();
            }
            this.isScanning = true;
        }
        Subject<BeaconUpdate> subject = this.scanForRegionSubject;
        if (subject == null) {
            Intrinsics.throwNpe();
        }
        Observable observable2 = subject.doOnError((Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ BeaconScanHelper this$0;

            public final void accept(Throwable throwable) {
                Log.e((String)BeaconScanHelper.access$getTAG$cp(), (String)"Exception while scanning for beacons. Forcing stop.", (Throwable)throwable);
                this.this$0.stopBeaconScanning();
            }
            {
                this.this$0 = beaconScanHelper;
            }
        });
        if (timeoutSeconds > 0) {
            observable2 = observable2.timeout((long)timeoutSeconds, TimeUnit.SECONDS, (ObservableSource)Observable.create((ObservableOnSubscribe)scanForNearbyBeacon.1.INSTANCE));
        }
        Observable observable3 = observable2.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)observable3, (String)"observable.subscribeOn(S\u2026dSchedulers.mainThread())");
        return observable3;
    }

    public static /* synthetic */ Observable scanForNearbyBeacon$default(BeaconScanHelper beaconScanHelper, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return beaconScanHelper.scanForNearbyBeacon(string2, n);
    }

    @JvmOverloads
    @NotNull
    public final Observable<BeaconUpdate> scanForNearbyBeacon(@NotNull String beaconNamespaceId) {
        return BeaconScanHelper.scanForNearbyBeacon$default(this, beaconNamespaceId, 0, 2, null);
    }

    public final void stopBeaconScanning() {
        Log.d((String)TAG, (String)"Stopping AltBeacon discovery...");
        if (this.isScanning) {
            BeaconManager beaconManager = this.beaconManager;
            if (beaconManager == null) {
                Intrinsics.throwNpe();
            }
            beaconManager.removeAllRangeNotifiers();
            BeaconManager beaconManager2 = this.beaconManager;
            if (beaconManager2 == null) {
                Intrinsics.throwNpe();
            }
            beaconManager2.removeAllMonitorNotifiers();
            try {
                BeaconManager beaconManager3 = this.beaconManager;
                if (beaconManager3 == null) {
                    Intrinsics.throwNpe();
                }
                if (beaconManager3.isBound((BeaconConsumer)this.beaconConsumer)) {
                    BeaconManager beaconManager4 = this.beaconManager;
                    if (beaconManager4 == null) {
                        Intrinsics.throwNpe();
                    }
                    beaconManager4.stopMonitoringBeaconsInRegion(this.scanRegion);
                    BeaconManager beaconManager5 = this.beaconManager;
                    if (beaconManager5 == null) {
                        Intrinsics.throwNpe();
                    }
                    beaconManager5.stopRangingBeaconsInRegion(this.scanRegion);
                }
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"BLE scan service not yet bound.", (Throwable)e);
            }
            Subject<BeaconUpdate> subject = this.scanForRegionSubject;
            if (subject == null) {
                Intrinsics.throwNpe();
            }
            subject.onComplete();
            this.isScanning = false;
        }
    }

    private final void initialize(String beaconNamespaceId) {
        Identifier nicksBeaconNamespaceId = Identifier.parse((String)beaconNamespaceId);
        this.scanRegion = new Region("nicks-beacon-region", nicksBeaconNamespaceId, null, null);
        Object object = this.context.getSystemService("bluetooth");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        }
        BluetoothManager mBluetoothManager = (BluetoothManager)object;
        if (mBluetoothManager != null) {
            BluetoothAdapter mBluetoothAdapter = null;
            BluetoothAdapter bluetoothAdapter = mBluetoothAdapter = mBluetoothManager.getAdapter();
            if (bluetoothAdapter == null) {
                Intrinsics.throwNpe();
            }
            bluetoothAdapter.enable();
            BeaconManager beaconManager = this.beaconManager = BeaconManager.getInstanceForApplication((Context)this.context);
            if (beaconManager == null) {
                Intrinsics.throwNpe();
            }
            beaconManager.setForegroundScanPeriod(5000L);
            BeaconManager beaconManager2 = this.beaconManager;
            if (beaconManager2 == null) {
                Intrinsics.throwNpe();
            }
            beaconManager2.setBackgroundScanPeriod(5000L);
            BeaconManager beaconManager3 = this.beaconManager;
            if (beaconManager3 == null) {
                Intrinsics.throwNpe();
            }
            beaconManager3.getBeaconParsers().add(new BeaconParser().setBeaconLayout("s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19"));
            BeaconManager beaconManager4 = this.beaconManager;
            if (beaconManager4 == null) {
                Intrinsics.throwNpe();
            }
            beaconManager4.getBeaconParsers().add(new BeaconParser().setBeaconLayout("x,s:0-1=feaa,m:2-2=20,d:3-3,d:4-5,d:6-7,d:8-11,d:12-15"));
            BeaconManager beaconManager5 = this.beaconManager;
            if (beaconManager5 == null) {
                Intrinsics.throwNpe();
            }
            beaconManager5.bind((BeaconConsumer)this.beaconConsumer);
        }
    }

    private final void startBeaconScanning() {
        Log.d((String)TAG, (String)"startBeaconScanning()");
        BeaconManager beaconManager = this.beaconManager;
        if (beaconManager == null) {
            Intrinsics.throwNpe();
        }
        beaconManager.addMonitorNotifier((MonitorNotifier)this.monitorNotifier);
        try {
            BeaconManager beaconManager2 = this.beaconManager;
            if (beaconManager2 == null) {
                Intrinsics.throwNpe();
            }
            beaconManager2.startMonitoringBeaconsInRegion(this.scanRegion);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"BLE scan service not yet bound.", (Throwable)e);
        }
    }

    @NotNull
    public final byte[] getAdvertiseId(@NotNull Beacon beacon) {
        Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
        Identifier namespaceId = beacon.getId1();
        String string2 = namespaceId.toHexString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"namespaceId.toHexString()");
        String string3 = string2;
        int n = 2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String namespaceIdHex = string5;
        Identifier instanceId = beacon.getId2();
        String string6 = instanceId.toHexString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"instanceId.toHexString()");
        String string7 = string6;
        int n2 = 2;
        boolean bl2 = false;
        String string8 = string7;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
        String instanceIdHex = string9;
        byte[] namespaceBytes = new byte[]{};
        try {
            String string10 = namespaceIdHex;
            bl2 = false;
            String string11 = string10;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string11.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            byte[] byArray = Hex.decodeHex((char[])cArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Hex.decodeHex(namespaceIdHex.toCharArray())");
            namespaceBytes = byArray;
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        byte[] instanceBytes = new byte[]{};
        try {
            String string12 = instanceIdHex;
            boolean bl3 = false;
            String string13 = string12;
            if (string13 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string13.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            byte[] byArray = Hex.decodeHex((char[])cArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Hex.decodeHex(instanceIdHex.toCharArray())");
            instanceBytes = byArray;
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        byte[] byArray = Bytes.concat((byte[][])new byte[][]{namespaceBytes, instanceBytes});
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Bytes.concat(namespaceBytes, instanceBytes)");
        return byArray;
    }

    public BeaconScanHelper(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.beaconConsumer = new BeaconConsumer(this){
            final /* synthetic */ BeaconScanHelper this$0;

            public void onBeaconServiceConnect() {
                Log.d((String)BeaconScanHelper.access$getTAG$cp(), (String)"onBeaconServiceConnected(): Connected!");
                BeaconScanHelper.access$setConnectedToBeaconService$p(this.this$0, true);
                if (BeaconScanHelper.access$isScanning$p(this.this$0)) {
                    BeaconManager beaconManager = BeaconScanHelper.access$getBeaconManager$p(this.this$0);
                    if (beaconManager == null) {
                        Intrinsics.throwNpe();
                    }
                    if (beaconManager.getMonitoringNotifiers().isEmpty()) {
                        BeaconScanHelper.access$startBeaconScanning(this.this$0);
                    }
                }
            }

            @NotNull
            public Context getApplicationContext() {
                return BeaconScanHelper.access$getContext$p(this.this$0);
            }

            public void unbindService(@NotNull ServiceConnection serviceConnection) {
                Intrinsics.checkParameterIsNotNull((Object)serviceConnection, (String)"serviceConnection");
                BeaconScanHelper.access$getContext$p(this.this$0).unbindService(serviceConnection);
            }

            public boolean bindService(@NotNull Intent intent, @NotNull ServiceConnection serviceConnection, int i) {
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                Intrinsics.checkParameterIsNotNull((Object)serviceConnection, (String)"serviceConnection");
                return BeaconScanHelper.access$getContext$p(this.this$0).bindService(intent, serviceConnection, i);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.monitorNotifier = new MonitorNotifier(this){
            final /* synthetic */ BeaconScanHelper this$0;

            public void didEnterRegion(@NotNull Region region) {
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                this.regionEntered(region);
            }

            public void didExitRegion(@NotNull Region region) {
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                this.regionExited(region);
            }

            public void didDetermineStateForRegion(int regionState, @NotNull Region region) {
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                if (regionState == 1) {
                    this.regionEntered(region);
                } else if (regionState == 0) {
                    this.regionExited(region);
                }
            }

            protected final void regionEntered(@NotNull Region region) {
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                try {
                    Object object;
                    Log.d((String)BeaconScanHelper.access$getTAG$cp(), (String)("Region entered = '" + region + "'."));
                    BeaconManager beaconManager = BeaconScanHelper.access$getBeaconManager$p(this.this$0);
                    if (beaconManager == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((object = BeaconScanHelper.access$getRangeNotifier$p(this.this$0)) != null) {
                        Function2 function2 = object;
                        object = new BeaconScanHelper$sam$org_altbeacon_beacon_RangeNotifier$0(function2);
                    }
                    beaconManager.addRangeNotifier((RangeNotifier)object);
                    BeaconManager beaconManager2 = BeaconScanHelper.access$getBeaconManager$p(this.this$0);
                    if (beaconManager2 == null) {
                        Intrinsics.throwNpe();
                    }
                    beaconManager2.startRangingBeaconsInRegion(region);
                }
                catch (RemoteException e) {
                    Log.e((String)BeaconScanHelper.access$getTAG$cp(), (String)"Unable to start ranging.", (Throwable)e);
                }
            }

            protected final void regionExited(@NotNull Region region) {
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                try {
                    BeaconManager beaconManager = BeaconScanHelper.access$getBeaconManager$p(this.this$0);
                    if (beaconManager == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!beaconManager.getRangingNotifiers().isEmpty()) {
                        Log.d((String)BeaconScanHelper.access$getTAG$cp(), (String)("Region exited= '" + region + "'."));
                        BeaconManager beaconManager2 = BeaconScanHelper.access$getBeaconManager$p(this.this$0);
                        if (beaconManager2 == null) {
                            Intrinsics.throwNpe();
                        }
                        beaconManager2.stopRangingBeaconsInRegion(region);
                        Subject subject = BeaconScanHelper.access$getScanForRegionSubject$p(this.this$0);
                        if (subject == null) {
                            Intrinsics.throwNpe();
                        }
                        subject.onNext((Object)new BeaconUpdate());
                    }
                }
                catch (RemoteException e) {
                    Log.e((String)BeaconScanHelper.access$getTAG$cp(), (String)"Unable to stop ranging.", (Throwable)e);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.rangeNotifier = (Function2)new Function2<Collection<? extends Beacon>, Region, Unit>(this){
            final /* synthetic */ BeaconScanHelper this$0;

            public final void invoke(@NotNull Collection<? extends Beacon> nearbyBeacons, @NotNull Region region) {
                Intrinsics.checkParameterIsNotNull(nearbyBeacons, (String)"nearbyBeacons");
                Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
                Log.d((String)BeaconScanHelper.access$getTAG$cp(), (String)("Ranging update.  Nearby Beacons='" + nearbyBeacons + "', Region='" + region + "'."));
                for (Beacon beacon : nearbyBeacons) {
                    Subject subject = BeaconScanHelper.access$getScanForRegionSubject$p(this.this$0);
                    if (subject == null) {
                        Intrinsics.throwNpe();
                    }
                    subject.onNext((Object)new BeaconUpdate(beacon));
                }
            }
            {
                this.this$0 = beaconScanHelper;
                super(2);
            }
        };
    }

    static {
        Companion = new Companion(null);
        TAG = BeaconScanHelper.class.getSimpleName();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ boolean access$isConnectedToBeaconService$p(BeaconScanHelper $this) {
        return $this.isConnectedToBeaconService;
    }

    public static final /* synthetic */ void access$setConnectedToBeaconService$p(BeaconScanHelper $this, boolean bl) {
        $this.isConnectedToBeaconService = bl;
    }

    public static final /* synthetic */ boolean access$isScanning$p(BeaconScanHelper $this) {
        return $this.isScanning;
    }

    public static final /* synthetic */ void access$setScanning$p(BeaconScanHelper $this, boolean bl) {
        $this.isScanning = bl;
    }

    public static final /* synthetic */ BeaconManager access$getBeaconManager$p(BeaconScanHelper $this) {
        return $this.beaconManager;
    }

    public static final /* synthetic */ void access$setBeaconManager$p(BeaconScanHelper $this, BeaconManager beaconManager) {
        $this.beaconManager = beaconManager;
    }

    public static final /* synthetic */ void access$startBeaconScanning(BeaconScanHelper $this) {
        $this.startBeaconScanning();
    }

    public static final /* synthetic */ Context access$getContext$p(BeaconScanHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ Function2 access$getRangeNotifier$p(BeaconScanHelper $this) {
        return $this.rangeNotifier;
    }

    public static final /* synthetic */ Subject access$getScanForRegionSubject$p(BeaconScanHelper $this) {
        return $this.scanForRegionSubject;
    }

    public static final /* synthetic */ void access$setScanForRegionSubject$p(BeaconScanHelper $this, Subject subject) {
        $this.scanForRegionSubject = subject;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R.\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00072\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper$BeaconUpdate;", "", "()V", "beacon", "Lorg/altbeacon/beacon/Beacon;", "(Lorg/altbeacon/beacon/Beacon;)V", "<set-?>", "Lcom/google/common/base/Optional;", "getBeacon", "()Lcom/google/common/base/Optional;", "lib-google-proximity_release"})
    public static final class BeaconUpdate {
        @Nullable
        private Optional<Beacon> beacon;

        @Nullable
        public final Optional<Beacon> getBeacon() {
            return this.beacon;
        }

        public BeaconUpdate() {
            this.beacon = Optional.absent();
        }

        public BeaconUpdate(@NotNull Beacon beacon) {
            Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
            this.beacon = Optional.of((Object)beacon);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "lib-google-proximity_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

