/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.f2prateek.rx.preferences2.Preference;
import com.f2prateek.rx.preferences2.RxSharedPreferences;
import com.google.common.base.Strings;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper;
import com.ndipatri.iot.googleproximity.container.ObjectGraph;
import com.ndipatri.iot.googleproximity.utils.BeaconScanHelper;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.altbeacon.beacon.Beacon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010\"\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0003J\u001a\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150(0'2\u0006\u0010)\u001a\u00020*J\u001a\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150(0'2\u0006\u0010+\u001a\u00020,J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u00020\u0015J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020\u001f2\b\u00104\u001a\u0004\u0018\u00010\u0015J\u0006\u00105\u001a\u00020\u001fJ!\u00106\u001a\u0002072\u0006\u0010)\u001a\u00020*2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00150(\u00a2\u0006\u0002\u00109J!\u00106\u001a\u0002072\u0006\u0010+\u001a\u00020,2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00150(\u00a2\u0006\u0002\u0010:R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/ndipatri/iot/googleproximity/GoogleProximity;", "", "context", "Landroid/content/Context;", "trustAllConnections", "", "(Landroid/content/Context;Z)V", "beaconProximityHelper", "Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper;", "getBeaconProximityHelper", "()Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper;", "setBeaconProximityHelper", "(Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper;)V", "beaconScanHelper", "Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper;", "getBeaconScanHelper", "()Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper;", "setBeaconScanHelper", "(Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper;)V", "googleAccountForOAuth", "Lcom/f2prateek/rx/preferences2/Preference;", "", "getGoogleAccountForOAuth", "()Lcom/f2prateek/rx/preferences2/Preference;", "graph", "Lcom/ndipatri/iot/googleproximity/container/ObjectGraph;", "getGraph", "()Lcom/ndipatri/iot/googleproximity/container/ObjectGraph;", "sharedPreferences", "Lcom/f2prateek/rx/preferences2/RxSharedPreferences;", "clearGoogleAccountForOAuth", "", "getOAuthToken", "Lio/reactivex/Single;", "selectedGoogleAccount", "hasGoogleAccountForOAuth", "redirectToAuthenticationActivityIfNecessary", "activity", "retrieveAttachment", "Lio/reactivex/Maybe;", "", "advertiseId", "", "beacon", "Lorg/altbeacon/beacon/Beacon;", "scanForNearbyBeacon", "Lio/reactivex/Observable;", "Lcom/ndipatri/iot/googleproximity/utils/BeaconScanHelper$BeaconUpdate;", "beaconNamespaceId", "timeoutSeconds", "", "setGoogleAccountForOAuth", "googleAccount", "stopBeaconScanning", "updateBeacon", "Lio/reactivex/Completable;", "attachment", "([B[Ljava/lang/String;)Lio/reactivex/Completable;", "(Lorg/altbeacon/beacon/Beacon;[Ljava/lang/String;)Lio/reactivex/Completable;", "Companion", "lib-google-proximity_release"})
public final class GoogleProximity {
    @NotNull
    private final ObjectGraph graph;
    private final RxSharedPreferences sharedPreferences;
    @Inject
    @NotNull
    public BeaconProximityHelper beaconProximityHelper;
    @Inject
    @NotNull
    public BeaconScanHelper beaconScanHelper;
    private static final String TAG;
    @Nullable
    private static GoogleProximity instance;
    public static final Companion Companion;

    @NotNull
    public final ObjectGraph getGraph() {
        return this.graph;
    }

    @NotNull
    public final BeaconProximityHelper getBeaconProximityHelper() {
        BeaconProximityHelper beaconProximityHelper = this.beaconProximityHelper;
        if (beaconProximityHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconProximityHelper");
        }
        return beaconProximityHelper;
    }

    public final void setBeaconProximityHelper(@NotNull BeaconProximityHelper beaconProximityHelper) {
        Intrinsics.checkParameterIsNotNull((Object)beaconProximityHelper, (String)"<set-?>");
        this.beaconProximityHelper = beaconProximityHelper;
    }

    @NotNull
    public final BeaconScanHelper getBeaconScanHelper() {
        BeaconScanHelper beaconScanHelper = this.beaconScanHelper;
        if (beaconScanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconScanHelper");
        }
        return beaconScanHelper;
    }

    public final void setBeaconScanHelper(@NotNull BeaconScanHelper beaconScanHelper) {
        Intrinsics.checkParameterIsNotNull((Object)beaconScanHelper, (String)"<set-?>");
        this.beaconScanHelper = beaconScanHelper;
    }

    @NotNull
    public final Preference<String> getGoogleAccountForOAuth() {
        Preference preference = this.sharedPreferences.getString("GOOGLE_ACCOUNT_FOR_OAUTH", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)preference, (String)"sharedPreferences.getStr\u2026ACCOUNT_FOR_OAUTH\", null)");
        return preference;
    }

    public final void setGoogleAccountForOAuth(@Nullable String googleAccount) {
        this.getGoogleAccountForOAuth().set((Object)googleAccount);
    }

    public final void clearGoogleAccountForOAuth() {
        this.setGoogleAccountForOAuth(null);
    }

    public final boolean hasGoogleAccountForOAuth() {
        return !Strings.isNullOrEmpty((String)((String)this.getGoogleAccountForOAuth().get()));
    }

    @NotNull
    public final Maybe<String[]> retrieveAttachment(@NotNull Beacon beacon) {
        Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
        BeaconScanHelper beaconScanHelper = this.beaconScanHelper;
        if (beaconScanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconScanHelper");
        }
        if (beaconScanHelper == null) {
            Intrinsics.throwNpe();
        }
        return this.retrieveAttachment(beaconScanHelper.getAdvertiseId(beacon));
    }

    @NotNull
    public final Maybe<String[]> retrieveAttachment(@NotNull byte[] advertiseId) {
        Intrinsics.checkParameterIsNotNull((Object)advertiseId, (String)"advertiseId");
        BeaconProximityHelper beaconProximityHelper = this.beaconProximityHelper;
        if (beaconProximityHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconProximityHelper");
        }
        if (beaconProximityHelper == null) {
            Intrinsics.throwNpe();
        }
        return beaconProximityHelper.retrieveAttachment(advertiseId);
    }

    @NotNull
    public final Completable updateBeacon(@NotNull Beacon beacon, @NotNull String[] attachment) {
        Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        BeaconScanHelper beaconScanHelper = this.beaconScanHelper;
        if (beaconScanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconScanHelper");
        }
        if (beaconScanHelper == null) {
            Intrinsics.throwNpe();
        }
        return this.updateBeacon(beaconScanHelper.getAdvertiseId(beacon), attachment);
    }

    @NotNull
    public final Completable updateBeacon(@NotNull byte[] advertiseId, @NotNull String[] attachment) {
        Intrinsics.checkParameterIsNotNull((Object)advertiseId, (String)"advertiseId");
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        BeaconProximityHelper beaconProximityHelper = this.beaconProximityHelper;
        if (beaconProximityHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconProximityHelper");
        }
        if (beaconProximityHelper == null) {
            Intrinsics.throwNpe();
        }
        return beaconProximityHelper.createAttachment(advertiseId, attachment);
    }

    public final void redirectToAuthenticationActivityIfNecessary(@NotNull Context activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        BeaconProximityHelper beaconProximityHelper = this.beaconProximityHelper;
        if (beaconProximityHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconProximityHelper");
        }
        if (beaconProximityHelper == null) {
            Intrinsics.throwNpe();
        }
        beaconProximityHelper.redirectToAuthenticationActivityIfNecessary(activity);
    }

    @NotNull
    public final Single<String> getOAuthToken(@NotNull String selectedGoogleAccount) {
        Intrinsics.checkParameterIsNotNull((Object)selectedGoogleAccount, (String)"selectedGoogleAccount");
        BeaconProximityHelper beaconProximityHelper = this.beaconProximityHelper;
        if (beaconProximityHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconProximityHelper");
        }
        if (beaconProximityHelper == null) {
            Intrinsics.throwNpe();
        }
        return beaconProximityHelper.getOAuthToken(selectedGoogleAccount);
    }

    @NotNull
    public final Observable<BeaconScanHelper.BeaconUpdate> scanForNearbyBeacon(@NotNull String beaconNamespaceId) {
        Intrinsics.checkParameterIsNotNull((Object)beaconNamespaceId, (String)"beaconNamespaceId");
        BeaconScanHelper beaconScanHelper = this.beaconScanHelper;
        if (beaconScanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconScanHelper");
        }
        if (beaconScanHelper == null) {
            Intrinsics.throwNpe();
        }
        return BeaconScanHelper.scanForNearbyBeacon$default(beaconScanHelper, beaconNamespaceId, 0, 2, null);
    }

    @NotNull
    public final Observable<BeaconScanHelper.BeaconUpdate> scanForNearbyBeacon(@NotNull String beaconNamespaceId, int timeoutSeconds) {
        Intrinsics.checkParameterIsNotNull((Object)beaconNamespaceId, (String)"beaconNamespaceId");
        BeaconScanHelper beaconScanHelper = this.beaconScanHelper;
        if (beaconScanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconScanHelper");
        }
        if (beaconScanHelper == null) {
            Intrinsics.throwNpe();
        }
        return beaconScanHelper.scanForNearbyBeacon(beaconNamespaceId, timeoutSeconds);
    }

    public final void stopBeaconScanning() {
        BeaconScanHelper beaconScanHelper = this.beaconScanHelper;
        if (beaconScanHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"beaconScanHelper");
        }
        if (beaconScanHelper == null) {
            Intrinsics.throwNpe();
        }
        beaconScanHelper.stopBeaconScanning();
    }

    public GoogleProximity(@NotNull Context context, boolean trustAllConnections) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        RxSharedPreferences rxSharedPreferences = RxSharedPreferences.create((SharedPreferences)PreferenceManager.getDefaultSharedPreferences((Context)context));
        Intrinsics.checkExpressionValueIsNotNull((Object)rxSharedPreferences, (String)"RxSharedPreferences.crea\u2026aredPreferences(context))");
        this.sharedPreferences = rxSharedPreferences;
        this.graph = ObjectGraph.Initializer.INSTANCE.init(context, trustAllConnections);
        this.graph.inject(this);
    }

    static {
        Companion = new Companion(null);
        TAG = GoogleProximity.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/ndipatri/iot/googleproximity/GoogleProximity$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "<set-?>", "Lcom/ndipatri/iot/googleproximity/GoogleProximity;", "instance", "getInstance", "()Lcom/ndipatri/iot/googleproximity/GoogleProximity;", "setInstance", "(Lcom/ndipatri/iot/googleproximity/GoogleProximity;)V", "initialize", "", "context", "Landroid/content/Context;", "trustAllConnections", "", "lib-google-proximity_release"})
    public static final class Companion {
        @Nullable
        public final GoogleProximity getInstance() {
            return instance;
        }

        private final void setInstance(GoogleProximity googleProximity) {
            instance = googleProximity;
        }

        public final void initialize(@NotNull Context context, boolean trustAllConnections) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.setInstance(new GoogleProximity(context, trustAllConnections));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

