/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.util.Log;
import com.google.common.collect.ImmutableList;
import com.ndipatri.iot.googleproximity.BeaconProximityAPI;
import com.ndipatri.iot.googleproximity.models.api.AdvertisedId;
import com.ndipatri.iot.googleproximity.models.api.AttachmentInfo;
import com.ndipatri.iot.googleproximity.models.api.BatchDeleteResponse;
import com.ndipatri.iot.googleproximity.models.api.Beacon;
import com.ndipatri.iot.googleproximity.models.api.GetForObservedRequest;
import com.ndipatri.iot.googleproximity.models.api.GetForObservedResponse;
import com.ndipatri.iot.googleproximity.models.api.ListNamespacesResponse;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Url;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0003%&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001f0\u001e2\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0014\u001a\u00020\u0006J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityAPI;", "", "trustAllConnections", "", "(Z)V", "API_KEY", "", "getAPI_KEY$lib_google_proximity_release", "()Ljava/lang/String;", "setAPI_KEY$lib_google_proximity_release", "(Ljava/lang/String;)V", "service", "Lcom/ndipatri/iot/googleproximity/BeaconProximityAPI$GoogleProximityApiInterface;", "trustAllSSLConnectionsClient", "Lokhttp3/OkHttpClient;", "getTrustAllSSLConnectionsClient", "()Lokhttp3/OkHttpClient;", "activateBeacon", "Lio/reactivex/Completable;", "beaconName", "googleAccountToken", "batchDeleteAttachments", "Lio/reactivex/Single;", "Lcom/ndipatri/iot/googleproximity/models/api/BatchDeleteResponse;", "createAttachment", "Lcom/ndipatri/iot/googleproximity/models/api/AttachmentInfo;", "attachment", "getBeacon", "Lcom/ndipatri/iot/googleproximity/models/api/Beacon;", "getBeaconAttachment", "Lio/reactivex/Maybe;", "", "advertisedId", "Lcom/ndipatri/iot/googleproximity/models/api/AdvertisedId;", "getNamespace", "registerBeacon", "beacon", "Companion", "CorruptAttachmentException", "GoogleProximityApiInterface", "lib-google-proximity_release"})
public final class BeaconProximityAPI {
    @NotNull
    private String API_KEY = "AIzaSyBRQezTd3GBi-az6US93nE_DfQj6kUkmvc";
    private final GoogleProximityApiInterface service;
    private static final String TAG;
    private static final String ENDPOINT = "https://proximitybeacon.googleapis.com/v1beta1/";
    public static final Companion Companion;

    @NotNull
    public final String getAPI_KEY$lib_google_proximity_release() {
        return this.API_KEY;
    }

    public final void setAPI_KEY$lib_google_proximity_release(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.API_KEY = string;
    }

    private final OkHttpClient getTrustAllSSLConnectionsClient() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, BeaconProximityAPI.Companion.getTrustAllCertsTrustManager(), new SecureRandom());
        SSLContext sSLContext = sslContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"sslContext");
        SSLSocketFactory sslSocketFactory = sSLContext.getSocketFactory();
        OkHttpClient.Builder authClientBuilder = new OkHttpClient.Builder();
        authClientBuilder.sslSocketFactory(sslSocketFactory);
        OkHttpClient okHttpClient = authClientBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"authClientBuilder.build()");
        return okHttpClient;
    }

    @NotNull
    public final Maybe<String[]> getBeaconAttachment(@NotNull AdvertisedId advertisedId) {
        Intrinsics.checkParameterIsNotNull((Object)advertisedId, (String)"advertisedId");
        GetForObservedRequest getForObservedRequest = new GetForObservedRequest();
        getForObservedRequest.setNamespacedTypes((List)ImmutableList.of((Object)"*"));
        getForObservedRequest.setObservations((List)ImmutableList.of((Object)new GetForObservedRequest.Observation(advertisedId)));
        String url = ENDPOINT + "beaconinfo:getforobserved?key=" + this.API_KEY;
        Maybe maybe = this.service.getForObserved(url, getForObservedRequest).flatMapMaybe((Function)getBeaconAttachment.1.INSTANCE).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"service.getForObserved(u\u2026dSchedulers.mainThread())");
        return maybe;
    }

    @NotNull
    public final Single<String> getNamespace(@NotNull String googleAccountToken) {
        Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
        Single single = this.service.listNamespaces("Bearer " + googleAccountToken).flatMap((Function)getNamespace.1.INSTANCE).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"service.listNamespaces(\"\u2026dSchedulers.mainThread())");
        return single;
    }

    @NotNull
    public final Single<Beacon> registerBeacon(@NotNull Beacon beacon, @NotNull String googleAccountToken) {
        Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
        Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
        String url = ENDPOINT + "beacons:register";
        return this.service.registerBeacon(url, beacon, "Bearer " + googleAccountToken);
    }

    @NotNull
    public final Completable activateBeacon(@NotNull String beaconName, @NotNull String googleAccountToken) {
        Intrinsics.checkParameterIsNotNull((Object)beaconName, (String)"beaconName");
        Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
        String url = ENDPOINT + "beacons/" + beaconName + ":activate";
        return this.service.activateBeacon(url, "Bearer " + googleAccountToken);
    }

    @NotNull
    public final Single<Beacon> getBeacon(@NotNull String beaconName, @NotNull String googleAccountToken) {
        Intrinsics.checkParameterIsNotNull((Object)beaconName, (String)"beaconName");
        Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
        return this.service.getBeacon(beaconName, "Bearer " + googleAccountToken);
    }

    @NotNull
    public final Single<BatchDeleteResponse> batchDeleteAttachments(@NotNull String beaconName, @NotNull String googleAccountToken) {
        Intrinsics.checkParameterIsNotNull((Object)beaconName, (String)"beaconName");
        Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
        String url = ENDPOINT + "beacons/" + beaconName + "/attachments:batchDelete";
        return this.service.batchDeleteAttachments(url, "Bearer " + googleAccountToken);
    }

    @NotNull
    public final Single<AttachmentInfo> createAttachment(@NotNull AttachmentInfo attachment, @NotNull String beaconName, @NotNull String googleAccountToken) {
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        Intrinsics.checkParameterIsNotNull((Object)beaconName, (String)"beaconName");
        Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
        return this.service.createAttachment(attachment, beaconName, "Bearer " + googleAccountToken);
    }

    public BeaconProximityAPI(boolean trustAllConnections) {
        Retrofit retrofit = null;
        try {
            Retrofit.Builder builder = new Retrofit.Builder().baseUrl(ENDPOINT).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io())).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
            if (trustAllConnections) {
                builder.client(this.getTrustAllSSLConnectionsClient());
            } else {
                builder.client(new OkHttpClient());
            }
            retrofit = builder.build();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception while constructing Retrofit.", (Throwable)e);
        }
        Retrofit retrofit2 = retrofit;
        if (retrofit2 == null) {
            Intrinsics.throwNpe();
        }
        Object object = retrofit2.create(GoogleProximityApiInterface.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"retrofit!!.create(Google\u2026iInterface::class.java!!)");
        this.service = (GoogleProximityApiInterface)object;
    }

    static {
        Companion = new Companion(null);
        TAG = BeaconProximityAPI.class.getSimpleName();
        ENDPOINT = ENDPOINT;
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityAPI$CorruptAttachmentException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "lib-google-proximity_release"})
    public static final class CorruptAttachmentException
    extends Exception {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\b\b\u0001\u0010\r\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0012\u001a\u00020\u0013H'J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\b2\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0017\u001a\u00020\u000f2\b\b\u0001\u0010\u0006\u001a\u00020\u0005H'\u00a8\u0006\u0018"}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityAPI$GoogleProximityApiInterface;", "", "activateBeacon", "Lio/reactivex/Completable;", "url", "", "authorization", "batchDeleteAttachments", "Lio/reactivex/Single;", "Lcom/ndipatri/iot/googleproximity/models/api/BatchDeleteResponse;", "createAttachment", "Lcom/ndipatri/iot/googleproximity/models/api/AttachmentInfo;", "attachment", "beaconName", "getBeacon", "Lcom/ndipatri/iot/googleproximity/models/api/Beacon;", "getForObserved", "Lcom/ndipatri/iot/googleproximity/models/api/GetForObservedResponse;", "getForObservedRequest", "Lcom/ndipatri/iot/googleproximity/models/api/GetForObservedRequest;", "listNamespaces", "Lcom/ndipatri/iot/googleproximity/models/api/ListNamespacesResponse;", "registerBeacon", "beacon", "lib-google-proximity_release"})
    private static interface GoogleProximityApiInterface {
        @POST
        @NotNull
        public Single<GetForObservedResponse> getForObserved(@Url @NotNull String var1, @Body @NotNull GetForObservedRequest var2);

        @GET(value="namespaces")
        @NotNull
        public Single<ListNamespacesResponse> listNamespaces(@Header(value="Authorization") @NotNull String var1);

        @POST
        @NotNull
        public Single<Beacon> registerBeacon(@Url @NotNull String var1, @Body @NotNull Beacon var2, @Header(value="Authorization") @NotNull String var3);

        @POST
        @NotNull
        public Completable activateBeacon(@Url @NotNull String var1, @Header(value="Authorization") @NotNull String var2);

        @GET(value="beacons/{beaconName}")
        @NotNull
        public Single<Beacon> getBeacon(@Path(value="beaconName") @NotNull String var1, @Header(value="Authorization") @NotNull String var2);

        @POST
        @NotNull
        public Single<BatchDeleteResponse> batchDeleteAttachments(@Url @NotNull String var1, @Header(value="Authorization") @NotNull String var2);

        @POST(value="beacons/{beaconName}/attachments")
        @NotNull
        public Single<AttachmentInfo> createAttachment(@Body @NotNull AttachmentInfo var1, @Path(value="beaconName") @NotNull String var2, @Header(value="Authorization") @NotNull String var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityAPI$Companion;", "", "()V", "ENDPOINT", "", "TAG", "kotlin.jvm.PlatformType", "trustAllCertsTrustManager", "", "Ljavax/net/ssl/TrustManager;", "getTrustAllCertsTrustManager", "()[Ljavax/net/ssl/TrustManager;", "lib-google-proximity_release"})
    public static final class Companion {
        private final TrustManager[] getTrustAllCertsTrustManager() {
            return new TrustManager[]{new X509TrustManager(){

                public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
                    Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                    Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
                }

                public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
                    Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                    Intrinsics.checkParameterIsNotNull((Object)authType, (String)"authType");
                }

                @NotNull
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

