/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.ndipatri.iot.googleproximity.BeaconProximityAPI;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper;
import com.ndipatri.iot.googleproximity.GoogleProximity;
import com.ndipatri.iot.googleproximity.activities.AuthenticationActivity;
import com.ndipatri.iot.googleproximity.models.api.AttachmentInfo;
import com.ndipatri.iot.googleproximity.models.api.BatchDeleteResponse;
import com.ndipatri.iot.googleproximity.models.api.Beacon;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.CompletableSource;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import retrofit2.HttpException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J!\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018H\u0002\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00180&2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006)"}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper;", "", "context", "Landroid/content/Context;", "trustAllConnections", "", "(Landroid/content/Context;Z)V", "attachmentCache", "Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper$AttachmentCache;", "beaconProximityAPI", "Lcom/ndipatri/iot/googleproximity/BeaconProximityAPI;", "getContext", "()Landroid/content/Context;", "namespaceSingle", "Lio/reactivex/Single;", "", "oAuthToken", "getOAuthToken", "()Lio/reactivex/Single;", "createAttachment", "Lio/reactivex/Completable;", "advertiseId", "", "attachment", "", "([B[Ljava/lang/String;)Lio/reactivex/Completable;", "_selectedGoogleAccount", "initializeProximityAPIForBeacon", "apiBeacon", "Lcom/ndipatri/iot/googleproximity/models/api/Beacon;", "redirectToAuthenticationActivityIfNecessary", "", "activity", "registerAndActivateBeacon", "renderAttachmentInfo", "Lcom/ndipatri/iot/googleproximity/models/api/AttachmentInfo;", "([Ljava/lang/String;)Lio/reactivex/Single;", "retrieveAttachment", "Lio/reactivex/Maybe;", "AttachmentCache", "Companion", "lib-google-proximity_release"})
public final class BeaconProximityHelper {
    private final Single<String> namespaceSingle;
    private final BeaconProximityAPI beaconProximityAPI;
    private final AttachmentCache attachmentCache;
    @NotNull
    private final Context context;
    private static final String TAG;
    private static final int PROXIMITY_API_CALL_TIMEOUT_MILLIS = 20000;
    private static final String OAUTH_SCOPE_PROXIMITY = "oauth2:https://www.googleapis.com/auth/userlocation.beacon.registry";
    public static final Companion Companion;

    private final Single<String> getOAuthToken() {
        return this.getOAuthToken(null);
    }

    public final void redirectToAuthenticationActivityIfNecessary(@NotNull Context activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        GoogleProximity googleProximity = GoogleProximity.Companion.getInstance();
        if (googleProximity == null) {
            Intrinsics.throwNpe();
        }
        if (!googleProximity.hasGoogleAccountForOAuth()) {
            Intent intent = new Intent(this.context, AuthenticationActivity.class);
            activity.startActivity(intent);
        }
    }

    @NotNull
    public final Maybe<String[]> retrieveAttachment(@NotNull byte[] advertiseId) {
        Intrinsics.checkParameterIsNotNull((Object)advertiseId, (String)"advertiseId");
        Beacon apiBeacon = new Beacon(advertiseId);
        String[] cachedAttachment = this.attachmentCache.getAttachment(apiBeacon);
        if (cachedAttachment != null) {
            Log.d((String)TAG, (String)"Using cached attachment data.");
            Maybe maybe = Maybe.just((Object)cachedAttachment);
            Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"Maybe.just(cachedAttachment)");
            return maybe;
        }
        Maybe maybe = this.beaconProximityAPI.getBeaconAttachment(apiBeacon.getAdvertisedId()).flatMap(new Function<T, MaybeSource<? extends R>>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            public final Maybe<String[]> apply(@NotNull String[] attachment) {
                Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
                return Maybe.create((MaybeOnSubscribe)((MaybeOnSubscribe)new MaybeOnSubscribe<T>(this, attachment){
                    final /* synthetic */ retrieveAttachment.1 this$0;
                    final /* synthetic */ String[] $attachment;

                    public final void subscribe(@NotNull MaybeEmitter<String[]> subscriber) {
                        Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
                        AttachmentCache attachmentCache = BeaconProximityHelper.access$getAttachmentCache$p(this.this$0.this$0);
                        Beacon beacon = this.this$0.$apiBeacon;
                        Intrinsics.checkExpressionValueIsNotNull((Object)this.$attachment, (String)"attachment");
                        attachmentCache.cacheAttachment(beacon, this.$attachment);
                        subscriber.onSuccess((Object)this.$attachment);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$attachment = stringArray;
                    }
                }));
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).timeout((long)PROXIMITY_API_CALL_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"beaconProximityAPI.getBe\u2026dSchedulers.mainThread())");
        return maybe;
    }

    @NotNull
    public final Completable createAttachment(@NotNull byte[] advertiseId, @NotNull String[] attachment) {
        Intrinsics.checkParameterIsNotNull((Object)advertiseId, (String)"advertiseId");
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        Beacon apiBeacon = new Beacon(advertiseId);
        Completable completable = this.initializeProximityAPIForBeacon(apiBeacon).andThen((SingleSource)this.getOAuthToken()).flatMap(new Function<T, SingleSource<? extends R>>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            @NotNull
            public final Single<BatchDeleteResponse> apply(@NotNull String googleAccountToken) {
                Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
                return BeaconProximityHelper.access$getBeaconProximityAPI$p(this.this$0).batchDeleteAttachments(this.$apiBeacon.getBeaconName(), googleAccountToken);
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).flatMap(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ BeaconProximityHelper this$0;

            @NotNull
            public final Single<String> apply(@NotNull BatchDeleteResponse it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return BeaconProximityHelper.access$getOAuthToken$p(this.this$0);
            }
            {
                this.this$0 = beaconProximityHelper;
            }
        }).zipWith((SingleSource)this.renderAttachmentInfo(attachment), (BiFunction)new BiFunction<String, AttachmentInfo, Single<AttachmentInfo>>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            @NotNull
            public final Single<AttachmentInfo> apply(@NotNull String googleAccountToken, @NotNull AttachmentInfo attachmentInfo) {
                Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
                Intrinsics.checkParameterIsNotNull((Object)attachmentInfo, (String)"attachmentInfo");
                return BeaconProximityHelper.access$getBeaconProximityAPI$p(this.this$0).createAttachment(attachmentInfo, this.$apiBeacon.getBeaconName(), googleAccountToken);
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).flatMap((Function)createAttachment.4.INSTANCE).flatMapCompletable((Function)new Function<AttachmentInfo, CompletableSource>(this, advertiseId, apiBeacon, attachment){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ byte[] $advertiseId;
            final /* synthetic */ Beacon $apiBeacon;
            final /* synthetic */ String[] $attachment;

            public final Completable apply(@NotNull AttachmentInfo it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(this){
                    final /* synthetic */ createAttachment.5 this$0;

                    public final void subscribe(@NotNull CompletableEmitter it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Log.d((String)BeaconProximityHelper.access$getTAG$cp(), (String)("Updated Beacon '" + this.this$0.$advertiseId + '\''));
                        BeaconProximityHelper.access$getAttachmentCache$p(this.this$0.this$0).cacheAttachment(this.this$0.$apiBeacon, this.this$0.$attachment);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$advertiseId = byArray;
                this.$apiBeacon = beacon;
                this.$attachment = stringArray;
            }
        }).timeout((long)PROXIMITY_API_CALL_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"initializeProximityAPIFo\u2026dSchedulers.mainThread())");
        return completable;
    }

    @NotNull
    public final Single<String> getOAuthToken(@Nullable String _selectedGoogleAccount) {
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, _selectedGoogleAccount){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ String $_selectedGoogleAccount;

            public final void subscribe(@NotNull SingleEmitter<String> subscriber) {
                block7: {
                    Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
                    String selectedGoogleAccount = this.$_selectedGoogleAccount;
                    if (selectedGoogleAccount == null) {
                        GoogleProximity googleProximity = GoogleProximity.Companion.getInstance();
                        if (googleProximity == null) {
                            Intrinsics.throwNpe();
                        }
                        selectedGoogleAccount = (String)googleProximity.getGoogleAccountForOAuth().get();
                    }
                    String oauthToken = null;
                    try {
                        Log.d((String)BeaconProximityHelper.access$getTAG$cp(), (String)("Retrieving Google OAuth token for Account '" + selectedGoogleAccount + "'..."));
                        oauthToken = GoogleAuthUtil.getToken((Context)this.this$0.getContext(), (String)selectedGoogleAccount, (String)BeaconProximityHelper.access$getOAUTH_SCOPE_PROXIMITY$cp());
                        if (oauthToken == null) {
                            Log.e((String)BeaconProximityHelper.access$getTAG$cp(), (String)"Retrieved null OAuth token.");
                            if (!subscriber.isDisposed()) {
                                subscriber.onError((Throwable)new InvalidParameterException());
                            }
                        } else {
                            Log.e((String)BeaconProximityHelper.access$getTAG$cp(), (String)("Retrieved OAuth token '" + oauthToken + "'."));
                            subscriber.onSuccess((Object)oauthToken);
                        }
                    }
                    catch (Exception ex) {
                        Log.e((String)BeaconProximityHelper.access$getTAG$cp(), (String)"Exception retrieving OAuth token.", (Throwable)ex);
                        if (subscriber.isDisposed()) break block7;
                        subscriber.onError((Throwable)ex);
                    }
                }
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$_selectedGoogleAccount = string;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create { subscrib\u2026dSchedulers.mainThread())");
        return single;
    }

    public static /* synthetic */ Single getOAuthToken$default(BeaconProximityHelper beaconProximityHelper, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return beaconProximityHelper.getOAuthToken(string);
    }

    private final Completable registerAndActivateBeacon(Beacon apiBeacon) {
        Log.d((String)TAG, (String)"New beacon found.  Registering and activating...");
        Completable completable = BeaconProximityHelper.getOAuthToken$default(this, null, 1, null).flatMap(new Function<T, SingleSource<? extends R>>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            @NotNull
            public final Single<Beacon> apply(@NotNull String googleAccountToken) {
                Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
                return BeaconProximityHelper.access$getBeaconProximityAPI$p(this.this$0).registerBeacon(this.$apiBeacon, googleAccountToken);
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).flatMap(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ BeaconProximityHelper this$0;

            @NotNull
            public final Single<String> apply(@NotNull Beacon beacon) {
                Intrinsics.checkParameterIsNotNull((Object)beacon, (String)"beacon");
                return BeaconProximityHelper.access$getOAuthToken$p(this.this$0);
            }
            {
                this.this$0 = beaconProximityHelper;
            }
        }).flatMapCompletable((Function)new Function<String, CompletableSource>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            @NotNull
            public final Completable apply(@NotNull String googleAccountToken) {
                Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
                return BeaconProximityHelper.access$getBeaconProximityAPI$p(this.this$0).activateBeacon(this.$apiBeacon.getBeaconName(), googleAccountToken);
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"getOAuthToken()\n        \u2026dSchedulers.mainThread())");
        return completable;
    }

    private final Single<AttachmentInfo> renderAttachmentInfo(String[] attachment) {
        Single single = this.namespaceSingle.flatMap(new Function<T, SingleSource<? extends R>>(attachment){
            final /* synthetic */ String[] $attachment;

            public final Single<AttachmentInfo> apply(@NotNull String namespace) {
                Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
                return Single.create((SingleOnSubscribe)((SingleOnSubscribe)new SingleOnSubscribe<T>(this, namespace){
                    final /* synthetic */ renderAttachmentInfo.1 this$0;
                    final /* synthetic */ String $namespace;

                    public final void subscribe(@NotNull SingleEmitter<AttachmentInfo> subscriber) {
                        AttachmentInfo attachmentInfo;
                        block2: {
                            Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
                            attachmentInfo = new AttachmentInfo();
                            try {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                ObjectOutputStream objectOut = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
                                objectOut.writeObject(this.this$0.$attachment);
                                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                String string = "%s/%s";
                                Object[] objectArray = new Object[]{this.$namespace, "string"};
                                AttachmentInfo attachmentInfo2 = attachmentInfo;
                                boolean bl = false;
                                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                                String string3 = string2;
                                attachmentInfo2.setNamespacedType(string3);
                                byte[] beaconAttachmentBytes = byteArrayOutputStream.toByteArray();
                                attachmentInfo.setData(Base64.encodeToString((byte[])beaconAttachmentBytes, (int)2));
                            }
                            catch (IOException e) {
                                Log.e((String)BeaconProximityHelper.access$getTAG$cp(), (String)"Unable to serialize BeaconAttachment.", (Throwable)e);
                                if (subscriber.isDisposed()) break block2;
                                subscriber.onError((Throwable)e);
                            }
                        }
                        Log.d((String)BeaconProximityHelper.access$getTAG$cp(), (String)("Rendered beacon attachment '" + attachmentInfo + "'."));
                        subscriber.onSuccess((Object)attachmentInfo);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$namespace = string;
                    }
                }));
            }
            {
                this.$attachment = stringArray;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"namespaceSingle\n        \u2026dSchedulers.mainThread())");
        return single;
    }

    private final Completable initializeProximityAPIForBeacon(Beacon apiBeacon) {
        Completable completable = BeaconProximityHelper.getOAuthToken$default(this, null, 1, null).flatMap(new Function<T, SingleSource<? extends R>>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            @NotNull
            public final Single<Beacon> apply(@NotNull String googleAccountToken) {
                Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
                return BeaconProximityHelper.access$getBeaconProximityAPI$p(this.this$0).getBeacon(this.$apiBeacon.getBeaconName(), googleAccountToken);
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).flatMapCompletable((Function)new Function<Beacon, CompletableSource>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            public final CompletableSource apply(@NotNull Beacon retrievedBeacon) {
                Intrinsics.checkParameterIsNotNull((Object)retrievedBeacon, (String)"retrievedBeacon");
                return Intrinsics.areEqual((Object)retrievedBeacon.getStatus(), (Object)Beacon.Companion.getSTATUS_INACTIVE()) ? (CompletableSource)BeaconProximityHelper.getOAuthToken$default(this.this$0, null, 1, null).flatMapCompletable((Function)new Function<String, CompletableSource>(this){
                    final /* synthetic */ initializeProximityAPIForBeacon.2 this$0;

                    public final Completable apply(@NotNull String googleAccountToken) {
                        Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
                        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(this, googleAccountToken){
                            final /* synthetic */ initializeProximityAPIForBeacon.1 this$0;
                            final /* synthetic */ String $googleAccountToken;

                            public final void subscribe(@NotNull CompletableEmitter it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                BeaconProximityHelper.access$getBeaconProximityAPI$p(this.this$0.this$0.this$0).getBeacon(this.this$0.this$0.$apiBeacon.getBeaconName(), this.$googleAccountToken);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$googleAccountToken = string;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }) : (CompletableSource)(Intrinsics.areEqual((Object)retrievedBeacon.getStatus(), (Object)Beacon.Companion.getSTATUS_UNREGISTERED()) || Intrinsics.areEqual((Object)retrievedBeacon.getStatus(), (Object)Beacon.Companion.getSTATUS_NOT_FOUND()) ? BeaconProximityHelper.access$registerAndActivateBeacon(this.this$0, this.$apiBeacon) : Completable.complete());
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).onErrorResumeNext((Function)new Function<Throwable, Completable>(this, apiBeacon){
            final /* synthetic */ BeaconProximityHelper this$0;
            final /* synthetic */ Beacon $apiBeacon;

            public final Completable apply(@NotNull Throwable throwable) {
                Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                return ((HttpException)throwable).code() == 404 ? BeaconProximityHelper.access$registerAndActivateBeacon(this.this$0, this.$apiBeacon) : Completable.error((Throwable)throwable);
            }
            {
                this.this$0 = beaconProximityHelper;
                this.$apiBeacon = beacon;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"getOAuthToken()\n\n       \u2026dSchedulers.mainThread())");
        return completable;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public BeaconProximityHelper(@NotNull Context context, boolean trustAllConnections) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.beaconProximityAPI = new BeaconProximityAPI(trustAllConnections);
        this.attachmentCache = new AttachmentCache();
        Single single = this.getOAuthToken().flatMap(new Function<T, SingleSource<? extends R>>(){

            @NotNull
            public final Single<String> apply(@NotNull String googleAccountToken) {
                Intrinsics.checkParameterIsNotNull((Object)googleAccountToken, (String)"googleAccountToken");
                return beaconProximityAPI.getNamespace(googleAccountToken);
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).cache();
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"oAuthToken\n             \u2026\n                .cache()");
        this.namespaceSingle = single;
    }

    static {
        Companion = new Companion(null);
        TAG = BeaconProximityHelper.class.getSimpleName();
        PROXIMITY_API_CALL_TIMEOUT_MILLIS = 20000;
        OAUTH_SCOPE_PROXIMITY = OAUTH_SCOPE_PROXIMITY;
    }

    public static final /* synthetic */ AttachmentCache access$getAttachmentCache$p(BeaconProximityHelper $this) {
        return $this.attachmentCache;
    }

    public static final /* synthetic */ Single access$getOAuthToken$p(BeaconProximityHelper $this) {
        return $this.getOAuthToken();
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ String access$getOAUTH_SCOPE_PROXIMITY$cp() {
        return OAUTH_SCOPE_PROXIMITY;
    }

    public static final /* synthetic */ Completable access$registerAndActivateBeacon(BeaconProximityHelper $this, Beacon apiBeacon) {
        return $this.registerAndActivateBeacon(apiBeacon);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001b\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper$AttachmentCache;", "", "()V", "attachmentCache", "Ljava/util/HashMap;", "", "Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper$AttachmentCache$TimedAttachment;", "attachmentLifeMillis", "", "getAttachmentLifeMillis", "()J", "setAttachmentLifeMillis", "(J)V", "cacheAttachment", "", "apiBeacon", "Lcom/ndipatri/iot/googleproximity/models/api/Beacon;", "attachment", "", "(Lcom/ndipatri/iot/googleproximity/models/api/Beacon;[Ljava/lang/String;)V", "generateKey", "getAttachment", "(Lcom/ndipatri/iot/googleproximity/models/api/Beacon;)[Ljava/lang/String;", "TimedAttachment", "lib-google-proximity_release"})
    private static final class AttachmentCache {
        private long attachmentLifeMillis = 1800000;
        private final HashMap<String, TimedAttachment> attachmentCache = new HashMap();

        protected final long getAttachmentLifeMillis() {
            return this.attachmentLifeMillis;
        }

        protected final void setAttachmentLifeMillis(long l) {
            this.attachmentLifeMillis = l;
        }

        public final void cacheAttachment(@NotNull Beacon apiBeacon, @NotNull String[] attachment) {
            Intrinsics.checkParameterIsNotNull((Object)apiBeacon, (String)"apiBeacon");
            Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
            ((Map)this.attachmentCache).put(this.generateKey(apiBeacon), new TimedAttachment(attachment));
        }

        @Nullable
        public final String[] getAttachment(@NotNull Beacon apiBeacon) {
            Intrinsics.checkParameterIsNotNull((Object)apiBeacon, (String)"apiBeacon");
            String beaconKey = this.generateKey(apiBeacon);
            String[] cachedAttachment = null;
            TimedAttachment timedAttachment = this.attachmentCache.get(beaconKey);
            if (timedAttachment != null) {
                DateTime dateTime = DateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now()");
                long l = dateTime.getMillis();
                Long l2 = timedAttachment.getTimestamp$lib_google_proximity_release();
                if (l2 == null) {
                    Intrinsics.throwNpe();
                }
                if (l - l2 < this.attachmentLifeMillis) {
                    cachedAttachment = timedAttachment.getAttachment$lib_google_proximity_release();
                } else {
                    this.attachmentCache.remove(beaconKey);
                }
            }
            return cachedAttachment;
        }

        private final String generateKey(Beacon apiBeacon) {
            return apiBeacon.getBeaconName();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper$AttachmentCache$TimedAttachment;", "", "attachment", "", "", "([Ljava/lang/String;)V", "getAttachment$lib_google_proximity_release", "()[Ljava/lang/String;", "setAttachment$lib_google_proximity_release", "[Ljava/lang/String;", "timestamp", "", "getTimestamp$lib_google_proximity_release", "()Ljava/lang/Long;", "setTimestamp$lib_google_proximity_release", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "lib-google-proximity_release"})
        private static final class TimedAttachment {
            @Nullable
            private Long timestamp;
            @NotNull
            private String[] attachment;

            @Nullable
            public final Long getTimestamp$lib_google_proximity_release() {
                return this.timestamp;
            }

            public final void setTimestamp$lib_google_proximity_release(@Nullable Long l) {
                this.timestamp = l;
            }

            @NotNull
            public final String[] getAttachment$lib_google_proximity_release() {
                return this.attachment;
            }

            public final void setAttachment$lib_google_proximity_release(@NotNull String[] stringArray) {
                Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"<set-?>");
                this.attachment = stringArray;
            }

            public TimedAttachment(@NotNull String[] attachment) {
                Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
                this.attachment = attachment;
                DateTime dateTime = DateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now()");
                this.timestamp = dateTime.getMillis();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ndipatri/iot/googleproximity/BeaconProximityHelper$Companion;", "", "()V", "OAUTH_SCOPE_PROXIMITY", "", "PROXIMITY_API_CALL_TIMEOUT_MILLIS", "", "TAG", "kotlin.jvm.PlatformType", "lib-google-proximity_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

