/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.activities;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.ndipatri.iot.googleproximity.fragments.EnableBluetoothDialogFragment;
import com.ndipatri.iot.googleproximity.fragments.GrantFineLocationAccessDialogFragment;
import com.ndipatri.iot.googleproximity.utils.BluetoothHelper;

public class RequirementsActivity
extends AppCompatActivity {
    private static final String TAG = RequirementsActivity.class.getSimpleName();
    protected EnableBluetoothDialogFragment enableBluetoothDialogFragment;
    protected GrantFineLocationAccessDialogFragment grantFineLocationAccessDialogFragment;
    private BroadcastReceiver bluetoothStateChangeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (null != RequirementsActivity.this.enableBluetoothDialogFragment) {
                RequirementsActivity.this.beginUserPermissionCheck();
            }
        }
    };

    protected void onResume() {
        super.onResume();
        this.beginUserPermissionCheck();
    }

    protected boolean shouldCheckBluetoothPermissions() {
        return true;
    }

    protected void onPause() {
        super.onPause();
        try {
            this.unregisterReceiver(this.bluetoothStateChangeReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected BluetoothHelper getBluetoothHelper() {
        return new BluetoothHelper();
    }

    private void beginUserPermissionCheck() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                this.grantFineLocationAccessDialogFragment = new GrantFineLocationAccessDialogFragment();
                this.grantFineLocationAccessDialogFragment.show(this.getSupportFragmentManager().beginTransaction(), "grant location access dialog");
            } else {
                this.continueWithUserPermissionCheck();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch ((short)requestCode) {
            case 444: {
                if (grantResults[0] == 0) {
                    Log.d((String)TAG, (String)"fine location permission granted");
                    this.continueWithUserPermissionCheck();
                } else {
                    Toast.makeText((Context)this, (CharSequence)"This application cannot run without Fine Location Access!", (int)0).show();
                    this.failedToFulfillRequirements();
                }
                return;
            }
        }
    }

    private void continueWithUserPermissionCheck() {
        if (this.shouldCheckBluetoothPermissions()) {
            if (!this.getBluetoothHelper().isBluetoothSupported()) {
                Toast.makeText((Context)this, (CharSequence)"This application cannot run without Bluetooth support!", (int)0).show();
                this.failedToFulfillRequirements();
            } else if (!this.getBluetoothHelper().isBluetoothEnabled()) {
                this.enableBluetoothDialogFragment = new EnableBluetoothDialogFragment();
                this.enableBluetoothDialogFragment.show(this.getSupportFragmentManager().beginTransaction(), "enable bluetooth dialog");
            } else {
                this.successfullyFulfilledRequirements();
            }
        } else {
            this.successfullyFulfilledRequirements();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case -1: {
                this.enableBluetoothDialogFragment = null;
                if (resultCode == -1) {
                    this.successfullyFulfilledRequirements();
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"This application cannot run without Bluetooth enabled!", (int)0).show();
                this.failedToFulfillRequirements();
            }
        }
    }

    private void registerForBluetoothStateChangeBroadcast() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
        this.registerReceiver(this.bluetoothStateChangeReceiver, filter);
    }

    protected void failedToFulfillRequirements() {
        this.finish();
    }

    protected void successfullyFulfilledRequirements() {
        this.registerForBluetoothStateChangeBroadcast();
    }
}

