/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.ndipatri.iot.googleproximity.BeaconProximityAPI;
import com.ndipatri.iot.googleproximity.GoogleProximity;
import com.ndipatri.iot.googleproximity.activities.AuthenticationActivity;
import com.ndipatri.iot.googleproximity.models.api.AttachmentInfo;
import com.ndipatri.iot.googleproximity.models.api.Beacon;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.joda.time.DateTime;
import retrofit2.HttpException;

public class BeaconProximityHelper {
    private static final String TAG = BeaconProximityHelper.class.getSimpleName();
    private static final int PROXIMITY_API_CALL_TIMEOUT_MILLIS = 20000;
    private static final String OAUTH_SCOPE_PROXIMITY = "oauth2:https://www.googleapis.com/auth/userlocation.beacon.registry";
    private Single<String> namespaceSingle;
    private Context context;
    private BeaconProximityAPI beaconProximityAPI;
    private AttachmentCache attachmentCache = new AttachmentCache();

    public BeaconProximityHelper(Context context, boolean trustAllConnections) {
        this.context = context;
        this.beaconProximityAPI = new BeaconProximityAPI(trustAllConnections);
        this.namespaceSingle = this.getOAuthToken().flatMap(googleAccountToken -> this.beaconProximityAPI.getNamespace((String)googleAccountToken)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).cache();
    }

    public void redirectToAuthenticationActivityIfNecessary(Context activity) {
        if (!GoogleProximity.getInstance().hasGoogleAccountForOAuth()) {
            Intent intent = new Intent(this.context, AuthenticationActivity.class);
            activity.startActivity(intent);
        }
    }

    public Maybe<String[]> retrieveAttachment(byte[] advertiseId) {
        Beacon apiBeacon = new Beacon(advertiseId);
        String[] cachedAttachment = this.attachmentCache.getAttachment(apiBeacon);
        if (null != cachedAttachment) {
            Log.d((String)TAG, (String)"Using cached attachment data.");
            return Maybe.just((Object)cachedAttachment);
        }
        return this.beaconProximityAPI.getBeaconAttachment(apiBeacon.advertisedId).flatMap(attachment -> Maybe.create(subscriber -> {
            this.attachmentCache.cacheAttachment(apiBeacon, (String[])attachment);
            subscriber.onSuccess(attachment);
        })).timeout(20000L, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Completable createAttachment(byte[] advertiseId, String[] attachment) {
        Beacon apiBeacon = new Beacon(advertiseId);
        return this.initializeProximityAPIForBeacon(apiBeacon).andThen(this.getOAuthToken()).flatMap(googleAccountToken -> this.beaconProximityAPI.batchDeleteAttachments(apiBeacon.getBeaconName(), (String)googleAccountToken)).flatMap(batchDeleteResponse -> this.getOAuthToken()).zipWith(this.renderAttachmentInfo(attachment), (googleAccountToken, attachmentInfo) -> this.beaconProximityAPI.createAttachment((AttachmentInfo)attachmentInfo, apiBeacon.getBeaconName(), (String)googleAccountToken)).flatMap(attachmentInfoObservable -> attachmentInfoObservable).flatMapCompletable(attachmentInfo -> subscriber -> {
            Log.d((String)TAG, (String)("Updated Beacon '" + advertiseId + "'"));
            this.attachmentCache.cacheAttachment(apiBeacon, attachment);
            subscriber.onComplete();
        }).timeout(20000L, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getOAuthToken(String _selectedGoogleAccount) {
        return Single.create(subscriber -> {
            block6: {
                String selectedGoogleAccount = _selectedGoogleAccount;
                if (null == selectedGoogleAccount) {
                    selectedGoogleAccount = (String)GoogleProximity.getInstance().getGoogleAccountForOAuth().get();
                }
                String oauthToken = null;
                try {
                    Log.d((String)TAG, (String)("Retrieving Google OAuth token for Account '" + selectedGoogleAccount + "'..."));
                    oauthToken = GoogleAuthUtil.getToken((Context)this.context, (String)selectedGoogleAccount, (String)OAUTH_SCOPE_PROXIMITY);
                    if (null == oauthToken) {
                        Log.e((String)TAG, (String)"Retrieved null OAuth token.");
                        if (!subscriber.isDisposed()) {
                            subscriber.onError((Throwable)new InvalidParameterException());
                        }
                    } else {
                        Log.e((String)TAG, (String)("Retrieved OAuth token '" + oauthToken + "'."));
                        subscriber.onSuccess((Object)oauthToken);
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"Exception retrieving OAuth token.", (Throwable)ex);
                    if (subscriber.isDisposed()) break block6;
                    subscriber.onError((Throwable)ex);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Single<String> getOAuthToken() {
        return this.getOAuthToken(null);
    }

    private Completable registerAndActivateBeacon(Beacon apiBeacon) {
        Log.d((String)TAG, (String)"New beacon found.  Registering and activating...");
        return this.getOAuthToken().flatMap(googleAccountToken -> this.beaconProximityAPI.registerBeacon(apiBeacon, (String)googleAccountToken)).flatMap(beacon -> this.getOAuthToken()).flatMapCompletable(googleAccountToken -> this.beaconProximityAPI.activateBeacon(apiBeacon.getBeaconName(), (String)googleAccountToken)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Single<AttachmentInfo> renderAttachmentInfo(String[] attachment) {
        return this.namespaceSingle.flatMap(namespace -> Single.create(subscriber -> {
            AttachmentInfo attachmentInfo;
            block2: {
                attachmentInfo = new AttachmentInfo();
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOut = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
                    objectOut.writeObject(attachment);
                    attachmentInfo.namespacedType = String.format("%s/%s", namespace, "string");
                    byte[] beaconAttachmentBytes = byteArrayOutputStream.toByteArray();
                    attachmentInfo.data = Base64.encodeToString((byte[])beaconAttachmentBytes, (int)2);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Unable to serialize BeaconAttachment.", (Throwable)e);
                    if (subscriber.isDisposed()) break block2;
                    subscriber.onError((Throwable)e);
                }
            }
            Log.d((String)TAG, (String)("Rendered beacon attachment '" + attachmentInfo + "'."));
            subscriber.onSuccess((Object)attachmentInfo);
        })).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Completable initializeProximityAPIForBeacon(Beacon apiBeacon) {
        return this.getOAuthToken().flatMap(googleAccountToken -> this.beaconProximityAPI.getBeacon(apiBeacon.getBeaconName(), (String)googleAccountToken)).flatMapCompletable(retrievedBeacon -> {
            if (retrievedBeacon.status.equals("INACTIVE")) {
                return this.getOAuthToken().flatMapCompletable(googleAccountToken -> this.beaconProximityAPI.activateBeacon(apiBeacon.getBeaconName(), (String)googleAccountToken));
            }
            if (retrievedBeacon.status.equals("UNREGISTERED") || retrievedBeacon.status.equals("NOT_FOUND")) {
                return this.registerAndActivateBeacon(apiBeacon);
            }
            return Completable.complete();
        }).onErrorResumeNext(throwable -> {
            if (((HttpException)throwable).code() == 404) {
                return this.registerAndActivateBeacon(apiBeacon);
            }
            return Completable.error((Throwable)throwable);
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private class AttachmentCache {
        protected long attachmentLifeMillis = 1800000L;
        private Map<String, TimedAttachment> attachmentCache = new HashMap<String, TimedAttachment>();

        private AttachmentCache() {
        }

        public void cacheAttachment(Beacon apiBeacon, String[] attachment) {
            this.attachmentCache.put(this.generateKey(apiBeacon), new TimedAttachment(attachment));
        }

        public String[] getAttachment(Beacon apiBeacon) {
            String beaconKey = this.generateKey(apiBeacon);
            String[] cachedAttachment = null;
            TimedAttachment timedAttachment = this.attachmentCache.get(beaconKey);
            if (null != timedAttachment) {
                if (DateTime.now().getMillis() - timedAttachment.timestamp < this.attachmentLifeMillis) {
                    cachedAttachment = timedAttachment.attachment;
                } else {
                    this.attachmentCache.remove(beaconKey);
                }
            }
            return cachedAttachment;
        }

        private String generateKey(Beacon apiBeacon) {
            return apiBeacon.getBeaconName();
        }

        private class TimedAttachment {
            String[] attachment;
            Long timestamp;

            public TimedAttachment(String[] attachment) {
                this.attachment = attachment;
                this.timestamp = DateTime.now().getMillis();
            }
        }
    }
}

