/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.util.Base64;
import android.util.Log;
import com.google.common.collect.ImmutableList;
import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import com.ndipatri.iot.googleproximity.BeaconProximityAPI$$Lambda$1;
import com.ndipatri.iot.googleproximity.BeaconProximityAPI$$Lambda$2;
import com.ndipatri.iot.googleproximity.BeaconProximityAPI$$Lambda$3;
import com.ndipatri.iot.googleproximity.models.api.AdvertisedId;
import com.ndipatri.iot.googleproximity.models.api.AttachmentInfo;
import com.ndipatri.iot.googleproximity.models.api.BatchDeleteResponse;
import com.ndipatri.iot.googleproximity.models.api.Beacon;
import com.ndipatri.iot.googleproximity.models.api.GetForObservedRequest;
import com.ndipatri.iot.googleproximity.models.api.GetForObservedResponse;
import com.ndipatri.iot.googleproximity.models.api.ListNamespacesResponse;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Url;

public class BeaconProximityAPI {
    private static final String TAG = BeaconProximityAPI.class.getSimpleName();
    private static final String ENDPOINT = "https://proximitybeacon.googleapis.com/v1beta1/";
    String API_KEY = "AIzaSyBRQezTd3GBi-az6US93nE_DfQj6kUkmvc";
    private final GoogleProximityApiInterface service;

    public BeaconProximityAPI(boolean trustAllConnections) {
        Retrofit retrofit = null;
        try {
            Retrofit.Builder builder = new Retrofit.Builder().baseUrl(ENDPOINT).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.io())).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
            if (trustAllConnections) {
                builder.client(this.getTrustAllSSLConnectionsClient());
            } else {
                builder.client(new OkHttpClient());
            }
            retrofit = builder.build();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception while constructing Retrofit.", (Throwable)e);
        }
        this.service = (GoogleProximityApiInterface)retrofit.create(GoogleProximityApiInterface.class);
    }

    public Maybe<String[]> getBeaconAttachment(AdvertisedId advertisedId) {
        GetForObservedRequest getForObservedRequest = new GetForObservedRequest();
        getForObservedRequest.namespacedTypes = ImmutableList.of((Object)"*");
        getForObservedRequest.observations = ImmutableList.of((Object)new GetForObservedRequest.Observation(advertisedId));
        String url = "https://proximitybeacon.googleapis.com/v1beta1/beaconinfo:getforobserved?key=" + this.API_KEY;
        return this.service.getForObserved(url, getForObservedRequest).flatMapMaybe(BeaconProximityAPI$$Lambda$1.lambdaFactory$()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getNamespace(String googleAccountToken) {
        return this.service.listNamespaces("Bearer " + googleAccountToken).flatMap(BeaconProximityAPI$$Lambda$2.lambdaFactory$()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<Beacon> registerBeacon(Beacon beacon, String googleAccountToken) {
        String url = "https://proximitybeacon.googleapis.com/v1beta1/beacons:register";
        return this.service.registerBeacon(url, beacon, "Bearer " + googleAccountToken);
    }

    public Completable activateBeacon(String beaconName, String googleAccountToken) {
        String url = "https://proximitybeacon.googleapis.com/v1beta1/beacons/" + beaconName + ":activate";
        return this.service.activateBeacon(url, "Bearer " + googleAccountToken);
    }

    public Single<Beacon> getBeacon(String beaconName, String googleAccountToken) {
        return this.service.getBeacon(beaconName, "Bearer " + googleAccountToken);
    }

    public Single<BatchDeleteResponse> batchDeleteAttachments(String beaconName, String googleAccountToken) {
        String url = "https://proximitybeacon.googleapis.com/v1beta1/beacons/" + beaconName + "/attachments:batchDelete";
        return this.service.batchDeleteAttachments(url, "Bearer " + googleAccountToken);
    }

    public Single<AttachmentInfo> createAttachment(AttachmentInfo attachment, String beaconName, String googleAccountToken) {
        return this.service.createAttachment(attachment, beaconName, "Bearer " + googleAccountToken);
    }

    private OkHttpClient getTrustAllSSLConnectionsClient() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, BeaconProximityAPI.getTrustAllCertsTrustManager(), new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        OkHttpClient.Builder authClientBuilder = new OkHttpClient.Builder();
        authClientBuilder.sslSocketFactory(sslSocketFactory);
        return authClientBuilder.build();
    }

    private static TrustManager[] getTrustAllCertsTrustManager() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }

    static /* synthetic */ SingleSource lambda$getNamespace$2(ListNamespacesResponse listNamespacesResponse) throws Exception {
        String namespaceValue = listNamespacesResponse.namespaces.get((int)0).namespaceName;
        if (namespaceValue.startsWith("namespaces/")) {
            namespaceValue = namespaceValue.substring("namespaces/".length());
        }
        return Single.just((Object)namespaceValue);
    }

    static /* synthetic */ MaybeSource lambda$getBeaconAttachment$1(GetForObservedResponse getForObservedResponse) throws Exception {
        return Maybe.create((MaybeOnSubscribe)BeaconProximityAPI$$Lambda$3.lambdaFactory$(getForObservedResponse));
    }

    static /* synthetic */ void lambda$null$0(GetForObservedResponse getForObservedResponse, MaybeEmitter subscriber) throws Exception {
        if (getForObservedResponse.beacons != null && getForObservedResponse.beacons.size() > 0 && null != getForObservedResponse.beacons.get((int)0).attachments) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode((String)getForObservedResponse.beacons.get((int)0).attachments.get((int)0).data, (int)0));
                ObjectInputStream objectIn = new ObjectInputStream(byteArrayInputStream);
                String[] payload = (String[])objectIn.readObject();
                subscriber.onSuccess((Object)payload);
            }
            catch (InvalidClassException | ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Exception while fetching attachments (corruption)", (Throwable)e);
                subscriber.onError((Throwable)new CorruptAttachmentException());
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Exception while fetching attachments", (Throwable)e);
                subscriber.onError((Throwable)e);
            }
        } else {
            subscriber.onComplete();
        }
    }

    private static interface GoogleProximityApiInterface {
        @POST
        public Single<GetForObservedResponse> getForObserved(@Url String var1, @Body GetForObservedRequest var2);

        @GET(value="namespaces")
        public Single<ListNamespacesResponse> listNamespaces(@Header(value="Authorization") String var1);

        @POST
        public Single<Beacon> registerBeacon(@Url String var1, @Body Beacon var2, @Header(value="Authorization") String var3);

        @POST
        public Completable activateBeacon(@Url String var1, @Header(value="Authorization") String var2);

        @GET(value="beacons/{beaconName}")
        public Single<Beacon> getBeacon(@Path(value="beaconName") String var1, @Header(value="Authorization") String var2);

        @POST
        public Single<BatchDeleteResponse> batchDeleteAttachments(@Url String var1, @Header(value="Authorization") String var2);

        @POST(value="beacons/{beaconName}/attachments")
        public Single<AttachmentInfo> createAttachment(@Body AttachmentInfo var1, @Path(value="beaconName") String var2, @Header(value="Authorization") String var3);
    }

    public static class CorruptAttachmentException
    extends Exception {
    }
}

