/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.Nullable;
import android.support.test.espresso.IdlingResource;
import com.f2prateek.rx.preferences2.Preference;
import com.f2prateek.rx.preferences2.RxSharedPreferences;
import com.google.common.base.Strings;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper;
import com.ndipatri.iot.googleproximity.container.ObjectGraph;
import com.ndipatri.iot.googleproximity.utils.BeaconScanHelper;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import javax.inject.Inject;
import org.altbeacon.beacon.Beacon;

public class GoogleProximity {
    private ObjectGraph graph;
    private RxSharedPreferences sharedPreferences;
    private static GoogleProximityIdlingResource idlingResource = new GoogleProximityIdlingResource();
    @Inject
    BeaconProximityHelper beaconProximityHelper;
    @Inject
    BeaconScanHelper beaconScanHelper;
    private static GoogleProximity instance = null;

    public static void initialize(Context context, boolean trustAllConnections) {
        instance = new GoogleProximity(context, trustAllConnections);
    }

    public GoogleProximity(Context context, boolean trustAllConnections) {
        this.sharedPreferences = RxSharedPreferences.create((SharedPreferences)PreferenceManager.getDefaultSharedPreferences((Context)context));
        this.graph = ObjectGraph.Initializer.init(context, trustAllConnections, idlingResource);
        this.graph.inject(this);
    }

    public ObjectGraph getGraph() {
        return this.graph;
    }

    public static GoogleProximity getInstance() {
        return instance;
    }

    public void setGoogleAccountForOAuth(String googleAccount) {
        this.getGoogleAccountForOAuth().set((Object)googleAccount);
    }

    public void clearGoogleAccountForOAuth() {
        this.setGoogleAccountForOAuth(null);
    }

    public Preference<String> getGoogleAccountForOAuth() {
        return this.sharedPreferences.getString("GOOGLE_ACCOUNT_FOR_OAUTH", null);
    }

    public boolean hasGoogleAccountForOAuth() {
        return !Strings.isNullOrEmpty((String)((String)this.getGoogleAccountForOAuth().get()));
    }

    public Maybe<String[]> retrieveAttachment(Beacon beacon) {
        return this.retrieveAttachment(this.beaconScanHelper.getAdvertiseId(beacon));
    }

    public Maybe<String[]> retrieveAttachment(byte[] advertiseId) {
        return this.beaconProximityHelper.retrieveAttachment(advertiseId);
    }

    public Completable updateBeacon(Beacon beacon, String[] attachment) {
        return this.updateBeacon(this.beaconScanHelper.getAdvertiseId(beacon), attachment);
    }

    public Completable updateBeacon(byte[] advertiseId, String[] attachment) {
        return this.beaconProximityHelper.createAttachment(advertiseId, attachment);
    }

    public void redirectToAuthenticationActivityIfNecessary(Context activity) {
        this.beaconProximityHelper.redirectToAuthenticationActivityIfNecessary(activity);
    }

    public Single<String> getOAuthToken(String selectedGoogleAccount) {
        return this.beaconProximityHelper.getOAuthToken(selectedGoogleAccount);
    }

    public Observable<Beacon> scanForNearbyBeacon(String beaconNamespaceId) {
        return this.beaconScanHelper.scanForNearbyBeacon(beaconNamespaceId);
    }

    public Observable<Beacon> scanForNearbyBeacon(String beaconNamespaceId, int timeoutSeconds) {
        return this.beaconScanHelper.scanForNearbyBeacon(beaconNamespaceId, timeoutSeconds);
    }

    public void stopBeaconScanning() {
        this.beaconScanHelper.stopBeaconScanning();
    }

    public IdlingResource getIdlingResource() {
        return idlingResource;
    }

    public static class GoogleProximityIdlingResource
    implements IdlingResource {
        @Nullable
        private volatile IdlingResource.ResourceCallback resourceCallback;
        private boolean isIdle = true;

        public String getName() {
            return this.getClass().getName();
        }

        public boolean isIdleNow() {
            return this.isIdle;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
            this.resourceCallback = resourceCallback;
        }

        public synchronized void updateIdleState(boolean isIdle) {
            this.isIdle = isIdle;
            if (isIdle && null != this.resourceCallback) {
                this.resourceCallback.onTransitionToIdle();
            }
        }
    }
}

