/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.models.api;

import android.util.Base64;
import com.ndipatri.iot.googleproximity.models.api.AdvertisedId;
import com.ndipatri.iot.googleproximity.utils.ByteUtils;

public class Beacon {
    public static final String STATUS_NOT_FOUND = "NOT_FOUND";
    public static final String STATUS_UNREGISTERED = "UNREGISTERED";
    public static final String STATUS_ACTIVE = "ACTIVE";
    public static final String STATUS_DECOMMISSIONED = "DECOMMISSIONED";
    public static final String STATUS_INACTIVE = "INACTIVE";
    public AdvertisedId advertisedId;
    public String status;
    public String placeId;

    public Beacon(byte[] advertiseId) {
        this("EDDYSTONE", advertiseId, STATUS_ACTIVE);
    }

    public Beacon(String type, byte[] rawId, String status) {
        this.advertisedId = new AdvertisedId(type, rawId);
        this.status = status;
        this.placeId = null;
    }

    public String getBeaconName() {
        byte[] rawId = Base64.decode((String)this.advertisedId.id, (int)0);
        String hexEncodedId = ByteUtils.convertBytesToHex(rawId);
        return "3!" + hexEncodedId;
    }
}

