/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.activities;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.Toast;
import com.cantrowitz.rxbroadcast.RxBroadcast;
import com.ndipatri.iot.googleproximity.activities.RequirementsActivity$$Lambda$1;
import com.ndipatri.iot.googleproximity.fragments.EnableBluetoothDialogFragment;
import com.ndipatri.iot.googleproximity.fragments.GrantFineLocationAccessDialogFragment;
import com.ndipatri.iot.googleproximity.utils.BluetoothHelper;
import io.reactivex.disposables.Disposable;

public class RequirementsActivity
extends AppCompatActivity {
    private static final String TAG = RequirementsActivity.class.getSimpleName();
    protected EnableBluetoothDialogFragment enableBluetoothDialogFragment;
    protected GrantFineLocationAccessDialogFragment grantFineLocationAccessDialogFragment;
    private Disposable bluetoothStateChangeDisposable;

    protected void onResume() {
        super.onResume();
        this.beginUserPermissionCheck();
    }

    protected void onPause() {
        super.onPause();
        if (null != this.bluetoothStateChangeDisposable) {
            this.bluetoothStateChangeDisposable.dispose();
        }
    }

    protected BluetoothHelper getBluetoothHelper() {
        return new BluetoothHelper();
    }

    private void beginUserPermissionCheck() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                this.grantFineLocationAccessDialogFragment = new GrantFineLocationAccessDialogFragment();
                this.grantFineLocationAccessDialogFragment.show(this.getSupportFragmentManager().beginTransaction(), "grant location access dialog");
            } else {
                this.continueWithUserPermissionCheck();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch ((short)requestCode) {
            case 444: {
                if (grantResults[0] == 0) {
                    Log.d((String)TAG, (String)"fine location permission granted");
                    this.continueWithUserPermissionCheck();
                } else {
                    Toast.makeText((Context)this, (CharSequence)"This application cannot run without Fine Location Access!", (int)0).show();
                    this.failedToFulfillRequirements();
                }
                return;
            }
        }
    }

    private void continueWithUserPermissionCheck() {
        if (!this.getBluetoothHelper().isBluetoothSupported()) {
            Toast.makeText((Context)this, (CharSequence)"This application cannot run without Bluetooth support!", (int)0).show();
            this.failedToFulfillRequirements();
        } else if (!this.getBluetoothHelper().isBluetoothEnabled()) {
            this.enableBluetoothDialogFragment = new EnableBluetoothDialogFragment();
            this.enableBluetoothDialogFragment.show(this.getSupportFragmentManager().beginTransaction(), "enable bluetooth dialog");
        } else {
            this.successfullyFulfilledRequirements();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case -1: {
                this.enableBluetoothDialogFragment = null;
                if (resultCode == -1) {
                    this.successfullyFulfilledRequirements();
                    break;
                }
                Toast.makeText((Context)this, (CharSequence)"This application cannot run without Bluetooth enabled!", (int)0).show();
                this.failedToFulfillRequirements();
            }
        }
    }

    private Disposable registerForBluetoothStateChangeBroadcast() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
        return RxBroadcast.fromBroadcast((Context)this, (IntentFilter)filter).subscribe(RequirementsActivity$$Lambda$1.lambdaFactory$(this));
    }

    protected void failedToFulfillRequirements() {
        this.finish();
    }

    protected void successfullyFulfilledRequirements() {
        this.bluetoothStateChangeDisposable = this.registerForBluetoothStateChangeBroadcast();
    }

    /* synthetic */ void lambda$registerForBluetoothStateChangeBroadcast$0(Intent intent) throws Exception {
        if (null != this.enableBluetoothDialogFragment) {
            this.beginUserPermissionCheck();
        }
    }
}

