/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity;

import android.content.Context;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.jakewharton.retrofit2.adapter.rxjava2.HttpException;
import com.ndipatri.iot.googleproximity.BeaconProximityAPI;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$1;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$10;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$11;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$12;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$13;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$14;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$15;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$16;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$17;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$18;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$19;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$2;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$3;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$4;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$5;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$6;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$7;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$8;
import com.ndipatri.iot.googleproximity.BeaconProximityHelper$$Lambda$9;
import com.ndipatri.iot.googleproximity.GoogleProximity;
import com.ndipatri.iot.googleproximity.activities.AuthenticationActivity;
import com.ndipatri.iot.googleproximity.models.api.AttachmentInfo;
import com.ndipatri.iot.googleproximity.models.api.BatchDeleteResponse;
import com.ndipatri.iot.googleproximity.models.api.Beacon;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.joda.time.DateTime;

public class BeaconProximityHelper {
    private static final String TAG = BeaconProximityHelper.class.getSimpleName();
    private static final int PROXIMITY_API_CALL_TIMEOUT_MILLIS = 20000;
    private static final String OAUTH_SCOPE_PROXIMITY = "oauth2:https://www.googleapis.com/auth/userlocation.beacon.registry";
    private Single<String> namespaceSingle;
    private Context context;
    private final BeaconProximityAPI beaconProximityAPI;
    private AttachmentCache attachmentCache = new AttachmentCache();

    public BeaconProximityHelper(BeaconProximityAPI beaconProximityAPI, Context context) {
        this.beaconProximityAPI = beaconProximityAPI;
        this.context = context;
        this.namespaceSingle = this.getOAuthToken().flatMap(BeaconProximityHelper$$Lambda$1.lambdaFactory$(beaconProximityAPI)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).cache();
    }

    public void redirectToAuthenticationActivityIfNecessary(Context activity) {
        if (!GoogleProximity.getInstance().hasGoogleAccountForOAuth()) {
            Intent intent = new Intent(this.context, AuthenticationActivity.class);
            activity.startActivity(intent);
        }
    }

    public Maybe<String[]> retrieveAttachment(byte[] advertiseId) {
        Beacon apiBeacon = new Beacon(advertiseId);
        String[] cachedAttachment = this.attachmentCache.getAttachment(apiBeacon);
        if (null != cachedAttachment) {
            Log.d((String)TAG, (String)"Using cached attachment data.");
            return Maybe.just((Object)cachedAttachment);
        }
        return this.beaconProximityAPI.getBeaconAttachment(apiBeacon.advertisedId).flatMap(BeaconProximityHelper$$Lambda$2.lambdaFactory$(this, apiBeacon)).timeout(20000L, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Completable createAttachment(byte[] advertiseId, String[] attachment) {
        Beacon apiBeacon = new Beacon(advertiseId);
        return this.initializeProximityAPIForBeacon(apiBeacon).andThen(this.getOAuthToken()).flatMap(BeaconProximityHelper$$Lambda$3.lambdaFactory$(this, apiBeacon)).flatMap(BeaconProximityHelper$$Lambda$4.lambdaFactory$(this)).zipWith(this.renderAttachmentInfo(attachment), BeaconProximityHelper$$Lambda$5.lambdaFactory$(this, apiBeacon)).flatMap(BeaconProximityHelper$$Lambda$6.lambdaFactory$()).flatMapCompletable(BeaconProximityHelper$$Lambda$7.lambdaFactory$(this, advertiseId, apiBeacon, attachment)).timeout(20000L, TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Single<String> getOAuthToken(String _selectedGoogleAccount) {
        return Single.create((SingleOnSubscribe)BeaconProximityHelper$$Lambda$8.lambdaFactory$(this, _selectedGoogleAccount)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Single<String> getOAuthToken() {
        return this.getOAuthToken(null);
    }

    private Completable registerAndActivateBeacon(Beacon apiBeacon) {
        Log.d((String)TAG, (String)"New beacon found.  Registering and activating...");
        return this.getOAuthToken().flatMap(BeaconProximityHelper$$Lambda$9.lambdaFactory$(this, apiBeacon)).flatMap(BeaconProximityHelper$$Lambda$10.lambdaFactory$(this)).flatMapCompletable(BeaconProximityHelper$$Lambda$11.lambdaFactory$(this, apiBeacon)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Single<AttachmentInfo> renderAttachmentInfo(String[] attachment) {
        return this.namespaceSingle.flatMap(BeaconProximityHelper$$Lambda$12.lambdaFactory$(attachment)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private Completable initializeProximityAPIForBeacon(Beacon apiBeacon) {
        return this.getOAuthToken().flatMap(BeaconProximityHelper$$Lambda$13.lambdaFactory$(this, apiBeacon)).flatMapCompletable(BeaconProximityHelper$$Lambda$14.lambdaFactory$(this, apiBeacon)).onErrorResumeNext(BeaconProximityHelper$$Lambda$15.lambdaFactory$(this, apiBeacon)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    /* synthetic */ CompletableSource lambda$initializeProximityAPIForBeacon$18(Beacon apiBeacon, Throwable throwable) throws Exception {
        if (((HttpException)throwable).code() == 404) {
            return this.registerAndActivateBeacon(apiBeacon);
        }
        return Completable.error((Throwable)throwable);
    }

    /* synthetic */ CompletableSource lambda$initializeProximityAPIForBeacon$17(Beacon apiBeacon, Beacon retrievedBeacon) throws Exception {
        if (retrievedBeacon.status.equals("INACTIVE")) {
            return this.getOAuthToken().flatMapCompletable(BeaconProximityHelper$$Lambda$16.lambdaFactory$(this, apiBeacon));
        }
        if (retrievedBeacon.status.equals("UNREGISTERED") || retrievedBeacon.status.equals("NOT_FOUND")) {
            return this.registerAndActivateBeacon(apiBeacon);
        }
        return Completable.complete();
    }

    /* synthetic */ CompletableSource lambda$null$16(Beacon apiBeacon, String googleAccountToken) throws Exception {
        return this.beaconProximityAPI.activateBeacon(apiBeacon.getBeaconName(), googleAccountToken);
    }

    /* synthetic */ SingleSource lambda$initializeProximityAPIForBeacon$15(Beacon apiBeacon, String googleAccountToken) throws Exception {
        return this.beaconProximityAPI.getBeacon(apiBeacon.getBeaconName(), googleAccountToken);
    }

    static /* synthetic */ SingleSource lambda$renderAttachmentInfo$14(String[] attachment, String namespace) throws Exception {
        return Single.create((SingleOnSubscribe)BeaconProximityHelper$$Lambda$17.lambdaFactory$(attachment, namespace));
    }

    static /* synthetic */ void lambda$null$13(String[] attachment, String namespace, SingleEmitter subscriber) throws Exception {
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream((OutputStream)byteArrayOutputStream);
            objectOut.writeObject(attachment);
            attachmentInfo.namespacedType = String.format("%s/%s", namespace, "string");
            byte[] beaconAttachmentBytes = byteArrayOutputStream.toByteArray();
            attachmentInfo.data = Base64.encodeToString((byte[])beaconAttachmentBytes, (int)2);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Unable to serialize BeaconAttachment.", (Throwable)e);
            subscriber.onError((Throwable)e);
        }
        Log.d((String)TAG, (String)("Rendered beacon attachment '" + attachmentInfo + "'."));
        subscriber.onSuccess((Object)attachmentInfo);
    }

    /* synthetic */ CompletableSource lambda$registerAndActivateBeacon$12(Beacon apiBeacon, String googleAccountToken) throws Exception {
        return this.beaconProximityAPI.activateBeacon(apiBeacon.getBeaconName(), googleAccountToken);
    }

    /* synthetic */ SingleSource lambda$registerAndActivateBeacon$11(Beacon beacon) throws Exception {
        return this.getOAuthToken();
    }

    /* synthetic */ SingleSource lambda$registerAndActivateBeacon$10(Beacon apiBeacon, String googleAccountToken) throws Exception {
        return this.beaconProximityAPI.registerBeacon(apiBeacon, googleAccountToken);
    }

    /* synthetic */ void lambda$getOAuthToken$9(String _selectedGoogleAccount, SingleEmitter subscriber) throws Exception {
        String selectedGoogleAccount = _selectedGoogleAccount;
        if (null == selectedGoogleAccount) {
            selectedGoogleAccount = (String)GoogleProximity.getInstance().getGoogleAccountForOAuth().get();
        }
        String oauthToken = null;
        try {
            Log.d((String)TAG, (String)("Retrieving Google OAuth token for Account '" + selectedGoogleAccount + "'..."));
            oauthToken = GoogleAuthUtil.getToken((Context)this.context, (String)selectedGoogleAccount, (String)OAUTH_SCOPE_PROXIMITY);
            if (null == oauthToken) {
                Log.e((String)TAG, (String)"Retrieved null OAuth token.");
                subscriber.onError((Throwable)new InvalidParameterException());
            } else {
                Log.e((String)TAG, (String)("Retrieved OAuth token '" + oauthToken + "'."));
                subscriber.onSuccess((Object)oauthToken);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception retrieving OAuth token.", (Throwable)ex);
            subscriber.onError((Throwable)ex);
        }
    }

    /* synthetic */ CompletableSource lambda$createAttachment$8(byte[] advertiseId, Beacon apiBeacon, String[] attachment, AttachmentInfo attachmentInfo) throws Exception {
        return BeaconProximityHelper$$Lambda$18.lambdaFactory$(this, advertiseId, apiBeacon, attachment);
    }

    /* synthetic */ void lambda$null$7(byte[] advertiseId, Beacon apiBeacon, String[] attachment, CompletableObserver subscriber) {
        Log.d((String)TAG, (String)("Updated Beacon '" + advertiseId + "'"));
        this.attachmentCache.cacheAttachment(apiBeacon, attachment);
        subscriber.onComplete();
    }

    static /* synthetic */ SingleSource lambda$createAttachment$6(Single attachmentInfoObservable) throws Exception {
        return attachmentInfoObservable;
    }

    /* synthetic */ Single lambda$createAttachment$5(Beacon apiBeacon, String googleAccountToken, AttachmentInfo attachmentInfo) throws Exception {
        return this.beaconProximityAPI.createAttachment(attachmentInfo, apiBeacon.getBeaconName(), googleAccountToken);
    }

    /* synthetic */ SingleSource lambda$createAttachment$4(BatchDeleteResponse batchDeleteResponse) throws Exception {
        return this.getOAuthToken();
    }

    /* synthetic */ SingleSource lambda$createAttachment$3(Beacon apiBeacon, String googleAccountToken) throws Exception {
        return this.beaconProximityAPI.batchDeleteAttachments(apiBeacon.getBeaconName(), googleAccountToken);
    }

    /* synthetic */ MaybeSource lambda$retrieveAttachment$2(Beacon apiBeacon, String[] attachment) throws Exception {
        return Maybe.create((MaybeOnSubscribe)BeaconProximityHelper$$Lambda$19.lambdaFactory$(this, apiBeacon, attachment));
    }

    /* synthetic */ void lambda$null$1(Beacon apiBeacon, String[] attachment, MaybeEmitter subscriber) throws Exception {
        this.attachmentCache.cacheAttachment(apiBeacon, attachment);
        subscriber.onSuccess((Object)attachment);
    }

    static /* synthetic */ SingleSource lambda$new$0(BeaconProximityAPI beaconProximityAPI, String googleAccountToken) throws Exception {
        return beaconProximityAPI.getNamespace(googleAccountToken);
    }

    private class AttachmentCache {
        protected long attachmentLifeMillis = 1800000L;
        private Map<String, TimedAttachment> attachmentCache = new HashMap<String, TimedAttachment>();

        private AttachmentCache() {
        }

        public void cacheAttachment(Beacon apiBeacon, String[] attachment) {
            this.attachmentCache.put(this.generateKey(apiBeacon), new TimedAttachment(attachment));
        }

        public String[] getAttachment(Beacon apiBeacon) {
            String beaconKey = this.generateKey(apiBeacon);
            String[] cachedAttachment = null;
            TimedAttachment timedAttachment = this.attachmentCache.get(beaconKey);
            if (null != timedAttachment) {
                if (DateTime.now().getMillis() - timedAttachment.timestamp < this.attachmentLifeMillis) {
                    cachedAttachment = timedAttachment.attachment;
                } else {
                    this.attachmentCache.remove(beaconKey);
                }
            }
            return cachedAttachment;
        }

        private String generateKey(Beacon apiBeacon) {
            return apiBeacon.getBeaconName();
        }

        private class TimedAttachment {
            String[] attachment;
            Long timestamp;

            public TimedAttachment(String[] attachment) {
                this.attachment = attachment;
                this.timestamp = DateTime.now().getMillis();
            }
        }
    }
}

