/*
 * Decompiled with CFR 0.152.
 */
package com.ndipatri.iot.googleproximity.utils;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.test.espresso.IdlingResource;
import android.util.Log;
import com.google.common.primitives.Bytes;
import com.ndipatri.iot.googleproximity.utils.BeaconScanHelper$$Lambda$1;
import com.ndipatri.iot.googleproximity.utils.BeaconScanHelper$$Lambda$2;
import com.ndipatri.iot.googleproximity.utils.BeaconScanHelper$$Lambda$3;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.MonitorNotifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class BeaconScanHelper {
    private static final String TAG = BeaconScanHelper.class.getSimpleName();
    private boolean isConnectedToBeaconService = false;
    private boolean isScanning = false;
    private boolean isInitialized = false;
    private BeaconManager beaconManager;
    private Region scanRegion;
    private BeaconScanIdlingResource idlingResource;
    private Context context;
    private Subject<Beacon> scanForRegionSubject;
    private BeaconConsumer beaconConsumer = new BeaconConsumer(){

        public void onBeaconServiceConnect() {
            Log.d((String)TAG, (String)"onBeaconServiceConnected(): Connected!");
            BeaconScanHelper.this.isConnectedToBeaconService = true;
            if (BeaconScanHelper.this.isScanning && BeaconScanHelper.this.beaconManager.getMonitoringNotifiers().isEmpty()) {
                BeaconScanHelper.this.startBeaconScanning();
            }
        }

        public Context getApplicationContext() {
            return BeaconScanHelper.this.context;
        }

        public void unbindService(ServiceConnection serviceConnection) {
            BeaconScanHelper.this.context.unbindService(serviceConnection);
        }

        public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
            return BeaconScanHelper.this.context.bindService(intent, serviceConnection, i);
        }
    };
    private MonitorNotifier monitorNotifier = new MonitorNotifier(){

        public void didEnterRegion(Region region) {
            this.regionEntered(region);
        }

        public void didExitRegion(Region region) {
            Log.d((String)TAG, (String)("Region exited= '" + region + "'."));
            this.regionExited(region);
        }

        public void didDetermineStateForRegion(int regionState, Region region) {
            if (regionState == 1) {
                this.regionEntered(region);
            } else if (regionState == 0) {
                this.regionExited(region);
            }
        }

        protected void regionEntered(Region region) {
            try {
                BeaconScanHelper.this.beaconManager.addRangeNotifier(BeaconScanHelper.this.rangeNotifier);
                BeaconScanHelper.this.beaconManager.startRangingBeaconsInRegion(region);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Unable to start ranging.", (Throwable)e);
            }
        }

        protected void regionExited(Region region) {
            try {
                BeaconScanHelper.this.beaconManager.stopRangingBeaconsInRegion(region);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Unable to stop ranging.", (Throwable)e);
            }
        }
    };
    private RangeNotifier rangeNotifier = BeaconScanHelper$$Lambda$1.lambdaFactory$(this);

    public BeaconScanHelper(Context context) {
        this.context = context;
    }

    public IdlingResource getIdlingResource() {
        if (null == this.idlingResource) {
            this.idlingResource = new BeaconScanIdlingResource();
        }
        return this.idlingResource;
    }

    public Observable<Beacon> scanForNearbyBeacon(String beaconNamespaceId) {
        return this.scanForNearbyBeacon(beaconNamespaceId, -1);
    }

    public Observable<Beacon> scanForNearbyBeacon(String beaconNamespaceId, int timeoutSeconds) {
        Log.d((String)TAG, (String)"Starting AltBeacon discovery...");
        this.scanForRegionSubject = PublishSubject.create();
        if (!this.isScanning) {
            if (!this.isInitialized) {
                this.initialize(beaconNamespaceId);
                this.isInitialized = true;
            }
            if (this.isConnectedToBeaconService) {
                this.startBeaconScanning();
            }
            this.isScanning = true;
            this.updateIdlingResource();
        }
        Observable observable = this.scanForRegionSubject.doOnError(BeaconScanHelper$$Lambda$2.lambdaFactory$(this));
        if (timeoutSeconds > 0) {
            observable = observable.timeout((long)timeoutSeconds, TimeUnit.SECONDS, BeaconScanHelper$$Lambda$3.lambdaFactory$(this));
        }
        return observable.subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public void stopBeaconScanning() {
        Log.d((String)TAG, (String)"Stopping AltBeacon discovery...");
        if (this.isScanning) {
            this.beaconManager.removeAllRangeNotifiers();
            this.beaconManager.removeAllMonitorNotifiers();
            try {
                if (this.beaconManager.isBound(this.beaconConsumer)) {
                    this.beaconManager.stopMonitoringBeaconsInRegion(this.scanRegion);
                    this.beaconManager.stopRangingBeaconsInRegion(this.scanRegion);
                }
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"BLE scan service not yet bound.", (Throwable)e);
            }
            this.scanForRegionSubject.onComplete();
            this.isScanning = false;
            this.updateIdlingResource();
        }
    }

    private void initialize(String beaconNamespaceId) {
        Identifier nicksBeaconNamespaceId = Identifier.parse((String)beaconNamespaceId);
        this.scanRegion = new Region("nicks-beacon-region", nicksBeaconNamespaceId, null, null);
        BluetoothManager mBluetoothManager = (BluetoothManager)this.context.getSystemService("bluetooth");
        if (mBluetoothManager != null) {
            BluetoothAdapter mBluetoothAdapter = null;
            mBluetoothAdapter = mBluetoothManager.getAdapter();
            mBluetoothAdapter.enable();
            this.beaconManager = BeaconManager.getInstanceForApplication((Context)this.context);
            this.beaconManager.setForegroundScanPeriod(5000L);
            this.beaconManager.setBackgroundScanPeriod(5000L);
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19"));
            this.beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("x,s:0-1=feaa,m:2-2=20,d:3-3,d:4-5,d:6-7,d:8-11,d:12-15"));
            this.beaconManager.bind(this.beaconConsumer);
        }
    }

    private void startBeaconScanning() {
        Log.d((String)TAG, (String)"startBeaconScanning()");
        this.beaconManager.addMonitorNotifier(this.monitorNotifier);
        try {
            this.beaconManager.startMonitoringBeaconsInRegion(this.scanRegion);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"BLE scan service not yet bound.", (Throwable)e);
        }
    }

    private void updateIdlingResource() {
        if (null != this.idlingResource) {
            this.idlingResource.updateIdleState(!this.isScanning);
        }
    }

    public byte[] getAdvertiseId(Beacon beacon) {
        Identifier namespaceId = beacon.getId1();
        String namespaceIdHex = namespaceId.toHexString().substring(2);
        Identifier instanceId = beacon.getId2();
        String instanceIdHex = instanceId.toHexString().substring(2);
        byte[] namespaceBytes = new byte[]{};
        try {
            namespaceBytes = Hex.decodeHex((char[])namespaceIdHex.toCharArray());
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        byte[] instanceBytes = new byte[]{};
        try {
            instanceBytes = Hex.decodeHex((char[])instanceIdHex.toCharArray());
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        return Bytes.concat((byte[][])new byte[][]{namespaceBytes, instanceBytes});
    }

    /* synthetic */ void lambda$new$2(Collection nearbyBeacons, Region region) {
        Log.d((String)TAG, (String)("Ranging update.  Nearby Beacons='" + nearbyBeacons + "', Region='" + region + "'."));
        for (Beacon nearbyBeacon : nearbyBeacons) {
            this.scanForRegionSubject.onNext((Object)nearbyBeacon);
        }
    }

    /* synthetic */ void lambda$scanForNearbyBeacon$1(Observer observer) {
        Log.d((String)TAG, (String)"Timed out scanning for beacon.");
        this.scanForRegionSubject.onComplete();
    }

    /* synthetic */ void lambda$scanForNearbyBeacon$0(Throwable throwable) throws Exception {
        Log.e((String)TAG, (String)"Exception while scanning for beacons. Forcing stop.", (Throwable)throwable);
        this.stopBeaconScanning();
    }

    private class BeaconScanIdlingResource
    implements IdlingResource {
        @Nullable
        private volatile IdlingResource.ResourceCallback resourceCallback;
        private boolean isIdle;

        private BeaconScanIdlingResource() {
        }

        public String getName() {
            return this.getClass().getName();
        }

        public boolean isIdleNow() {
            return this.isIdle;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
            this.resourceCallback = resourceCallback;
        }

        public void updateIdleState(boolean isIdle) {
            this.isIdle = isIdle;
            if (isIdle && null != this.resourceCallback) {
                this.resourceCallback.onTransitionToIdle();
            }
        }
    }
}

