/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle.tasks.worker;

import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.FormattingOptions;
import com.ncorti.ktfmt.gradle.FormattingOptionsBean;
import com.ncorti.ktfmt.gradle.tasks.worker.KtfmtFormatResult;
import com.ncorti.ktfmt.gradle.util.KtfmtDiffer;
import com.ncorti.ktfmt.gradle.util.KtfmtLoggerKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtWorkAction$KtfmtWorkParameters;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "execute", "", "processSourceFile", "Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtFormatResult;", "parameter", "shouldSkipFile", "", "sourceFile", "Ljava/io/File;", "includedFiles", "", "writeResult", "result", "toFormattingOptions", "Lcom/facebook/ktfmt/format/FormattingOptions;", "Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;", "KtfmtWorkParameters", "plugin"})
@SourceDebugExtension(value={"SMAP\nKtfmtWorkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtfmtWorkAction.kt\ncom/ncorti/ktfmt/gradle/tasks/worker/KtfmtWorkAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public abstract class KtfmtWorkAction
implements WorkAction<KtfmtWorkParameters> {
    @NotNull
    private final Logger logger;

    public KtfmtWorkAction() {
        Logger logger = Logging.getLogger(KtfmtWorkAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(KtfmtWorkAction::class.java)");
        this.logger = logger;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    public final void execute() {
        WorkParameters workParameters = this.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)workParameters, (String)"parameters");
        KtfmtFormatResult result = this.processSourceFile((KtfmtWorkParameters)workParameters);
        this.writeResult(result);
    }

    private final KtfmtFormatResult processSourceFile(KtfmtWorkParameters parameter) {
        Object object;
        Object $this$processSourceFile_u24lambda_u240;
        File sourceFile = ((RegularFile)parameter.getSourceFile().get()).getAsFile();
        Boolean reformatFiles = (Boolean)parameter.getReformatFiles().get();
        Set includedFiles = (Set)parameter.getIncludedFiles().get();
        Object object2 = parameter.getFormattingOptions().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameter.formattingOptions.get()");
        FormattingOptions formattingOptions = this.toFormattingOptions((FormattingOptionsBean)object2);
        Intrinsics.checkNotNullExpressionValue((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullExpressionValue((Object)includedFiles, (String)"includedFiles");
        if (this.shouldSkipFile(sourceFile, includedFiles)) {
            KtfmtLoggerKt.i(this.logger, "Skipping format for " + sourceFile + " because it is not included");
            return new KtfmtFormatResult.KtfmtFormatSkipped(sourceFile);
        }
        KtfmtLoggerKt.d$default(this.logger, "Checking format for " + sourceFile, null, 2, null);
        Object object3 = this;
        try {
            KtfmtFormatResult.KtfmtFormatSuccess ktfmtFormatSuccess;
            $this$processSourceFile_u24lambda_u240 = object3;
            boolean bl = false;
            String originalContent = FilesKt.readText$default((File)sourceFile, null, (int)1, null);
            String formattedContent = Formatter.format((FormattingOptions)formattingOptions, (String)originalContent);
            if (Intrinsics.areEqual((Object)originalContent, (Object)formattedContent)) {
                KtfmtLoggerKt.i(((KtfmtWorkAction)$this$processSourceFile_u24lambda_u240).logger, "Valid formatting for: " + sourceFile);
                ktfmtFormatSuccess = new KtfmtFormatResult.KtfmtFormatSuccess(sourceFile, true);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)reformatFiles, (String)"reformatFiles");
                if (reformatFiles.booleanValue()) {
                    KtfmtLoggerKt.i(((KtfmtWorkAction)$this$processSourceFile_u24lambda_u240).logger, "Reformatting " + sourceFile);
                    Charset charset = Charset.defaultCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                    FilesKt.writeText((File)sourceFile, (String)formattedContent, (Charset)charset);
                    ktfmtFormatSuccess = new KtfmtFormatResult.KtfmtFormatSuccess(sourceFile, false);
                } else {
                    KtfmtLoggerKt.e$default(((KtfmtWorkAction)$this$processSourceFile_u24lambda_u240).logger, "Invalid formatting for: " + sourceFile, null, 2, null);
                    KtfmtDiffer.INSTANCE.printDiff(KtfmtDiffer.INSTANCE.computeDiff(sourceFile, formattedContent), ((KtfmtWorkAction)$this$processSourceFile_u24lambda_u240).logger);
                    ktfmtFormatSuccess = new KtfmtFormatResult.KtfmtFormatSuccess(sourceFile, false);
                }
            }
            $this$processSourceFile_u24lambda_u240 = Result.constructor-impl((Object)ktfmtFormatSuccess);
        }
        catch (Throwable bl) {
            $this$processSourceFile_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = $this$processSourceFile_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Object it = $this$processSourceFile_u24lambda_u240 = throwable;
            boolean bl = false;
            KtfmtLoggerKt.e$default(this.logger, "Failed to format file: " + sourceFile + " (reason = " + ((Throwable)it).getMessage() + ")", null, 2, null);
            KtfmtLoggerKt.d(this.logger, "Failed to format file: " + sourceFile, (Throwable)it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
        if (throwable2 == null) {
            object = object3;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            object = new KtfmtFormatResult.KtfmtFormatFailure(sourceFile);
        }
        return (KtfmtFormatResult)object;
    }

    private final void writeResult(KtfmtFormatResult result) {
        File resultDirectory = (File)((KtfmtWorkParameters)this.getParameters()).getResultDirectory().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)resultDirectory, (String)"resultDirectory");
        File resultFile = FilesKt.resolve((File)resultDirectory, (String)(UUID.randomUUID() + ".txt"));
        FilesKt.writeText$default((File)resultFile, (String)result.serialize(), null, (int)2, null);
    }

    private final boolean shouldSkipFile(File sourceFile, Set<? extends File> includedFiles) {
        if (includedFiles.isEmpty()) {
            return false;
        }
        return !includedFiles.contains(sourceFile.getCanonicalFile());
    }

    private final FormattingOptions toFormattingOptions(FormattingOptionsBean $this$toFormattingOptions) {
        int n = $this$toFormattingOptions.getMaxWidth();
        int n2 = $this$toFormattingOptions.getBlockIndent();
        int n3 = $this$toFormattingOptions.getContinuationIndent();
        boolean bl = $this$toFormattingOptions.getRemoveUnusedImports();
        boolean bl2 = $this$toFormattingOptions.getManageTrailingCommas();
        boolean bl3 = $this$toFormattingOptions.getDebuggingPrintOpsAfterFormatting();
        return new FormattingOptions(n, n2, n3, bl2, bl, bl3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/worker/KtfmtWorkAction$KtfmtWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "formattingOptions", "Lorg/gradle/api/provider/Property;", "Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;", "getFormattingOptions", "()Lorg/gradle/api/provider/Property;", "includedFiles", "Lorg/gradle/api/provider/SetProperty;", "Ljava/io/File;", "getIncludedFiles", "()Lorg/gradle/api/provider/SetProperty;", "reformatFiles", "", "getReformatFiles", "resultDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getResultDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "sourceFile", "Lorg/gradle/api/file/RegularFileProperty;", "getSourceFile", "()Lorg/gradle/api/file/RegularFileProperty;", "plugin"})
    public static interface KtfmtWorkParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getSourceFile();

        @NotNull
        public Property<FormattingOptionsBean> getFormattingOptions();

        @NotNull
        public Property<Boolean> getReformatFiles();

        @NotNull
        public SetProperty<File> getIncludedFiles();

        @NotNull
        public DirectoryProperty getResultDirectory();
    }
}

