/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle.tasks;

import com.ncorti.ktfmt.gradle.tasks.KtfmtBaseTask;
import com.ncorti.ktfmt.gradle.util.KtfmtLoggerKt;
import com.ncorti.ktfmt.gradle.util.KtfmtResultSummary;
import java.util.Collection;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0090D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/KtfmtFormatTask;", "Lcom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "reformatFiles", "", "getReformatFiles$plugin", "()Z", "handleResultSummary", "", "resultSummary", "Lcom/ncorti/ktfmt/gradle/util/KtfmtResultSummary;", "plugin"})
public abstract class KtfmtFormatTask
extends KtfmtBaseTask {
    private final boolean reformatFiles;

    @Inject
    public KtfmtFormatTask(@NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        super(layout);
        this.setGroup("formatting");
        this.reformatFiles = true;
    }

    @Override
    public boolean getReformatFiles$plugin() {
        return this.reformatFiles;
    }

    @Override
    protected void handleResultSummary(@NotNull KtfmtResultSummary resultSummary) {
        Intrinsics.checkNotNullParameter((Object)resultSummary, (String)"resultSummary");
        if (!((Collection)resultSummary.getFailedFiles()).isEmpty()) {
            throw new IllegalStateException(("Ktfmt failed to run with " + resultSummary.getFailedFiles().size() + " failures").toString());
        }
        if (!((Collection)resultSummary.getInvalidFormattedFiles()).isEmpty()) {
            int countInvalidFiles = resultSummary.getInvalidFormattedFiles().size();
            Logger logger = this.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            KtfmtLoggerKt.i(logger, "Successfully reformatted " + countInvalidFiles + " files with Ktfmt");
            return;
        }
        int countValidFiles = resultSummary.getValidFormattedFiles().size();
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        KtfmtLoggerKt.i(logger, "All files (" + countValidFiles + ") are already correctly formatted");
    }
}

