/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle.tasks;

import com.ncorti.ktfmt.gradle.tasks.KtfmtBaseTask;
import com.ncorti.ktfmt.gradle.util.KtfmtLoggerKt;
import com.ncorti.ktfmt.gradle.util.KtfmtResultSummary;
import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u000f\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0090D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/KtfmtCheckTask;", "Lcom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "reformatFiles", "", "getReformatFiles$plugin", "()Z", "handleResultSummary", "", "resultSummary", "Lcom/ncorti/ktfmt/gradle/util/KtfmtResultSummary;", "plugin"})
public abstract class KtfmtCheckTask
extends KtfmtBaseTask {
    @NotNull
    private final ProjectLayout layout;
    private final boolean reformatFiles;

    @Inject
    public KtfmtCheckTask(@NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        super(layout);
        this.layout = layout;
        this.setGroup("verification");
    }

    @Override
    public boolean getReformatFiles$plugin() {
        return this.reformatFiles;
    }

    @Override
    protected void handleResultSummary(@NotNull KtfmtResultSummary resultSummary) {
        Intrinsics.checkNotNullParameter((Object)resultSummary, (String)"resultSummary");
        if (!((Collection)resultSummary.getFailedFiles()).isEmpty()) {
            throw new IllegalStateException(("Ktfmt failed to run with " + resultSummary.getFailedFiles().size() + " failures").toString());
        }
        if (!((Collection)resultSummary.getInvalidFormattedFiles()).isEmpty()) {
            String fileList2 = CollectionsKt.joinToString$default((Iterable)resultSummary.getInvalidFormattedFiles(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<File, CharSequence>(this){
                final /* synthetic */ KtfmtCheckTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final CharSequence invoke(File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    File file = KtfmtCheckTask.access$getLayout$p(this.this$0).getProjectDirectory().getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"layout.projectDirectory.asFile");
                    String string = FilesKt.relativeTo((File)it, (File)file).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.relativeTo(layout.projectDirectory.asFile).path");
                    return string;
                }
            }), (int)30, null);
            int invalidFilesSize = resultSummary.getInvalidFormattedFiles().size();
            throw new IllegalStateException(("[ktfmt] Found " + invalidFilesSize + " files that are not properly formatted:\n" + fileList2).toString());
        }
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        KtfmtLoggerKt.i(logger, "Successfully checked " + resultSummary.getValidFormattedFiles().size() + " files with Ktfmt");
    }

    public static final /* synthetic */ ProjectLayout access$getLayout$p(KtfmtCheckTask $this) {
        return $this.layout;
    }
}

