/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle.tasks;

import com.ncorti.ktfmt.gradle.FormattingOptionsBean;
import com.ncorti.ktfmt.gradle.tasks.IncludedFilesParser;
import com.ncorti.ktfmt.gradle.tasks.KtfmtBaseTask;
import com.ncorti.ktfmt.gradle.tasks.worker.KtfmtFormatResult;
import com.ncorti.ktfmt.gradle.tasks.worker.KtfmtFormatResultKt;
import com.ncorti.ktfmt.gradle.tasks.worker.KtfmtWorkAction;
import com.ncorti.ktfmt.gradle.util.KtfmtLoggerKt;
import com.ncorti.ktfmt.gradle.util.KtfmtResultSummary;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0#H\u0002J\b\u0010$\u001a\u00020%H\u0017J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001fH$J\u0010\u0010)\u001a\u00020'2\u0006\u0010 \u001a\u00020!H\u0002J\r\u0010*\u001a\u00020'H\u0001\u00a2\u0006\u0002\b+J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u001fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask;", "Lorg/gradle/api/tasks/SourceTask;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "formattingOptionsBean", "Lorg/gradle/api/provider/Property;", "Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;", "getFormattingOptionsBean$plugin", "()Lorg/gradle/api/provider/Property;", "includeOnly", "", "getIncludeOnly", "ktfmtClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getKtfmtClasspath$plugin", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "output", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getOutput", "()Lorg/gradle/api/provider/Provider;", "reformatFiles", "", "getReformatFiles$plugin", "()Z", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor$plugin", "()Lorg/gradle/workers/WorkerExecutor;", "collectResults", "Lcom/ncorti/ktfmt/gradle/util/KtfmtResultSummary;", "tmpResultDirectory", "Ljava/io/File;", "getIncludedFiles", "", "getSource", "Lorg/gradle/api/file/FileTree;", "handleResultSummary", "", "resultSummary", "submitFilesToFormatterWorker", "taskAction", "taskAction$plugin", "writeResultsSummaryToOutput", "results", "plugin"})
@SourceDebugExtension(value={"SMAP\nKtfmtBaseTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtfmtBaseTask.kt\ncom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1#2:139\n1863#3,2:140\n*S KotlinDebug\n*F\n+ 1 KtfmtBaseTask.kt\ncom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask\n*L\n94#1:140,2\n*E\n"})
public abstract class KtfmtBaseTask
extends SourceTask {
    @NotNull
    private final ProjectLayout layout;
    @NotNull
    private final Provider<RegularFile> output;

    public KtfmtBaseTask(@NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.layout = layout;
        this.getIncludeOnly().convention((Object)"");
        Provider provider = this.layout.getBuildDirectory().file("ktfmt/" + this.getName() + "/output.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"layout.buildDirectory.fi\u2026${this.name}/output.txt\")");
        this.output = provider;
    }

    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getKtfmtClasspath$plugin();

    @Input
    @NotNull
    public abstract Property<FormattingOptionsBean> getFormattingOptionsBean$plugin();

    @Option(option="include-only", description="A comma separate list of relative file paths to include exclusively. If set the task will run the processing only on such files.")
    @Input
    @NotNull
    public abstract Property<String> getIncludeOnly();

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @IgnoreEmptyDirectories
    @SkipWhenEmpty
    @NotNull
    public FileTree getSource() {
        FileTree fileTree = super.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"super.getSource()");
        return fileTree;
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getOutput() {
        return this.output;
    }

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor$plugin();

    @Internal
    public abstract boolean getReformatFiles$plugin();

    protected abstract void handleResultSummary(@NotNull KtfmtResultSummary var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void taskAction$plugin() {
        File file;
        File file2 = this.getTemporaryDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"temporaryDir");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        File $this$taskAction_u24lambda_u240 = file = FilesKt.resolve((File)file2, (String)string);
        boolean bl = false;
        $this$taskAction_u24lambda_u240.mkdirs();
        File tmpResultDirectory = file;
        try {
            this.submitFilesToFormatterWorker(tmpResultDirectory);
            KtfmtResultSummary results2 = this.collectResults(tmpResultDirectory);
            this.handleResultSummary(results2);
            this.writeResultsSummaryToOutput(results2);
        }
        finally {
            FilesKt.deleteRecursively((File)tmpResultDirectory);
        }
    }

    private final void submitFilesToFormatterWorker(File tmpResultDirectory) {
        WorkQueue queue2 = this.getWorkerExecutor$plugin().processIsolation(arg_0 -> KtfmtBaseTask.submitFilesToFormatterWorker$lambda$1((Function1)new Function1<ProcessWorkerSpec, Unit>(this){
            final /* synthetic */ KtfmtBaseTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ProcessWorkerSpec it) {
                Object[] objectArray = new Object[]{this.this$0.getKtfmtClasspath$plugin()};
                it.getClasspath().from(objectArray);
            }
        }, arg_0));
        Set<File> includedFiles = this.getIncludedFiles();
        Iterable $this$forEach$iv = (Iterable)this.getSource();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            queue2.submit(KtfmtWorkAction.class, arg_0 -> KtfmtBaseTask.submitFilesToFormatterWorker$lambda$3$lambda$2((Function1)new Function1<KtfmtWorkAction.KtfmtWorkParameters, Unit>(file, this, includedFiles, tmpResultDirectory){
                final /* synthetic */ File $file;
                final /* synthetic */ KtfmtBaseTask this$0;
                final /* synthetic */ Set<File> $includedFiles;
                final /* synthetic */ File $tmpResultDirectory;
                {
                    this.$file = $file;
                    this.this$0 = $receiver;
                    this.$includedFiles = $includedFiles;
                    this.$tmpResultDirectory = $tmpResultDirectory;
                    super(1);
                }

                public final void invoke(KtfmtWorkAction.KtfmtWorkParameters it) {
                    it.getSourceFile().set(this.$file);
                    it.getFormattingOptions().set(this.this$0.getFormattingOptionsBean$plugin().get());
                    it.getIncludedFiles().set((Iterable)this.$includedFiles);
                    it.getResultDirectory().set(this.$tmpResultDirectory);
                    it.getReformatFiles().set((Object)this.this$0.getReformatFiles$plugin());
                }
            }, arg_0));
        }
        queue2.await();
    }

    private final Set<File> getIncludedFiles() {
        Object object = this.getIncludeOnly().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"includeOnly.get()");
        String string = (String)object;
        File file = this.layout.getProjectDirectory().getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"layout.projectDirectory.asFile");
        Set<File> includedFiles = IncludedFilesParser.INSTANCE.parse(string, file);
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        KtfmtLoggerKt.d$default(logger, "Preparing to format: includeOnly=" + this.getIncludeOnly().getOrNull() + ", includedFiles = " + includedFiles, null, 2, null);
        return includedFiles;
    }

    private final KtfmtResultSummary collectResults(File tmpResultDirectory) {
        Object[] objectArray = tmpResultDirectory.listFiles();
        if (objectArray == null) {
            objectArray = new File[]{};
        }
        Object[] formatResultFiles = objectArray;
        Sequence results2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])formatResultFiles), (Function1)collectResults.results.1.INSTANCE), (Function1)collectResults.results.2.INSTANCE);
        List<File> correctFiles2 = KtfmtFormatResultKt.files((Sequence<? extends KtfmtFormatResult>)SequencesKt.filter((Sequence)results2, (Function1)collectResults.correctFiles.1.INSTANCE));
        List<File> incorrectFiles2 = KtfmtFormatResultKt.files((Sequence<? extends KtfmtFormatResult>)SequencesKt.filter((Sequence)results2, (Function1)collectResults.incorrectFiles.1.INSTANCE));
        List<File> skippedFiles2 = KtfmtFormatResultKt.files((Sequence<? extends KtfmtFormatResult>)SequencesKt.filter((Sequence)results2, (Function1)collectResults.skippedFiles.1.INSTANCE));
        List<File> failedFiles2 = KtfmtFormatResultKt.files((Sequence<? extends KtfmtFormatResult>)SequencesKt.filter((Sequence)results2, (Function1)collectResults.failedFiles.1.INSTANCE));
        return new KtfmtResultSummary(correctFiles2, incorrectFiles2, skippedFiles2, failedFiles2);
    }

    private final void writeResultsSummaryToOutput(KtfmtResultSummary results2) {
        File file = ((RegularFile)this.output.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"output.get().asFile");
        FilesKt.writeText$default((File)file, (String)results2.prettyPrint(), null, (int)2, null);
    }

    private static final void submitFilesToFormatterWorker$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void submitFilesToFormatterWorker$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

