/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle.tasks;

import com.ncorti.ktfmt.gradle.tasks.KtfmtBaseTask;
import com.ncorti.ktfmt.gradle.tasks.KtfmtCheckTask;
import com.ncorti.ktfmt.gradle.tasks.worker.KtfmtCheckAction;
import com.ncorti.ktfmt.gradle.tasks.worker.Result;
import com.ncorti.ktfmt.gradle.util.KtfmtLoggerKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/KtfmtCheckTask;", "Lcom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/file/ProjectLayout;)V", "output", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getOutput", "()Lorg/gradle/api/provider/Provider;", "execute", "", "workQueue", "Lorg/gradle/workers/WorkQueue;", "plugin"})
@SourceDebugExtension(value={"SMAP\nKtfmtCheckTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtfmtCheckTask.kt\ncom/ncorti/ktfmt/gradle/tasks/KtfmtCheckTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n800#2,11:56\n800#2,20:67\n847#2,2:87\n*E\n*S KotlinDebug\n*F\n+ 1 KtfmtCheckTask.kt\ncom/ncorti/ktfmt/gradle/tasks/KtfmtCheckTask\n*L\n35#1,11:56\n42#1,20:67\n42#1,2:87\n*E\n"})
public abstract class KtfmtCheckTask
extends KtfmtBaseTask {
    @NotNull
    private final Provider<RegularFile> output;

    @Inject
    public KtfmtCheckTask(@NotNull WorkerExecutor workerExecutor, @NotNull ProjectLayout layout) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        super(workerExecutor, layout);
        Provider provider = layout.getBuildDirectory().file("ktfmt/" + this.getName() + "/output.txt");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"layout.buildDirectory.fi\u2026${this.name}/output.txt\")");
        this.output = provider;
        this.setGroup("verification");
    }

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getOutput() {
        return this.output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void execute(@NotNull WorkQueue workQueue2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)workQueue2, (String)"workQueue");
        List<Result> results = this.submitToQueue$plugin((FileCollection)this.getSource(), workQueue2, KtfmtCheckAction.class);
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        KtfmtLoggerKt.d(logger, "Check results: " + results);
        Iterable $this$filterIsInstance$iv = results;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof Result.Failure)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List failures = (List)destination$iv$iv;
        if (!((Collection)failures).isEmpty()) {
            throw new IllegalStateException(("Ktfmt failed to run with " + failures.size() + " failures").toString());
        }
        Iterable $this$filterIsInstance$iv2 = results;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Result.Success)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filterNot = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Result.Success it = (Result.Success)element$iv$iv;
            boolean bl = false;
            if (it.getCorrectlyFormatted()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List notFormattedFiles = (List)destination$iv$iv2;
        if (!((Collection)notFormattedFiles).isEmpty()) {
            String fileList2 = CollectionsKt.joinToString$default((Iterable)notFormattedFiles, (CharSequence)"\n", null, null, (int)0, null, (Function1)execute.fileList.1.INSTANCE, (int)30, null);
            throw new IllegalStateException(("[ktfmt] Found " + notFormattedFiles.size() + " files that are not properly formatted:\n" + fileList2).toString());
        }
        String message2 = "Successfully checked " + results.size() + " files with Ktfmt";
        Logger logger2 = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
        KtfmtLoggerKt.i(logger2, message2);
        File file = ((RegularFile)this.output.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"output.get().asFile");
        FilesKt.writeText$default((File)file, (String)message2, null, (int)2, null);
    }
}

