/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle;

import com.ncorti.ktfmt.gradle.KtfmtAndroidUtils;
import com.ncorti.ktfmt.gradle.KtfmtExtension;
import com.ncorti.ktfmt.gradle.KtfmtPluginUtils;
import com.ncorti.ktfmt.gradle.util.KtfmtLoggerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/ncorti/ktfmt/gradle/KtfmtPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "ktfmtExtension", "Lcom/ncorti/ktfmt/gradle/KtfmtExtension;", "topLevelCheck", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "topLevelFormat", "apply", "", "project", "applyKtfmt", "applyKtfmtToMultiplatformProject", "createTopLevelCheckTask", "createTopLevelFormatTask", "Companion", "plugin"})
public abstract class KtfmtPlugin
implements Plugin<Project> {
    private KtfmtExtension ktfmtExtension;
    private TaskProvider<Task> topLevelFormat;
    private TaskProvider<Task> topLevelCheck;
    @NotNull
    private static final List<String> defaultExcludes;
    @NotNull
    private static final Regex defaultExcludesRegex;
    @NotNull
    private static final List<String> defaultIncludes;
    @NotNull
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getExtensions().create("ktfmt", KtfmtExtension.class, new Object[]{project});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026ion::class.java, project)");
        this.ktfmtExtension = (KtfmtExtension)object;
        this.topLevelFormat = this.createTopLevelFormatTask(project);
        this.topLevelCheck = this.createTopLevelCheckTask(project);
        project.getPlugins().withId("kotlin", new Action(this, project){
            final /* synthetic */ KtfmtPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                KtfmtPlugin.access$applyKtfmt(this.this$0, this.$project);
            }
            {
                this.this$0 = ktfmtPlugin;
                this.$project = project;
            }
        });
        project.getPlugins().withId("kotlin-android", new Action(this, project){
            final /* synthetic */ KtfmtPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                if (this.$project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
                    Logger logger = this.$project.getLogger();
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
                    KtfmtLoggerKt.i(logger, "Skipping Android task creation, as KMP is applied");
                } else {
                    KtfmtAndroidUtils.applyKtfmtToAndroidProject$plugin$default(KtfmtAndroidUtils.INSTANCE, this.$project, KtfmtPlugin.access$getKtfmtExtension$p(this.this$0), KtfmtPlugin.access$getTopLevelFormat$p(this.this$0), KtfmtPlugin.access$getTopLevelCheck$p(this.this$0), false, 16, null);
                }
            }
            {
                this.this$0 = ktfmtPlugin;
                this.$project = project;
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.js", new Action(this, project){
            final /* synthetic */ KtfmtPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                KtfmtPlugin.access$applyKtfmt(this.this$0, this.$project);
            }
            {
                this.this$0 = ktfmtPlugin;
                this.$project = project;
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", new Action(this, project){
            final /* synthetic */ KtfmtPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                KtfmtPlugin.access$applyKtfmtToMultiplatformProject(this.this$0, this.$project);
            }
            {
                this.this$0 = ktfmtPlugin;
                this.$project = project;
            }
        });
    }

    private final void applyKtfmt(Project project) {
        KotlinProjectExtension extension = (KotlinProjectExtension)project.getExtensions().getByType(KotlinProjectExtension.class);
        extension.getSourceSets().all(new Action(this, project){
            final /* synthetic */ KtfmtPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(KotlinSourceSet it) {
                KotlinSourceSet kotlinSourceSet = it;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinSourceSet, (String)"it");
                String string = kotlinSourceSet.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                FileCollection fileCollection = it.getKotlin().getSourceDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"it.kotlin.sourceDirectories");
                KtfmtPluginUtils.INSTANCE.createTasksForSourceSet$plugin(this.$project, string, fileCollection, KtfmtPlugin.access$getKtfmtExtension$p(this.this$0), (TaskProvider<Task>)KtfmtPlugin.access$getTopLevelFormat$p(this.this$0), (TaskProvider<Task>)KtfmtPlugin.access$getTopLevelCheck$p(this.this$0));
            }
            {
                this.this$0 = ktfmtPlugin;
                this.$project = project;
            }
        });
    }

    private final void applyKtfmtToMultiplatformProject(Project project) {
        KotlinMultiplatformExtension extension = (KotlinMultiplatformExtension)project.getExtensions().getByType(KotlinMultiplatformExtension.class);
        extension.getSourceSets().all(new Action(this, project){
            final /* synthetic */ KtfmtPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(KotlinSourceSet it) {
                KotlinSourceSet kotlinSourceSet = it;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinSourceSet, (String)"it");
                String name = "kmp " + kotlinSourceSet.getName();
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (StringsKt.startsWith$default((String)string, (String)"android", (boolean)false, (int)2, null)) {
                    return;
                }
                FileCollection fileCollection = it.getKotlin().getSourceDirectories();
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"it.kotlin.sourceDirectories");
                KtfmtPluginUtils.INSTANCE.createTasksForSourceSet$plugin(this.$project, name, fileCollection, KtfmtPlugin.access$getKtfmtExtension$p(this.this$0), (TaskProvider<Task>)KtfmtPlugin.access$getTopLevelFormat$p(this.this$0), (TaskProvider<Task>)KtfmtPlugin.access$getTopLevelCheck$p(this.this$0));
            }
            {
                this.this$0 = ktfmtPlugin;
                this.$project = project;
            }
        });
        extension.getTargets().all(new Action(this, project){
            final /* synthetic */ KtfmtPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(KotlinTarget kotlinTarget) {
                if (kotlinTarget.getPlatformType() == KotlinPlatformType.androidJvm) {
                    KtfmtAndroidUtils.INSTANCE.applyKtfmtToAndroidProject$plugin(this.$project, KtfmtPlugin.access$getKtfmtExtension$p(this.this$0), (TaskProvider<Task>)KtfmtPlugin.access$getTopLevelFormat$p(this.this$0), (TaskProvider<Task>)KtfmtPlugin.access$getTopLevelCheck$p(this.this$0), true);
                }
            }
            {
                this.this$0 = ktfmtPlugin;
                this.$project = project;
            }
        });
    }

    private final TaskProvider<Task> createTopLevelFormatTask(Project project) {
        TaskProvider taskProvider = project.getTasks().register("ktfmtFormat", new Action(project){
            final /* synthetic */ Project $project;

            public final void execute(Task it) {
                Task task = it;
                Intrinsics.checkNotNullExpressionValue((Object)task, (String)"it");
                task.setGroup("formatting");
                it.setDescription("Run Ktfmt formatter for all source sets for project '" + this.$project.getName() + "'");
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(T\u2026project.name}'\"\n        }");
        return taskProvider;
    }

    private final TaskProvider<Task> createTopLevelCheckTask(Project project) {
        TaskProvider taskProvider = project.getTasks().register("ktfmtCheck", new Action(project){
            final /* synthetic */ Project $project;

            public final void execute(Task it) {
                Task task = it;
                Intrinsics.checkNotNullExpressionValue((Object)task, (String)"it");
                task.setGroup("verification");
                it.setDescription("Run Ktfmt validation for all source sets for project '" + this.$project.getName() + "'");
            }
            {
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(T\u2026project.name}'\"\n        }");
        return taskProvider;
    }

    static {
        Companion = new Companion(null);
        defaultExcludes = CollectionsKt.listOf((Object)"**/build/**");
        defaultExcludesRegex = new Regex("^(.*[\\\\/])?build([\\\\/].*)?$");
        defaultIncludes = CollectionsKt.listOf((Object[])new String[]{"**/*.kt", "**/*.kts"});
    }

    public static final /* synthetic */ void access$applyKtfmt(KtfmtPlugin $this, Project project) {
        $this.applyKtfmt(project);
    }

    public static final /* synthetic */ KtfmtExtension access$getKtfmtExtension$p(KtfmtPlugin $this) {
        KtfmtExtension ktfmtExtension = $this.ktfmtExtension;
        if (ktfmtExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ktfmtExtension");
        }
        return ktfmtExtension;
    }

    public static final /* synthetic */ void access$setKtfmtExtension$p(KtfmtPlugin $this, KtfmtExtension ktfmtExtension) {
        $this.ktfmtExtension = ktfmtExtension;
    }

    public static final /* synthetic */ TaskProvider access$getTopLevelFormat$p(KtfmtPlugin $this) {
        TaskProvider<Task> taskProvider = $this.topLevelFormat;
        if (taskProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topLevelFormat");
        }
        return taskProvider;
    }

    public static final /* synthetic */ void access$setTopLevelFormat$p(KtfmtPlugin $this, TaskProvider taskProvider) {
        $this.topLevelFormat = taskProvider;
    }

    public static final /* synthetic */ TaskProvider access$getTopLevelCheck$p(KtfmtPlugin $this) {
        TaskProvider<Task> taskProvider = $this.topLevelCheck;
        if (taskProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"topLevelCheck");
        }
        return taskProvider;
    }

    public static final /* synthetic */ void access$setTopLevelCheck$p(KtfmtPlugin $this, TaskProvider taskProvider) {
        $this.topLevelCheck = taskProvider;
    }

    public static final /* synthetic */ void access$applyKtfmtToMultiplatformProject(KtfmtPlugin $this, Project project) {
        $this.applyKtfmtToMultiplatformProject(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/ncorti/ktfmt/gradle/KtfmtPlugin$Companion;", "", "()V", "defaultExcludes", "", "", "getDefaultExcludes$plugin", "()Ljava/util/List;", "defaultExcludesRegex", "Lkotlin/text/Regex;", "getDefaultExcludesRegex$plugin", "()Lkotlin/text/Regex;", "defaultIncludes", "getDefaultIncludes$plugin", "plugin"})
    public static final class Companion {
        @NotNull
        public final List<String> getDefaultExcludes$plugin() {
            return defaultExcludes;
        }

        @NotNull
        public final Regex getDefaultExcludesRegex$plugin() {
            return defaultExcludesRegex;
        }

        @NotNull
        public final List<String> getDefaultIncludes$plugin() {
            return defaultIncludes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

