/*
 * Decompiled with CFR 0.152.
 */
package com.ncorti.ktfmt.gradle.tasks;

import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.FormattingOptions;
import com.facebook.ktfmt.format.ParseError;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import com.ncorti.ktfmt.gradle.FormattingOptionsBean;
import com.ncorti.ktfmt.gradle.KtfmtExtension;
import com.ncorti.ktfmt.gradle.tasks.KtfmtBaseTask;
import com.ncorti.ktfmt.gradle.tasks.KtfmtFailure;
import com.ncorti.ktfmt.gradle.tasks.KtfmtResult;
import com.ncorti.ktfmt.gradle.tasks.KtfmtSkipped;
import com.ncorti.ktfmt.gradle.tasks.KtfmtSuccess;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0012\u001a\u00020\u0013H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\u0017\u001a\u00020\u000fH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u001fR\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00048AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lcom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask;", "Lorg/gradle/api/tasks/SourceTask;", "()V", "bean", "Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;", "getBean$plugin", "()Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;", "setBean$plugin", "(Lcom/ncorti/ktfmt/gradle/FormattingOptionsBean;)V", "includeOnly", "Lorg/gradle/api/provider/Property;", "", "getIncludeOnly", "()Lorg/gradle/api/provider/Property;", "inputFiles", "Lorg/gradle/api/file/FileCollection;", "getInputFiles", "()Lorg/gradle/api/file/FileCollection;", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processFile", "Lcom/ncorti/ktfmt/gradle/tasks/KtfmtResult;", "input", "Ljava/io/File;", "processFile$plugin", "processFileCollection", "", "processFileCollection$plugin", "(Lorg/gradle/api/file/FileCollection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "taskAction", "taskAction$plugin", "plugin"})
@SourceDebugExtension(value={"SMAP\nKtfmtBaseTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtfmtBaseTask.kt\ncom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,115:1\n1549#2:116\n1620#2,2:117\n1622#2:121\n37#3,2:119\n*E\n*S KotlinDebug\n*F\n+ 1 KtfmtBaseTask.kt\ncom/ncorti/ktfmt/gradle/tasks/KtfmtBaseTask\n*L\n81#1:116\n81#1,2:117\n81#1:121\n84#1,2:119\n*E\n"})
public abstract class KtfmtBaseTask
extends SourceTask {
    @Nullable
    private FormattingOptionsBean bean;
    @NotNull
    private final Property<String> includeOnly;

    @Input
    @Optional
    @Nullable
    public final FormattingOptionsBean getBean$plugin() {
        return this.bean;
    }

    public final void setBean$plugin(@Nullable FormattingOptionsBean formattingOptionsBean) {
        this.bean = formattingOptionsBean;
    }

    @Option(option="include-only", description="A comma separate list of relative file paths to include exclusively. If set the task will run the processing only on such files.")
    @Input
    @NotNull
    public Property<String> getIncludeOnly() {
        return this.includeOnly;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @IgnoreEmptyDirectories
    @NotNull
    protected final FileCollection getInputFiles() {
        FileTree fileTree = super.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"super.getSource()");
        return (FileCollection)fileTree;
    }

    @TaskAction
    @VisibleForTesting
    public final void taskAction$plugin() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ KtfmtBaseTask this$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.execute((Continuation<? super Unit>)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = ktfmtBaseTask;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    protected abstract Object execute(@NotNull Continuation<? super Unit> var1);

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final KtfmtResult processFile$plugin(@NotNull File input) {
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (this.bean == null) {
            KtfmtBaseTask ktfmtBaseTask;
            object3 = this;
            try {
                ktfmtBaseTask = object3;
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                object2 = ((KtfmtExtension)project.getExtensions().getByType(KtfmtExtension.class)).toBean$plugin();
            }
            catch (UnknownDomainObjectException unknownDomainObjectException) {
                ktfmtBaseTask = object3;
                object2 = new FormattingOptionsBean(null, 0, 0, 0, false, false, 63, null);
            }
            ktfmtBaseTask.bean = object2;
        }
        String string = (String)this.getIncludeOnly().getOrNull();
        if (string != null) {
            object2 = string;
            if (object2.length() > 0) {
                void $this$mapTo$iv$iv;
                Object object4 = this.getIncludeOnly().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"includeOnly\n                    .get()");
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)((CharSequence)object4), (char[])new char[]{',', ':'}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl = false;
                    void var12_16 = it;
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)var12_16))).toString(), (char[])new char[]{File.separatorChar, '\\', '/'}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    Path path = Paths.get("", Arrays.copyOf(stringArray, stringArray.length));
                    object3.add(path);
                }
                Set includeOnlyPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                File file = project.getProjectDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
                Path relativePath = FilesKt.relativeTo((File)input, (File)file).toPath();
                if (!includeOnlyPaths.contains(relativePath)) {
                    return new KtfmtSkipped(input, "Not included inside --include-only");
                }
            }
        }
        try {
            String originCode = FilesKt.readText$default((File)input, null, (int)1, null);
            FormattingOptionsBean formattingOptionsBean = this.bean;
            Intrinsics.checkNotNull((Object)formattingOptionsBean);
            String formattedCode = Formatter.format((FormattingOptions)formattingOptionsBean.toFormattingOptions(), (String)originCode);
            boolean isCorrectlyFormatted = Intrinsics.areEqual((Object)originCode, (Object)formattedCode);
            object2 = new KtfmtSuccess(input, isCorrectlyFormatted, formattedCode);
        }
        catch (Throwable cause) {
            String string3;
            object = cause;
            if (object instanceof IOException) {
                string3 = "Unable to read file";
            } else if (object instanceof ParseError) {
                string3 = "Failed to parse file";
            } else if (object instanceof FormattingError) {
                ImmutableList immutableList = ((FormattingError)cause).diagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"cause.diagnostics()");
                string3 = CollectionsKt.joinToString$default((Iterable)((Iterable)immutableList), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<FormatterDiagnostic, CharSequence>(input){
                    final /* synthetic */ File $input;

                    @NotNull
                    public final CharSequence invoke(FormatterDiagnostic it) {
                        return this.$input + ":" + it;
                    }
                    {
                        this.$input = file;
                        super(1);
                    }
                }), (int)30, null);
            } else {
                string3 = "Generic error during file processing";
            }
            String message2 = string3;
            object2 = new KtfmtFailure(input, message2, cause);
        }
        return object2;
    }

    @Nullable
    public final Object processFileCollection$plugin(@NotNull FileCollection input, @NotNull Continuation<? super List<? extends KtfmtResult>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KtfmtResult>>, Object>(this, input, null){
            private /* synthetic */ Object L$0;
            int label;
            final /* synthetic */ KtfmtBaseTask this$0;
            final /* synthetic */ FileCollection $input;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        Iterable $this$map$iv = (Iterable)this.$input;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            File file = (File)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Deferred deferred = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KtfmtResult>, Object>((File)it, null, this, $this$coroutineScope){
                                int label;
                                final /* synthetic */ File $it;
                                final /* synthetic */ processFileCollection.2 this$0;
                                final /* synthetic */ CoroutineScope $this_coroutineScope$inlined;
                                {
                                    this.$it = file;
                                    this.this$0 = var3_3;
                                    this.$this_coroutineScope$inlined = coroutineScope;
                                    super(2, continuation);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            KtfmtBaseTask ktfmtBaseTask = this.this$0.this$0;
                                            File file = this.$it;
                                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                                            return ktfmtBaseTask.processFile$plugin(file);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super KtfmtResult>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            collection.add(deferred);
                        }
                        this.label = 1;
                        Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = ktfmtBaseTask;
                this.$input = fileCollection;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                Object object = var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public KtfmtBaseTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Property property = project.getObjects().property(String.class).convention((Object)"");
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property\u2026lass.java).convention(\"\")");
        this.includeOnly = property;
    }
}

