/*
 * Decompiled with CFR 0.152.
 */
package com.nbsp.materialfilepicker.ui;

import android.content.Intent;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.nbsp.materialfilepicker.R;
import com.nbsp.materialfilepicker.filter.FileFilter;
import com.nbsp.materialfilepicker.filter.PatternFilter;
import com.nbsp.materialfilepicker.ui.DirectoryFragment;
import com.nbsp.materialfilepicker.utils.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;

public class FilePickerActivity
extends AppCompatActivity
implements DirectoryFragment.FileClickListener {
    public static final String ARG_START_FILE = "arg_start_path";
    public static final String ARG_CURRENT_FILE = "arg_current_path";
    public static final String ARG_FILTER = "arg_filter";
    public static final String ARG_CLOSEABLE = "arg_closeable";
    public static final String ARG_TITLE = "arg_title";
    public static final String STATE_START_FILE = "state_start_path";
    private static final String STATE_CURRENT_FILE = "state_current_path";
    public static final String RESULT_FILE_PATH = "result_file_path";
    private static final int HANDLE_CLICK_DELAY = 150;
    private Toolbar mToolbar;
    private File mStart;
    private File mCurrent;
    private CharSequence mTitle;
    private Boolean mCloseable;
    private FileFilter mFilter;

    public FilePickerActivity() {
        this.mCurrent = this.mStart = Environment.getExternalStorageDirectory();
        this.mCloseable = true;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_file_picker);
        this.initArguments(savedInstanceState);
        this.initViews();
        this.initToolbar();
        if (savedInstanceState == null) {
            this.initBackStackState();
        }
    }

    private void initArguments(Bundle savedInstanceState) {
        if (this.getIntent().hasExtra(ARG_FILTER)) {
            Serializable filter = this.getIntent().getSerializableExtra(ARG_FILTER);
            this.mFilter = filter instanceof Pattern ? new PatternFilter((Pattern)filter, false) : (FileFilter)filter;
        }
        if (savedInstanceState != null) {
            this.mStart = (File)savedInstanceState.getSerializable(STATE_START_FILE);
            this.mCurrent = (File)savedInstanceState.getSerializable(STATE_CURRENT_FILE);
            this.updateTitle();
        } else {
            File currentFile;
            if (this.getIntent().hasExtra(ARG_START_FILE)) {
                this.mCurrent = this.mStart = (File)this.getIntent().getSerializableExtra(ARG_START_FILE);
            }
            if (this.getIntent().hasExtra(ARG_CURRENT_FILE) && FileUtils.isParent(currentFile = (File)this.getIntent().getSerializableExtra(ARG_CURRENT_FILE), this.mStart)) {
                this.mCurrent = currentFile;
            }
        }
        if (this.getIntent().hasExtra(ARG_TITLE)) {
            this.mTitle = this.getIntent().getCharSequenceExtra(ARG_TITLE);
        }
        if (this.getIntent().hasExtra(ARG_CLOSEABLE)) {
            this.mCloseable = this.getIntent().getBooleanExtra(ARG_CLOSEABLE, true);
        }
    }

    private void initToolbar() {
        this.setSupportActionBar(this.mToolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        try {
            Field f = TextUtils.isEmpty((CharSequence)this.mTitle) ? this.mToolbar.getClass().getDeclaredField("mTitleTextView") : this.mToolbar.getClass().getDeclaredField("mSubtitleTextView");
            f.setAccessible(true);
            TextView textView = (TextView)f.get(this.mToolbar);
            textView.setEllipsize(TextUtils.TruncateAt.START);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            this.setTitle(this.mTitle);
        }
        this.updateTitle();
    }

    private void initViews() {
        this.mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
    }

    private void initBackStackState() {
        ArrayList<File> path = new ArrayList<File>();
        File current = this.mCurrent;
        while (current != null) {
            path.add(current);
            if (current.equals(this.mStart)) break;
            current = FileUtils.getParentOrNull(current);
        }
        Collections.reverse(path);
        for (File file : path) {
            this.addFragmentToBackStack(file);
        }
    }

    private void updateTitle() {
        if (this.getSupportActionBar() != null) {
            String titlePath = this.mCurrent.getAbsolutePath();
            if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
                this.getSupportActionBar().setTitle((CharSequence)titlePath);
            } else {
                this.getSupportActionBar().setSubtitle((CharSequence)titlePath);
            }
        }
    }

    private void addFragmentToBackStack(File file) {
        this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)DirectoryFragment.getInstance(file, this.mFilter)).addToBackStack(null).commit();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu, menu2);
        menu2.findItem(R.id.action_close).setVisible(this.mCloseable.booleanValue());
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.onBackPressed();
        } else if (menuItem.getItemId() == R.id.action_close) {
            this.finish();
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 1) {
            this.getSupportFragmentManager().popBackStack();
            this.mCurrent = FileUtils.getParentOrNull(this.mCurrent);
            this.updateTitle();
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable(STATE_CURRENT_FILE, (Serializable)this.mCurrent);
        outState.putSerializable(STATE_START_FILE, (Serializable)this.mStart);
    }

    @Override
    public void onFileClicked(File clickedFile) {
        new Handler().postDelayed(() -> this.handleFileClicked(clickedFile), 150L);
    }

    private void handleFileClicked(File clickedFile) {
        if (this.isFinishing()) {
            return;
        }
        if (clickedFile.isDirectory()) {
            this.mCurrent = clickedFile;
            if (this.mCurrent.getAbsolutePath().equals("/storage/emulated")) {
                this.mCurrent = Environment.getExternalStorageDirectory();
            }
            this.addFragmentToBackStack(this.mCurrent);
            this.updateTitle();
        } else {
            this.setResultAndFinish(clickedFile);
        }
    }

    private void setResultAndFinish(File file) {
        Intent data = new Intent();
        data.putExtra(RESULT_FILE_PATH, file.getPath());
        this.setResult(-1, data);
        this.finish();
    }
}

