/*
 * Decompiled with CFR 0.152.
 */
package com.nbsp.materialfilepicker;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import com.nbsp.materialfilepicker.filter.CompositeFilter;
import com.nbsp.materialfilepicker.filter.FileFilter;
import com.nbsp.materialfilepicker.filter.HiddenFilter;
import com.nbsp.materialfilepicker.filter.PatternFilter;
import com.nbsp.materialfilepicker.ui.FilePickerActivity;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class MaterialFilePicker {
    private Activity mActivity;
    private Fragment mFragment;
    private androidx.fragment.app.Fragment mSupportFragment;
    private Class<? extends FilePickerActivity> mFilePickerClass = FilePickerActivity.class;
    private Integer mRequestCode;
    private Pattern mFileFilter;
    private Boolean mDirectoriesFilter = false;
    private String mRootPath;
    private String mCurrentPath;
    private Boolean mShowHidden = false;
    private Boolean mCloseable = true;
    private CharSequence mTitle;

    public MaterialFilePicker withActivity(Activity activity) {
        if (this.mSupportFragment != null || this.mFragment != null) {
            throw new RuntimeException("You must pass either Activity, Fragment or SupportFragment");
        }
        this.mActivity = activity;
        return this;
    }

    public MaterialFilePicker withFragment(Fragment fragment) {
        if (this.mSupportFragment != null || this.mActivity != null) {
            throw new RuntimeException("You must pass either Activity, Fragment or SupportFragment");
        }
        this.mFragment = fragment;
        return this;
    }

    public MaterialFilePicker withSupportFragment(androidx.fragment.app.Fragment fragment) {
        if (this.mActivity != null || this.mFragment != null) {
            throw new RuntimeException("You must pass either Activity, Fragment or SupportFragment");
        }
        this.mSupportFragment = fragment;
        return this;
    }

    public MaterialFilePicker withRequestCode(int requestCode) {
        this.mRequestCode = requestCode;
        return this;
    }

    public MaterialFilePicker withFilter(Pattern pattern) {
        this.mFileFilter = pattern;
        return this;
    }

    public MaterialFilePicker withFilterDirectories(boolean directoriesFilter) {
        this.mDirectoriesFilter = directoriesFilter;
        return this;
    }

    public MaterialFilePicker withRootPath(String rootPath) {
        this.mRootPath = rootPath;
        return this;
    }

    public MaterialFilePicker withPath(String path) {
        this.mCurrentPath = path;
        return this;
    }

    public MaterialFilePicker withHiddenFiles(boolean show) {
        this.mShowHidden = show;
        return this;
    }

    public MaterialFilePicker withCloseMenu(boolean closeable) {
        this.mCloseable = closeable;
        return this;
    }

    public MaterialFilePicker withTitle(CharSequence title) {
        this.mTitle = title;
        return this;
    }

    public MaterialFilePicker withCustomActivity(Class<? extends FilePickerActivity> customActivityClass) {
        this.mFilePickerClass = customActivityClass;
        return this;
    }

    public void start() {
        if (this.mActivity == null && this.mFragment == null && this.mSupportFragment == null) {
            throw new RuntimeException("You must pass Activity/Fragment by calling withActivity/withFragment/withSupportFragment method");
        }
        if (this.mRequestCode == null) {
            throw new RuntimeException("You must pass request code by calling withRequestCode method");
        }
        Intent intent = this.getIntent();
        if (this.mActivity != null) {
            this.mActivity.startActivityForResult(intent, this.mRequestCode.intValue());
        } else if (this.mFragment != null) {
            this.mFragment.startActivityForResult(intent, this.mRequestCode.intValue());
        } else {
            this.mSupportFragment.startActivityForResult(intent, this.mRequestCode.intValue());
        }
    }

    private CompositeFilter getFilter() {
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        if (!this.mShowHidden.booleanValue()) {
            filters.add(new HiddenFilter());
        }
        if (this.mFileFilter != null) {
            filters.add(new PatternFilter(this.mFileFilter, this.mDirectoriesFilter));
        }
        return new CompositeFilter(filters);
    }

    private Intent getIntent() {
        CompositeFilter filter = this.getFilter();
        Activity activity = null;
        if (this.mActivity != null) {
            activity = this.mActivity;
        } else if (this.mFragment != null) {
            activity = this.mFragment.getActivity();
        } else if (this.mSupportFragment != null) {
            activity = this.mSupportFragment.getActivity();
        }
        Intent intent = new Intent((Context)activity, this.mFilePickerClass);
        intent.putExtra("arg_filter", (Serializable)filter);
        intent.putExtra("arg_closeable", (Serializable)this.mCloseable);
        if (this.mRootPath != null) {
            intent.putExtra("arg_start_path", (Serializable)new File(this.mRootPath));
        }
        if (this.mCurrentPath != null) {
            intent.putExtra("arg_current_path", (Serializable)new File(this.mCurrentPath));
        }
        if (this.mTitle != null) {
            intent.putExtra("arg_title", this.mTitle);
        }
        return intent;
    }
}

