/*
 * Decompiled with CFR 0.152.
 */
package com.nbottarini.asimov.environment;

import com.nbottarini.asimov.environment.Env;
import com.nbottarini.asimov.environment.EnvVar;
import io.github.cdimascio.dotenv.Dotenv;
import io.github.cdimascio.dotenv.DotenvEntry;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0086\u0002J\u001b\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u000bH\u0086\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0018\u0010\u001a\u001a\n \u001b*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/nbottarini/asimov/environment/Env;", "", "()V", "dotenv", "Lio/github/cdimascio/dotenv/Dotenv;", "getDotenv", "()Lio/github/cdimascio/dotenv/Dotenv;", "dotenv$delegate", "Lkotlin/Lazy;", "searchPaths", "", "", "addSearchPath", "", "path", "envExists", "", "Ljava/nio/file/Path;", "findEnvDirectory", "get", "name", "defaultValue", "getAll", "", "Lcom/nbottarini/asimov/environment/EnvVar;", "getOrThrow", "getPath", "kotlin.jvm.PlatformType", "environment"})
public final class Env {
    @NotNull
    public static final Env INSTANCE = new Env();
    @NotNull
    private static final List<String> searchPaths = new ArrayList();
    @NotNull
    private static final Lazy dotenv$delegate = LazyKt.lazy((Function0)dotenv.2.INSTANCE);

    private Env() {
    }

    private final Dotenv getDotenv() {
        Lazy lazy = dotenv$delegate;
        return (Dotenv)lazy.getValue();
    }

    public final void addSearchPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        searchPaths.add(path);
    }

    @Nullable
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getDotenv().get(name);
    }

    @NotNull
    public final String get(@NotNull String name, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String string = this.get(name);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public static /* synthetic */ String get$default(Env env, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return env.get(string, string2);
    }

    @NotNull
    public final String getOrThrow(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.getDotenv().get(name);
        if (string == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Missing environment variable ", (Object)name));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EnvVar> getAll() {
        void $this$mapTo$iv$iv;
        Set set = this.getDotenv().entries();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"dotenv.entries()");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DotenvEntry dotenvEntry = (DotenvEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.key");
            String string2 = string;
            string = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
            collection.add(new EnvVar(string2, string));
        }
        return (List)destination$iv$iv;
    }

    private final Path getPath(String path) {
        return Paths.get(path, new String[0]).toAbsolutePath().normalize();
    }

    private final boolean envExists(Path path) {
        return Files.exists(path.resolve(".env"), new LinkOption[0]) || Files.exists(path.resolve(".env.dist"), new LinkOption[0]);
    }

    private final String findEnvDirectory() {
        for (String searchPath : searchPaths) {
            Path path = this.getPath(searchPath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            if (!this.envExists(path)) continue;
            return ((Object)path).toString();
        }
        Path path = this.getPath("./");
        do {
            Path path2 = path;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            if (!this.envExists(path2)) continue;
            return ((Object)path).toString();
        } while ((path = path.getParent()) != null);
        return "./";
    }

    public static final /* synthetic */ String access$findEnvDirectory(Env $this) {
        return $this.findEnvDirectory();
    }
}

