/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.spring.boot;

import com.navercorp.pinpoint.bootstrap.resolver.condition.MainClassCondition;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import java.util.Arrays;
import java.util.List;

public class SpringBootDetector {
    private static final String[] DEFAULT_EXPECTED_MAIN_CLASSES = new String[]{"org.springframework.boot.loader.JarLauncher", "org.springframework.boot.loader.WarLauncher", "org.springframework.boot.loader.PropertiesLauncher"};
    private final List<String> expectedMainClasses;

    public SpringBootDetector(List<String> expectedMainClasses) {
        this.expectedMainClasses = CollectionUtils.isEmpty(expectedMainClasses) ? Arrays.asList(DEFAULT_EXPECTED_MAIN_CLASSES) : expectedMainClasses;
    }

    public boolean detect() {
        String bootstrapMainClass = MainClassCondition.INSTANCE.getValue();
        return this.expectedMainClasses.contains(bootstrapMainClass);
    }
}

