/*
 * Decompiled with CFR 0.152.
 */
package com.naver.speech.clientapi;

import android.media.AudioRecord;
import com.naver.speech.clientapi.AudioCaptureException;

class AudioCapture {
    private static final String TAG = AudioCapture.class.getSimpleName();
    private static final int SAMPLING_FREQ = 16000;
    private static final int AUDIO_READ_SIZE_IN_SHORTS = 3200;
    private static final int AUDIO_RECORD_BUFFER_SIZE_IN_BYTE = 32000;
    private AudioRecord mAudioRecord;
    private short[] mAudioBuffer = new short[3200];
    static final int OK = 0;
    static final int ERROR = -1;

    AudioCapture() {
    }

    void beforeStart() throws Exception {
        int bufferSize = Math.max(32000, AudioRecord.getMinBufferSize((int)16000, (int)16, (int)2));
        this.mAudioRecord = new AudioRecord(6, 16000, 16, 2, bufferSize);
        this.mAudioRecord.startRecording();
    }

    void beforeFinish() throws Exception {
        this.mAudioRecord.stop();
        this.mAudioRecord.release();
    }

    short[] record() throws Exception {
        int readed = this.mAudioRecord.read(this.mAudioBuffer, 0, 3200);
        if (readed < 0) {
            switch (readed) {
                case -1: {
                    throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR");
                }
                case -2: {
                    throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR_BAD_VALUE");
                }
                case -3: {
                    throw new AudioCaptureException("AudioRecord.read didn't work : AudioRecord.ERROR_INVALID_OPERATION");
                }
            }
            throw new AudioCaptureException("AudioRecord.read didn't work : " + readed);
        }
        return this.mAudioBuffer;
    }
}

