/*
 * @(#) AudioCaptureException.java 2015. 1.
 *
 * Copyright 2015 Naver Corp. All rights Reserved.
 * Naver PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.naver.speech.clientapi;

/**
 * 이 예외는 오디오에 관련된 오류를 처리한다.
 * 첫 번째, 기존에 허용된 시간보다 더 오래 인식기를 수행하였을 경우이다. 현재 네이버 음성인식은 기본적으로 최대 70초를 권장하고 있다.
 * 두 번째, 음성 입력 오류가 발생하였을 경우이다. 이 오류는 좀 더 보편적인 오류로, 다양한 이유에 의해 발생할 수 있다.
 * (예를 들어, 현재 어플리케이션의 메인 스레드에서 마이크 리소스를 사용하지 못하는 경우 ) 네이버 음성인식에서 권장하는 설정으로 수행한다면, 해당 오류는 발생하지 않을 것이다.
 * 세 번째, {@link IllegalStateException}이 발생하였을 경우이다.
 *
 */
public class AudioCaptureException extends Exception {

	private static final long serialVersionUID = -56679720798140245L;

	/**
	 * 현재 stack trace에 대한 예외를 발생한다.
	 * 예외에 대한 설명은 {@link AudioCaptureException} 을 참조한다.
	 */
	public AudioCaptureException() {
		super();
	}

	/**
	 * 현재 stack trace에 대한 예외를 발생한다.
	 * 예외에 대한 설명은 {@link AudioCaptureException} 을 참조한다.
	 * @param detailMessage 이 예외에 대한 상세 메세지.
	 */
	public AudioCaptureException(String detailMessage) {
		super(detailMessage);
	}
}
