/*
 * @(#) SpeechConfig.java 2015. 1.
 *
 * Copyright 2015 Naver Corp. All rights Reserved.
 * Naver PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.naver.speech.clientapi;

/**
 * 이 클래스는 네이버 음성인식에서 제공하는 음성인식기에 대한 설정을 포함하고 있습니다.
 * <dl>
 * <dt>언어</dt>
 * <dd>한국어, 영어, 일본어, 중국어 총 4가지 언어를 제공합니다.</dd>
 * <dt>EPD(end point detection) 모드</dt>
 * <dd>
 * AUTO, MANUAL, HYBRID 총 3가지 EPD 모드를 제공합니다.
 * <br>
 * AUTO : 서버에서 EPD를 감지하여 {@link SpeechRecognizer#onEndPointDetected()}를 호출합니다.
 * <br>
 * MANUAL : 유저가 직접 {@link SpeechRecognizer#stop()}을 통해서 {@link SpeechRecognizer#onEndPointDetected()}를 호출합니다.
 * <br>
 * HYBRID : 상황에 따라 AUTO 또는 MANUAL로 동작합니다.
 * 이는 유저가 {@link SpeechRecognizer#selectEPDTypeInHybrid(EndPointDetectType)}를 호출하여 결정되거나, 또는 내부적으로 implicit하게 결정됩니다.
 * </dd>
 * </dl>
 */
public class SpeechConfig {

	public enum ServiceType {
		OPENAPI		(4);

		private int serviceType;
		ServiceType(int serviceType) {
			this.serviceType = serviceType;
		}
		int toInteger() { return this.serviceType; }
	}

	public enum LanguageType {
		KOREAN		(0),
		JAPANESE	(1),
		ENGLISH		(2),
		CHINESE		(3);

		private int languageType;
		LanguageType(int languageType) {
			this.languageType = languageType;
		}
		int toInteger() {
			return this.languageType;
		}
	}

	public enum CaptureType {
		PRESS		(0);

		private int captureType;
		CaptureType(int captureType) {
			this.captureType = captureType;
		}
		int toInteger() {return this.captureType; }
	}

	public enum WakewordType {
		CLOVA		(0);

		private int wakewordType;
		WakewordType(int wakewordType) {
			this.wakewordType = wakewordType;
		}
		int toInteger() {return this.wakewordType; }
	}

	public enum EndPointDetectType {
		AUTO(0),
		MANUAL(1),
		HYBRID(2);

		private int epdType;
		EndPointDetectType(int epdType) {
			this.epdType = epdType;
		}
		public int toInteger() {
			return this.epdType;
		}
	}

	public enum DomainType {
	    NORMAL(0),
        GOV(1),
        FIN(2);

	    private int domainType;
	    DomainType(int domainType) { this.domainType = domainType; }
	    public int toInteger() { return this.domainType; }
    }

	public static enum ConnectionType {
		GRPC_SECURE(2);

		private int connectionType;
		ConnectionType(int connectionType) {
			this.connectionType = connectionType;
		}
		public int toInteger() {
			return this.connectionType;
		}
	}

	private ServiceType			mServiceType;
	private LanguageType		mLanguageType;
	private CaptureType			mCaptureType;
	private WakewordType		mWakewordType;
	private EndPointDetectType	mEndPointDetectType;
	private ConnectionType      mConnectionType;
	private boolean				mQuestionDetection;
	private String				mExtraInfo;

	public SpeechConfig(
			LanguageType languageType,
			EndPointDetectType endPointDetectType)
			{
		this.mServiceType		= ServiceType.OPENAPI;
		this.mLanguageType		= languageType;
		this.mCaptureType		= CaptureType.PRESS;
		this.mWakewordType		= WakewordType.CLOVA;
		this.mQuestionDetection	= false;
		this.mEndPointDetectType	= endPointDetectType;
		this.mConnectionType    = ConnectionType.GRPC_SECURE;
		this.mExtraInfo				= null;
			}

	/////////////////////////////////////////////////////////////////
	//
	// setter / getter
	//
	ServiceType getServiceType() {
		return mServiceType;
	}

	public LanguageType getLanguageType() {
		return mLanguageType;
	}

	public CaptureType getCaptureType() {
		return mCaptureType;
	}

	public WakewordType getWakewordType() {
		return mWakewordType;
	}

	public EndPointDetectType getEndPointDetectType() {
		return mEndPointDetectType;
	}

	public ConnectionType getConnectionType() {
		return mConnectionType;
	}

	boolean isQuestionDetection() {
		return mQuestionDetection;
	}

	String getExtraInfo() { return mExtraInfo; }
}
