/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.util;

import android.content.UriMatcher;
import android.net.Uri;
import java.net.MalformedURLException;
import java.net.URL;

public class WebLoadUtil {
    private static final String TAG = "WebLoadUtil";
    private static final int EMPTY_URL = 10;
    private static final int BLANK_URL = 11;
    private static final int NID_DOMAIN = 20;
    private static final int NID_DOMAIN_ID = 21;
    private static final int NID_DOMAIN_PW = 22;
    private static final int NID_DOMAIN_JOIN = 23;
    private static final int NID_DOMAIN_LOGOUT = 24;
    private static final int SSO_LOGOUT = 30;
    private static final int SSO_CROSS_DOMAIN = 31;
    private static final int SSO_FINALIZE = 32;
    private static final int CC_NAVER = 40;
    private static final int CR_NAVER = 41;
    private static final int VNO = 50;
    private static final int OK_NAME = 51;
    private static final int SIREN = 52;
    private static final UriMatcher uriMatcher = new UriMatcher(-1);

    public static boolean isInAppBrowserUrl(String url) {
        if (url.length() <= 0 || url.contentEquals("about:blank")) {
            return true;
        }
        Uri uri = Uri.parse((String)url);
        int match = uriMatcher.match(uri);
        switch (match) {
            case 21: 
            case 22: 
            case 23: {
                return false;
            }
        }
        return true;
    }

    public static boolean loadBrowser(String urlString) {
        if (urlString.length() <= 0 || urlString.contentEquals("about:blank")) {
            return false;
        }
        if (urlString.contains("/sso/logout.nhn") || urlString.contains("/sso/cross-domain.nhn") || urlString.contains("/sso/finalize.nhn")) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String host = url.getHost();
        if (host.equals("ipin.siren24.com")) {
            return false;
        }
        if (host.equals("ipin.ok-name.co.kr")) {
            return false;
        }
        if (host.equals("cert.vno.co.kr")) {
            return false;
        }
        if (host.equals("cc.naver.com") || host.equals("cr.naver.com")) {
            return false;
        }
        if (host.equals("nid.naver.com")) {
            String path = url.getPath();
            if (path.startsWith("/nidlogin.logout")) {
                return false;
            }
            return path.startsWith("/mobile/user/help/idInquiry.nhn") || path.startsWith("/mobile/user/help/pwInquiry.nhn") || path.startsWith("/user/mobile_join.nhn");
        }
        return true;
    }

    public static boolean improveLoadBrowser(String urlString) {
        if (urlString.length() <= 0 || urlString.contentEquals("about:blank")) {
            return false;
        }
        if (urlString.contains("/sso/logout.nhn") || urlString.contains("/sso/cross-domain.nhn") || urlString.contains("/sso/finalize.nhn")) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String host = url.getHost();
        if (host.equals("ipin.siren24.com")) {
            return false;
        }
        if (host.equals("ipin.ok-name.co.kr")) {
            return false;
        }
        if (host.equals("cert.vno.co.kr")) {
            return false;
        }
        if (host.equals("cc.naver.com") || host.equals("cr.naver.com")) {
            return false;
        }
        if (host.equals("nid.naver.com")) {
            String path = url.getPath();
            if (path.startsWith("/nidlogin.logout")) {
                return false;
            }
            return path.startsWith("/mobile/user/help/idInquiry.nhn") || path.startsWith("/mobile/user/help/pwInquiry.nhn") || path.startsWith("/user/mobile_join.nhn");
        }
        return true;
    }

    static {
        uriMatcher.addURI("nid.naver.com", "mobile/user/help/idInquiry.nhn", 21);
        uriMatcher.addURI("nid.naver.com", "mobile/user/help/pwInquiry.nhn", 22);
        uriMatcher.addURI("nid.naver.com", "user2/V2Join.nhn", 23);
        uriMatcher.addURI("nid.naver.com", "nidlogin.logout", 24);
        uriMatcher.addURI("*", "/sso/logout.nhn", 30);
        uriMatcher.addURI("*", "/sso/cross-domain.nhn", 31);
        uriMatcher.addURI("*", "/sso/finalize.nhn", 32);
        uriMatcher.addURI("cc.naver.com", "*", 40);
        uriMatcher.addURI("cr.naver.com", "*", 41);
        uriMatcher.addURI("cert.vno.co.kr", "*", 50);
        uriMatcher.addURI("ipin.ok-name.co.kr", "*", 51);
        uriMatcher.addURI("ipin.siren24.com", "*", 52);
    }
}

