/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.nhn.android.naverlogin.util.CustomTabsListener;
import java.util.ArrayList;
import java.util.List;

public final class CustomTabsManager {
    public static final String ACTION_NAVER_CUSTOM_TAB = "ACTION_NAVER_3RDPARTY_CUSTOM_TAB";
    private static final String CUSTOMTAB_DIALOG = "CUSTOMTAB_DIALOG";
    private final Context mContext;
    private static final String STABLE_PACKAGE = "com.android.chrome";
    private static final String LOCAL_PACKAGE = "com.google.android.apps.chrome";

    public CustomTabsManager(Context base) {
        this.mContext = base;
    }

    public static List<PackageInfo> getCustomTabsPackages(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent activityIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        List resolvedActivityList = pm.queryIntentActivities(activityIntent, 0);
        ArrayList<PackageInfo> packagesSupportingCustomTabs = new ArrayList<PackageInfo>();
        for (ResolveInfo info : resolvedActivityList) {
            Intent serviceIntent = new Intent();
            serviceIntent.setAction("android.support.customtabs.action.CustomTabsService");
            serviceIntent.setPackage(info.activityInfo.packageName);
            Log.d((String)"custom tab util", (String)info.activityInfo.packageName);
            if (pm.resolveService(serviceIntent, 0) == null) continue;
            try {
                ApplicationInfo ai = pm.getApplicationInfo(info.activityInfo.packageName, 0);
                if (!ai.enabled) continue;
                packagesSupportingCustomTabs.add(pm.getPackageInfo(info.activityInfo.packageName, 0));
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return packagesSupportingCustomTabs;
    }

    private boolean chromeInstalledOrNot() {
        PackageManager pm = this.mContext.getPackageManager();
        try {
            pm.getPackageInfo(STABLE_PACKAGE, 1);
            ApplicationInfo ai = pm.getApplicationInfo(STABLE_PACKAGE, 0);
            return ai.enabled;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static boolean isCustomTabAvailable(Context context) {
        List<PackageInfo> customTabsPackages = CustomTabsManager.getCustomTabsPackages(context);
        return customTabsPackages != null && customTabsPackages.size() > 0;
    }

    public void launchUrl(String packageName, String url) {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setShowTitle(true).build();
        customTabsIntent.intent.setPackage(packageName);
        this.launchUrl(customTabsIntent, url);
    }

    public void launchUrl(CustomTabsIntent intent, String url) {
        intent.launchUrl(this.mContext, Uri.parse((String)url));
    }

    public void setCustomTabListener(final CustomTabsListener listener) {
        final LocalBroadcastManager instance = LocalBroadcastManager.getInstance((Context)this.mContext);
        instance.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                listener.onReceive(intent);
                instance.unregisterReceiver((BroadcastReceiver)this);
            }
        }, new IntentFilter(ACTION_NAVER_CUSTOM_TAB));
    }

    public void sendCustomTabResult(Intent intent) {
        intent.setAction(ACTION_NAVER_CUSTOM_TAB);
        intent.setClass(this.mContext, CustomTabsManager.class);
        LocalBroadcastManager instance = LocalBroadcastManager.getInstance((Context)this.mContext);
        instance.sendBroadcast(intent);
    }
}

