/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui.view;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import com.nhn.android.oauth.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomTabDialogFragment
extends DialogFragment {
    public static final String ARG_PACKAGE = "packages";
    public static final String DIALOG_TAG = "CUSTOM_TAB_SELECTOR";
    private List<PackageInfo> mPackageList;
    private CustomTabAppAdaptor mAdaptor;
    private OnPackageSelectListener mPackageSelectListener;

    public static CustomTabDialogFragment newInstance(List<PackageInfo> packageList) {
        CustomTabDialogFragment fragment = new CustomTabDialogFragment();
        Bundle args = new Bundle();
        args.putParcelableArray(ARG_PACKAGE, (Parcelable[])packageList.toArray(new PackageInfo[0]));
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null && arguments.getParcelableArray(ARG_PACKAGE) != null) {
            List<Parcelable> parcelablePackageInfoList = Arrays.asList(arguments.getParcelableArray(ARG_PACKAGE));
            this.mPackageList = new ArrayList<PackageInfo>();
            for (Parcelable p : parcelablePackageInfoList) {
                this.mPackageList.add((PackageInfo)p);
            }
            this.mAdaptor = new CustomTabAppAdaptor();
            this.setStyle(1, R.style.Theme_AppCompat_DayNight_Dialog_Alert);
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder dialog = new AlertDialog.Builder((Context)this.getActivity(), this.getTheme()).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CustomTabDialogFragment.this.onCancel(dialog);
            }
        }).setAdapter((ListAdapter)this.mAdaptor, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CustomTabDialogFragment.this.mPackageSelectListener.onPackageSelect((PackageInfo)CustomTabDialogFragment.this.mPackageList.get(which));
            }
        }).setTitle(R.string.use_application);
        return dialog.create();
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.mPackageSelectListener.onPackageSelect(null);
    }

    public void onDetach() {
        super.onDetach();
        this.mPackageSelectListener = null;
    }

    public void setPackageSelectListener(OnPackageSelectListener packageSelectListener) {
        this.mPackageSelectListener = packageSelectListener;
    }

    private class CustomTabAppAdaptor
    extends BaseAdapter {
        private CustomTabAppAdaptor() {
        }

        public int getCount() {
            return CustomTabDialogFragment.this.mPackageList.size();
        }

        public Object getItem(int position) {
            return CustomTabDialogFragment.this.mPackageList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            LinearLayout layout2 = (LinearLayout)convertView;
            if (convertView == null) {
                LayoutInflater layoutInflater = (LayoutInflater)parent.getContext().getSystemService("layout_inflater");
                layout2 = (LinearLayout)layoutInflater.inflate(R.layout.package_list_item, parent, false);
            }
            ImageView icon = (ImageView)layout2.findViewById(R.id.package_icon);
            TextView name = (TextView)layout2.findViewById(R.id.package_name);
            PackageInfo item = (PackageInfo)this.getItem(position);
            PackageManager pm = CustomTabDialogFragment.this.getActivity().getPackageManager();
            icon.setImageDrawable(item.applicationInfo.loadIcon(pm));
            name.setText(item.applicationInfo.loadLabel(pm));
            return layout2;
        }
    }

    public static interface OnPackageSelectListener {
        public void onPackageSelect(PackageInfo var1);
    }
}

