/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import com.nhn.android.idp.common.connection.NetworkState;
import com.nhn.android.idp.common.logger.Logger;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.gen.OAuthQueryGenerator;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.ui.OAuthWebviewUrlUtil;
import com.nhn.android.naverlogin.ui.view.OAuthLoginLayoutNaverAppDownloadBanner;
import com.nhn.android.naverlogin.util.WebLoadUtil;
import com.nhn.android.oauth.R;

public class OAuthLoginInAppBrowserActivity
extends Activity {
    private static final String TAG = "OAuthLoginInAppBrowserActivity";
    private Context context;
    private LinearLayout wholeView;
    private int wholeViewHeight;
    private OAuthLoginLayoutNaverAppDownloadBanner naverAppDownloadBanner;
    private WebView webView;
    private LinearLayout navigationBar;
    private ImageView closeImageButton;
    private ProgressBar progressBar;
    private OAuthLoginData oauthLoginData;
    private String oauthUrl;
    private String sdkVersion;
    private static final String INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE = "IsLoginActivityStarted";
    private static final String INSTANCE_STATE_IS_VISIBLE_BANNER = "isVisibleBanner";
    private String mWebViewContent;
    private boolean mIsLoginActivityStarted = false;
    private boolean mVisibleNaverAppDownloadBanner = true;
    final DownloadListener mDefaultDownloadListener = new DownloadListener(){

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
            Intent viewIntent = new Intent("android.intent.action.VIEW");
            viewIntent.setDataAndType(Uri.parse((String)url), mimetype);
            try {
                OAuthLoginInAppBrowserActivity.this.startActivity(viewIntent);
            }
            catch (Throwable th) {
                th.printStackTrace();
                try {
                    viewIntent.setData(Uri.parse((String)url));
                    OAuthLoginInAppBrowserActivity.this.startActivity(viewIntent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initData();
        this.initView();
        this.initSavedInstanceStateData(savedInstanceState);
    }

    private void initData() {
        this.context = this;
        if (this.getIntent() == null) {
            return;
        }
        String clientId = this.getIntent().getStringExtra("ClientId");
        String callbackUrl = this.getIntent().getStringExtra("ClientCallbackUrl");
        String state = this.getIntent().getStringExtra("state");
        this.oauthLoginData = new OAuthLoginData(clientId, null, callbackUrl, state);
        if (this.getIntent().hasExtra("OAuthUrl")) {
            String url = this.getIntent().getStringExtra("OAuthUrl");
            if (url.startsWith("https://nid.naver.com")) {
                this.oauthUrl = url;
            }
        } else {
            String locale = DeviceAppInfo.getBaseInstance().getLocaleString(this.context);
            String network = NetworkState.getNetworkState(this.context);
            this.oauthUrl = new OAuthQueryGenerator().generateRequestWebViewAuthorizationUrl(clientId, this.oauthLoginData.getInitState(), callbackUrl, locale, network, "4.3.2");
        }
        this.sdkVersion = this.getIntent().getStringExtra("oauth_sdk_version");
    }

    private void initView() {
        this.requestWindowFeature(1);
        this.setContentView(R.layout.nlogin_browser_view);
        this.wholeView = (LinearLayout)this.findViewById(R.id.wholeView);
        this.wholeView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (OAuthLoginInAppBrowserActivity.this.wholeViewHeight == 0) {
                    OAuthLoginInAppBrowserActivity.this.wholeViewHeight = OAuthLoginInAppBrowserActivity.this.wholeView.getHeight();
                }
                if (OAuthLoginInAppBrowserActivity.this.wholeViewHeight > OAuthLoginInAppBrowserActivity.this.wholeView.getHeight() || !OAuthLoginDefine.BOTTOM_TAB_WORKING) {
                    OAuthLoginInAppBrowserActivity.this.navigationBar.setVisibility(8);
                } else {
                    OAuthLoginInAppBrowserActivity.this.navigationBar.setVisibility(0);
                }
            }
        });
        if (OAuthLoginDefine.MARKET_LINK_WORKING) {
            this.naverAppDownloadBanner = (OAuthLoginLayoutNaverAppDownloadBanner)this.findViewById(R.id.app_download_banner);
            this.naverAppDownloadBanner.setVisibility(0);
        }
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setVerticalScrollbarOverlay(true);
        this.webView.setHorizontalScrollbarOverlay(true);
        this.webView.setWebViewClient((WebViewClient)new InAppWebViewClient());
        this.webView.setWebChromeClient((WebChromeClient)new InAppWebChromeClient());
        this.webView.setDownloadListener(this.mDefaultDownloadListener);
        String userAgent = this.webView.getSettings().getUserAgentString() + " " + DeviceAppInfo.getUserAgent((Context)this);
        this.webView.getSettings().setUserAgentString(userAgent);
        this.webView.getSettings().setAppCacheEnabled(false);
        this.webView.getSettings().setCacheMode(2);
        this.navigationBar = (LinearLayout)this.findViewById(R.id.webviewNaviBar);
        if (!OAuthLoginDefine.BOTTOM_TAB_WORKING) {
            this.navigationBar.setVisibility(8);
        }
        this.closeImageButton = (ImageView)this.findViewById(R.id.webviewEndKey);
        this.closeImageButton.setClickable(true);
        this.closeImageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OAuthLoginInAppBrowserActivity.this.finish();
            }
        });
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.initSavedInstanceStateData(savedInstanceState);
        if (!Logger.isRealVersion()) {
            // empty if block
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onSaveInstanceState()");
        }
        outState.putBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE, this.mIsLoginActivityStarted);
        if (this.webView != null) {
            this.webView.saveState(outState);
        }
        outState.putString("SdkVersionCalledFrom", this.sdkVersion);
        outState.putString("oauthUrl", this.oauthUrl);
        if (this.mVisibleNaverAppDownloadBanner && null != this.naverAppDownloadBanner && this.naverAppDownloadBanner.getVisibility() == 0) {
            outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, true);
        } else {
            outState.putBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER, false);
        }
    }

    private void initSavedInstanceStateData(Bundle savedInstanceState) {
        if (null != savedInstanceState) {
            this.mIsLoginActivityStarted = savedInstanceState.getBoolean(INSTANCE_STATE_WEBVIEW_RUN_ONLY_ONCE);
            if (this.webView != null) {
                this.webView.restoreState(savedInstanceState);
            }
            this.sdkVersion = savedInstanceState.getString("SdkVersionCalledFrom");
            this.mVisibleNaverAppDownloadBanner = savedInstanceState.getBoolean(INSTANCE_STATE_IS_VISIBLE_BANNER);
            this.oauthUrl = savedInstanceState.getString("oauthUrl");
        }
    }

    private void runOnlyOnce() {
        if (this.getIntent() != null) {
            String url = this.getIntent().getStringExtra("agreeFormUrl");
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.oauthUrl = url;
            }
            this.mWebViewContent = this.getIntent().getStringExtra("agreeFormContent");
        }
        if (TextUtils.isEmpty((CharSequence)this.mWebViewContent)) {
            if (!Logger.isRealVersion()) {
                Logger.d(TAG, "webview url -> " + this.oauthUrl);
            }
            this.webView.loadUrl(this.oauthUrl);
        } else {
            if (!Logger.isRealVersion()) {
                Logger.d(TAG, "webview url -> " + this.oauthUrl);
                Logger.d(TAG, "webview content -> " + this.mWebViewContent);
            }
            this.webView.loadDataWithBaseURL(this.oauthUrl, this.mWebViewContent, "text/html", null, null);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.webView != null) {
            this.webView.resumeTimers();
            if (Build.VERSION.SDK_INT >= 11) {
                this.webView.onResume();
            }
        }
        if (!this.mIsLoginActivityStarted) {
            if (!Logger.isRealVersion()) {
                Logger.d(TAG, "webview onResume() first");
            }
            this.mIsLoginActivityStarted = true;
            this.runOnlyOnce();
        }
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onResume()");
        }
    }

    public void onPause() {
        super.onPause();
        if (this.webView != null && Build.VERSION.SDK_INT >= 11) {
            this.webView.onPause();
        }
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onPause()");
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "webview onDestroy()");
        }
        if (this.webView != null) {
            this.webView.stopLoading();
            if (this.wholeView != null) {
                this.wholeView.removeView((View)this.webView);
            }
            this.webView.clearCache(false);
            this.webView.removeAllViews();
            this.webView.destroy();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (!Logger.isRealVersion()) {
            Logger.d(TAG, "screen orientation = " + (newConfig.orientation == 2 ? "landscape" : "portrait"));
        }
        this.wholeViewHeight = 0;
    }

    private class InAppWebViewClient
    extends WebViewClient {
        private String preUrl = "";

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (!Logger.isRealVersion()) {
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[star] pre url : " + this.preUrl);
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[star]     url : " + url);
            }
            if (OAuthWebviewUrlUtil.isFinalUrl(false, this.preUrl, url)) {
                OAuthLoginInAppBrowserActivity.this.webView.stopLoading();
                OAuthLoginInAppBrowserActivity.this.finish();
                return;
            }
            if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(OAuthLoginInAppBrowserActivity.this.context, this.preUrl, url, OAuthLoginInAppBrowserActivity.this.oauthLoginData)) {
                OAuthLoginInAppBrowserActivity.this.webView.stopLoading();
                return;
            }
            super.onPageStarted(view, url, favicon);
            if (OAuthLoginInAppBrowserActivity.this.progressBar != null) {
                OAuthLoginInAppBrowserActivity.this.progressBar.setVisibility(0);
            }
        }

        @RequiresApi(api=21)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!Logger.isRealVersion()) {
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[over] pre url : " + this.preUrl);
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "[over]     url : " + url);
            }
            if (OAuthWebviewUrlUtil.isFinalUrl(true, this.preUrl, url)) {
                OAuthLoginInAppBrowserActivity.this.webView.stopLoading();
                OAuthLoginInAppBrowserActivity.this.finish();
                return true;
            }
            if (OAuthWebviewUrlUtil.returnWhenAuthorizationDone(OAuthLoginInAppBrowserActivity.this.context, this.preUrl, url, OAuthLoginInAppBrowserActivity.this.oauthLoginData)) {
                return true;
            }
            if (!WebLoadUtil.isInAppBrowserUrl(url)) {
                Intent i = new Intent("android.intent.action.VIEW");
                Uri u = Uri.parse((String)url);
                i.setData(u);
                try {
                    OAuthLoginInAppBrowserActivity.this.startActivity(i);
                }
                catch (ActivityNotFoundException e) {
                    Toast.makeText((Context)OAuthLoginInAppBrowserActivity.this.context, (int)R.string.naveroauthlogin_string_browser_app_issue, (int)0).show();
                }
                return true;
            }
            view.loadUrl(url);
            this.preUrl = url;
            return true;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (OAuthLoginInAppBrowserActivity.this.progressBar != null) {
                OAuthLoginInAppBrowserActivity.this.progressBar.setVisibility(8);
            }
            view.clearCache(true);
        }

        @RequiresApi(api=23)
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            this.onReceivedError(view, error.getErrorCode(), error.getDescription().toString(), request.getUrl().toString());
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (OAuthLoginInAppBrowserActivity.this.progressBar != null) {
                OAuthLoginInAppBrowserActivity.this.progressBar.setVisibility(8);
            }
            if (!Logger.isRealVersion()) {
                Logger.d(OAuthLoginInAppBrowserActivity.TAG, "webview receive error " + errorCode + ", " + description + ", " + failingUrl);
            }
            if (!NetworkState.checkConnectivity(OAuthLoginInAppBrowserActivity.this.context, true, null)) {
                OAuthLoginInAppBrowserActivity.this.finish();
                return;
            }
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            super.onFormResubmission(view, dontResend, resend);
        }
    }

    private class InAppWebChromeClient
    extends WebChromeClient {
        private InAppWebChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (OAuthLoginInAppBrowserActivity.this.progressBar != null) {
                OAuthLoginInAppBrowserActivity.this.progressBar.setProgress(newProgress);
            }
        }
    }
}

