/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.navercorp.naverid.internal.log.Logger;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.naverlogin.OAuthLogin;
import com.nhn.android.naverlogin.OAuthLoginDefine;
import com.nhn.android.naverlogin.connection.OAuthLoginConnection;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.data.OAuthLoginPreferenceManager;
import com.nhn.android.naverlogin.data.OAuthResponse;
import com.nhn.android.naverlogin.ui.OAuthCustomTabActivity;
import com.nhn.android.naverlogin.ui.OAuthLoginDialogManager;
import com.nhn.android.naverlogin.ui.OAuthLoginInAppBrowserActivity;
import com.nhn.android.naverlogin.util.CustomTabsListener;
import com.nhn.android.naverlogin.util.CustomTabsManager;
import com.nhn.android.oauth.R;

public class OAuthLoginActivity
extends Activity {
    private static final String TAG = "OAuthLoginActivity";
    private static int REQUESTCODE_LOGIN = 100;
    private static int CUSTOMTAB_LOGIN = -1;
    private OAuthLoginDialogManager oauthLoginDialogManager = new OAuthLoginDialogManager();
    private Context context;
    private OAuthLoginData oauthLoginData;
    private String clientName;
    private boolean isForceDestroyed = true;
    private boolean isLoginActivityStarted = false;
    private CustomTabsListener customTabsListener = new CustomTabsListener(){

        @Override
        public void onReceive(Intent intent) {
            if (intent == null) {
                intent = new Intent();
                intent.putExtra("oauth_error_code", OAuthErrorCode.CLIENT_USER_CANCEL.getCode());
                intent.putExtra("oauth_error_desc", OAuthErrorCode.CLIENT_USER_CANCEL.getDescription());
            }
            OAuthLoginActivity.this.onActivityResult(CUSTOMTAB_LOGIN, -1, intent);
        }
    };

    private boolean initData(Bundle savedInstanceState) {
        this.context = this;
        OAuthLoginPreferenceManager pref = new OAuthLoginPreferenceManager(this.context);
        String clientId = pref.getClientId();
        String clientSecret = pref.getClientSecret();
        String callbackUrl = pref.getCallbackUrl();
        String state = null == savedInstanceState ? null : savedInstanceState.getString("OAuthLoginData_state");
        this.clientName = pref.getClientName();
        if (TextUtils.isEmpty((CharSequence)clientId)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTID);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)clientSecret)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTSECRET);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.clientName)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTNAME);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)callbackUrl)) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CALLBACKURL);
            return false;
        }
        this.oauthLoginData = new OAuthLoginData(clientId, clientSecret, callbackUrl, state);
        return true;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.d(TAG, "onCreate()");
        if (!this.initData(savedInstanceState)) {
            return;
        }
        if (null != savedInstanceState) {
            this.isLoginActivityStarted = savedInstanceState.getBoolean("IsLoginActivityStarted");
        }
        if (!this.isLoginActivityStarted) {
            this.isLoginActivityStarted = true;
            Logger.d(TAG, "onCreate() first");
            this.runOnlyOnce();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.isForceDestroyed) {
            OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(this.context);
            prefMng.setLastErrorCode(OAuthErrorCode.ACTIVITY_IS_SINGLE_TASK);
            prefMng.setLastErrorDesc("OAuthLoginActivity is destroyed.");
            OAuthLogin.oauthLoginHandler.run(false);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Logger.d(TAG, "onRestoreInstanceState()");
        if (null != savedInstanceState) {
            this.isLoginActivityStarted = savedInstanceState.getBoolean("IsLoginActivityStarted");
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Logger.d(TAG, "Login onSaveInstanceState()");
        outState.putBoolean("IsLoginActivityStarted", this.isLoginActivityStarted);
        outState.putString("OAuthLoginData_state", this.oauthLoginData.getInitState());
    }

    private void startLoginActivity(OAuthLoginData mOAuthLoginData) {
        Logger.d(TAG, "startLoginActivity()");
        if (OAuthLoginDefine.LOGIN_BY_NAVERAPP_ONLY) {
            this.tryOAuthByNaverapp(mOAuthLoginData);
            return;
        }
        if (OAuthLoginDefine.LOGIN_BY_CUSTOM_TAB_ONLY) {
            this.tryOAuthByCustomTab(mOAuthLoginData);
            return;
        }
        if (OAuthLoginDefine.LOGIN_BY_WEBVIEW_ONLY) {
            this.startLoginWebviewActivity(mOAuthLoginData);
            return;
        }
        if (!OAuthLoginDefine.LOGIN_BY_WEBVIEW_ONLY) {
            if (this.tryOAuthByNaverapp(mOAuthLoginData)) {
                return;
            }
            if (this.tryOAuthByCustomTab(mOAuthLoginData)) {
                return;
            }
        }
        this.startLoginWebviewActivity(mOAuthLoginData);
    }

    private boolean isEnableDoNotKeepActivity() {
        int flag = Build.VERSION.SDK_INT < 17 ? Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"always_finish_activities", (int)0) : Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)"always_finish_activities", (int)0);
        return flag == 1;
    }

    private boolean tryOAuthByNaverapp(OAuthLoginData loginData) {
        try {
            Intent intent = this.newParamIntent(loginData.getClientId(), loginData.getInitState(), loginData.getCallbackUrl());
            intent.putExtra("app_name", this.clientName);
            if (DeviceAppInfo.isIntentFilterExist(this.context, "com.nhn.android.search", "com.nhn.android.search.action.OAUTH2_LOGIN")) {
                Logger.d(TAG, "startLoginActivity() with naapp");
                intent.setPackage("com.nhn.android.search");
                intent.setAction("com.nhn.android.search.action.OAUTH2_LOGIN");
                this.startActivityForResult(intent, REQUESTCODE_LOGIN);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean tryOAuthByCustomTab(OAuthLoginData loginData) {
        if (this.isEnableDoNotKeepActivity()) {
            return false;
        }
        if (!CustomTabsManager.isCustomTabAvailable((Context)this)) {
            return false;
        }
        CustomTabsManager manager = new CustomTabsManager((Context)this);
        manager.setCustomTabListener(this.customTabsListener);
        Intent intent = this.newParamIntent(OAuthCustomTabActivity.class, loginData.getClientId(), loginData.getInitState(), loginData.getCallbackUrl());
        intent.addFlags(65536);
        this.startActivityForResult(intent, CUSTOMTAB_LOGIN);
        return true;
    }

    private void startLoginWebviewActivity(OAuthLoginData loginData) {
        Logger.d(TAG, "startLoginActivity() with webview");
        this.startActivityForResult(this.newParamIntent(OAuthLoginInAppBrowserActivity.class, loginData.getClientId(), loginData.getInitState(), loginData.getCallbackUrl()), REQUESTCODE_LOGIN);
    }

    @NonNull
    private Intent newParamIntent(String clientId, String initState, String callbackUrl) {
        return this.newParamIntent(null, clientId, initState, callbackUrl);
    }

    @NonNull
    private Intent newParamIntent(Class<? extends Activity> nextActivity, String clientId, String initState, String callbackUrl) {
        Intent intent = nextActivity == null ? new Intent() : new Intent((Context)this, nextActivity);
        intent.putExtra("ClientId", clientId);
        intent.putExtra("ClientCallbackUrl", callbackUrl);
        intent.putExtra("state", initState);
        intent.putExtra("oauth_sdk_version", "4.3.2");
        return intent;
    }

    protected void onResume() {
        super.onResume();
        Logger.d(TAG, "onResume()");
    }

    public void onPause() {
        super.onPause();
        Logger.d(TAG, "onPause()");
    }

    private void runOnlyOnce() {
        if (this.oauthLoginData == null) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_ERROR_NO_CLIENTID);
            return;
        }
        this.startLoginActivity(this.oauthLoginData);
    }

    private void finishWithErrorResult(OAuthErrorCode errCode) {
        Logger.d(TAG, "Login finishWithErrorResult()");
        Intent intent = new Intent();
        OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(this.context);
        prefMng.setLastErrorCode(errCode);
        prefMng.setLastErrorDesc(errCode.getDescription());
        intent.putExtra("oauth_error_code", errCode.getCode());
        intent.putExtra("oauth_error_desc", errCode.getDescription());
        this.setResult(0, intent);
        this.finish();
        this.propagationResult(false);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.isForceDestroyed = false;
        if (requestCode == CUSTOMTAB_LOGIN && resultCode == 0) {
            Logger.d(TAG, "activity call by customtab");
            return;
        }
        if (data == null) {
            this.finishWithErrorResult(OAuthErrorCode.CLIENT_USER_CANCEL);
            return;
        }
        String state = data.getStringExtra("oauth_state");
        String code = data.getStringExtra("oauth_code");
        String errorCode = data.getStringExtra("oauth_error_code");
        String errorDesc = data.getStringExtra("oauth_error_desc");
        this.oauthLoginData.setMiddleResult(code, state, errorCode, errorDesc);
        if (TextUtils.isEmpty((CharSequence)code)) {
            OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(this.context);
            prefMng.setLastErrorCode(OAuthErrorCode.fromString(errorCode));
            prefMng.setLastErrorDesc(errorDesc);
            this.setResult(0, data);
            this.finish();
            this.propagationResult(false);
        } else {
            new GetAccessTokenTask().execute(new Void[0]);
        }
    }

    private void propagationResult(boolean b) {
        if (OAuthLogin.oauthLoginHandler != null) {
            Message msg = new Message();
            msg.what = b ? 1 : 0;
            OAuthLogin.oauthLoginHandler.sendMessage(msg);
        }
    }

    private class GetAccessTokenTask
    extends AsyncTask<Void, Void, OAuthResponse> {
        private GetAccessTokenTask() {
        }

        protected void onPreExecute() {
            try {
                OAuthLoginActivity.this.oauthLoginDialogManager.showProgressDlg(OAuthLoginActivity.this.context, OAuthLoginActivity.this.context.getString(R.string.naveroauthlogin_string_getting_token), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected OAuthResponse doInBackground(Void ... params) {
            try {
                return OAuthLoginConnection.requestAccessToken(OAuthLoginActivity.this.context, OAuthLoginActivity.this.oauthLoginData.getClientId(), OAuthLoginActivity.this.oauthLoginData.getClientSecret(), OAuthLoginActivity.this.oauthLoginData.getState(), OAuthLoginActivity.this.oauthLoginData.getCode());
            }
            catch (Exception e) {
                return new OAuthResponse(OAuthErrorCode.CLIENT_ERROR_CONNECTION_ERROR);
            }
        }

        protected void onPostExecute(OAuthResponse res) {
            try {
                OAuthLoginActivity.this.oauthLoginDialogManager.hideProgressDlg();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Intent intent = new Intent();
                OAuthLoginPreferenceManager prefMng = new OAuthLoginPreferenceManager(OAuthLoginActivity.this.context);
                if (res.isSuccess()) {
                    prefMng.setAccessToken(res.getAccessToken());
                    prefMng.setRefreshToken(res.getRefreshToken());
                    prefMng.setExpiresAt(System.currentTimeMillis() / 1000L + res.getExpiresIn());
                    prefMng.setTokenType(res.getTokenType());
                    prefMng.setLastErrorCode(OAuthErrorCode.NONE);
                    prefMng.setLastErrorDesc(OAuthErrorCode.NONE.getDescription());
                    intent.putExtra("oauth_access_token", res.getAccessToken());
                    intent.putExtra("oauth_refresh_token", res.getRefreshToken());
                    intent.putExtra("oauth_expires_in", res.getExpiresIn());
                    intent.putExtra("oauth_token_type", res.getTokenType());
                    OAuthLoginActivity.this.setResult(-1, intent);
                } else {
                    if (res.getErrorCode() == OAuthErrorCode.NONE) {
                        OAuthLoginActivity.this.finishWithErrorResult(OAuthErrorCode.CLIENT_USER_CANCEL);
                        return;
                    }
                    prefMng.setLastErrorCode(res.getErrorCode());
                    prefMng.setLastErrorDesc(res.getErrorDescription());
                    intent.putExtra("oauth_error_code", res.getErrorCode().getCode());
                    intent.putExtra("oauth_error_desc", res.getErrorDescription());
                    OAuthLoginActivity.this.setResult(0, intent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            OAuthLoginActivity.this.finish();
            try {
                OAuthLoginActivity.this.propagationResult(res.isSuccess());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

