/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.ui;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentTransaction;
import com.navercorp.naverid.internal.log.Logger;
import com.nhn.android.idp.common.connection.NetworkState;
import com.nhn.android.idp.common.util.DeviceAppInfo;
import com.nhn.android.naverlogin.connection.gen.OAuthQueryGenerator;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import com.nhn.android.naverlogin.data.OAuthLoginData;
import com.nhn.android.naverlogin.ui.OAuthWebviewUrlUtil;
import com.nhn.android.naverlogin.ui.view.CustomTabDialogFragment;
import com.nhn.android.naverlogin.util.CustomTabsManager;
import java.util.List;

@RequiresApi(api=16)
public class OAuthCustomTabActivity
extends FragmentActivity {
    public static final String TAG = "OAuthCustomTabActivity";
    public static final String SAVE_CUSTOM_TAB_OPEN = "isCustomTabOpen";
    private boolean mIsCustomTabOpen = false;
    private boolean isCalledNewIntent = false;
    private CustomTabsManager mCustomTabManager;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            Logger.d(TAG, "Open Custom Tab Activity");
            this.mCustomTabManager = new CustomTabsManager((Context)this);
        }
        if (savedInstanceState != null && savedInstanceState.getBoolean(SAVE_CUSTOM_TAB_OPEN, false)) {
            this.onNewIntent(this.getIntent());
        }
    }

    private void initIntentData() {
        Intent oauthParam = this.getIntent();
        if (oauthParam != null) {
            Logger.d(TAG, "read request");
            String clientId = oauthParam.getStringExtra("ClientId");
            String callbackUrl = oauthParam.getStringExtra("ClientCallbackUrl");
            String state = oauthParam.getStringExtra("state");
            String locale = DeviceAppInfo.getBaseInstance().getLocaleString((Context)this);
            String network = NetworkState.getNetworkState((Context)this);
            OAuthLoginData oauthLoginData = new OAuthLoginData(clientId, null, callbackUrl, state);
            String oauthUrl = new OAuthQueryGenerator().generateRequestCustomTabAuthorizationUrl(clientId, oauthLoginData.getInitState(), callbackUrl, locale, network, "4.3.2");
            this.openCustomTab(oauthUrl);
        }
    }

    private void openCustomTab(final String oauthUrl) {
        List<PackageInfo> customTabsPackages = CustomTabsManager.getCustomTabsPackages((Context)this);
        if (customTabsPackages.size() == 1) {
            this.mIsCustomTabOpen = true;
            this.mCustomTabManager.launchUrl(customTabsPackages.get((int)0).packageName, oauthUrl);
            return;
        }
        FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
        Fragment prev = this.getSupportFragmentManager().findFragmentByTag("CUSTOM_TAB_SELECTOR");
        if (prev != null) {
            ft.remove(prev);
        }
        ft.addToBackStack(null);
        CustomTabDialogFragment fragment = CustomTabDialogFragment.newInstance(customTabsPackages);
        fragment.setPackageSelectListener(new CustomTabDialogFragment.OnPackageSelectListener(){

            @Override
            public void onPackageSelect(PackageInfo packageInfo) {
                if (packageInfo == null) {
                    OAuthCustomTabActivity.this.responseError(null, OAuthErrorCode.CLIENT_USER_CANCEL.getCode(), OAuthErrorCode.CLIENT_USER_CANCEL.getDescription());
                    return;
                }
                OAuthCustomTabActivity.this.mIsCustomTabOpen = true;
                OAuthCustomTabActivity.this.mCustomTabManager.launchUrl(packageInfo.packageName, oauthUrl);
            }
        });
        fragment.show(ft, "CUSTOM_TAB_SELECTOR");
    }

    protected void onResume() {
        super.onResume();
        if (this.mIsCustomTabOpen) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (OAuthCustomTabActivity.this.isCalledNewIntent) {
                        return;
                    }
                    OAuthCustomTabActivity.this.responseError(null, OAuthErrorCode.CLIENT_USER_CANCEL.getCode(), OAuthErrorCode.CLIENT_USER_CANCEL.getDescription());
                }
            }, 500L);
        } else {
            this.initIntentData();
        }
    }

    private void returnResult(@NonNull Intent data) {
        data.setAction("ACTION_NAVER_3RDPARTY_CUSTOM_TAB");
        if (this.mCustomTabManager == null) {
            this.mCustomTabManager = new CustomTabsManager((Context)this);
        }
        this.mCustomTabManager.sendCustomTabResult(data);
        this.setResult(0);
        this.finish();
    }

    protected void onNewIntent(Intent intent) {
        Logger.d(TAG, "open by Intent url");
        this.isCalledNewIntent = true;
        String code = intent.getStringExtra("code");
        String state = intent.getStringExtra("state");
        String error = intent.getStringExtra("error");
        String errorDescription = OAuthWebviewUrlUtil.getDecodedString(intent.getStringExtra("error_description"));
        if (code != null || error != null) {
            this.responseResult(code, state, error, errorDescription);
        } else {
            this.responseError(state, OAuthErrorCode.CLIENT_ERROR_PARSING_FAIL.getCode(), OAuthErrorCode.CLIENT_ERROR_PARSING_FAIL.getDescription());
        }
    }

    private void responseResult(String code, String state, String error, String errorDescription) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra("oauth_code", code);
        resultIntent.putExtra("oauth_state", state);
        resultIntent.putExtra("oauth_error_code", error);
        resultIntent.putExtra("oauth_error_desc", errorDescription);
        this.returnResult(resultIntent);
    }

    private void responseError(String state, String code, String desc) {
        Intent intent = new Intent();
        intent.putExtra("oauth_state", state);
        intent.putExtra("oauth_error_code", code);
        intent.putExtra("oauth_error_desc", desc);
        this.returnResult(intent);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Logger.d(TAG, "load custom tab open state");
        this.mIsCustomTabOpen = savedInstanceState.getBoolean(SAVE_CUSTOM_TAB_OPEN, false);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Logger.d(TAG, "save custom tab open state");
        outState.putBoolean(SAVE_CUSTOM_TAB_OPEN, this.mIsCustomTabOpen);
        this.mCustomTabManager = new CustomTabsManager((Context)this);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }
}

