/*
 * Decompiled with CFR 0.152.
 */
package com.nhn.android.naverlogin.data;

import android.text.TextUtils;
import com.nhn.android.naverlogin.data.OAuthErrorCode;
import java.util.Map;

public class OAuthResponse {
    private String resultValue;
    private String accessToken;
    private long expiresIn;
    private String refreshToken;
    private String tokenType;
    private OAuthErrorCode errorCode;
    private String errorDescription;

    public OAuthResponse(Map<String, String> ret) {
        this.accessToken = ret.get("access_token");
        this.refreshToken = ret.get("refresh_token");
        this.tokenType = ret.get("token_type");
        try {
            this.expiresIn = Long.parseLong(ret.get("expires_in"));
        }
        catch (Exception e) {
            this.expiresIn = 3600L;
        }
        this.errorCode = OAuthErrorCode.fromString(ret.get("error"));
        this.errorDescription = ret.get("error_description");
        this.resultValue = ret.get("result");
    }

    public OAuthResponse(OAuthErrorCode errorCode) {
        this.errorCode = errorCode;
        this.errorDescription = errorCode.getDescription();
    }

    public OAuthResponse(OAuthErrorCode errorCode, String errorDescription) {
        this.errorCode = errorCode;
        this.errorDescription = errorDescription;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public OAuthErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public String getResultValue() {
        return this.resultValue;
    }

    public boolean isSuccess() {
        if (TextUtils.isEmpty((CharSequence)this.errorCode.getCode())) {
            return !TextUtils.isEmpty((CharSequence)this.accessToken);
        }
        return false;
    }
}

